/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.factory;

import com.clustercontrol.jobmanagement.bean.OperationConstant;
import com.clustercontrol.jobmanagement.ejb.entity.JobCommandInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobNoticeInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobNoticeInfoPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobNoticeInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartInfoLocal;
import com.clustercontrol.jobmanagement.util.SendEvent;
import com.clustercontrol.monitor.message.LogOutputNotifyInfo;
import com.clustercontrol.util.Messages;
import java.util.Date;
import javax.ejb.FinderException;
import javax.jms.JMSException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Notice {
    protected static Log m_log = LogFactory.getLog(Notice.class);

    public void notify(String sessionId, String jobId, Integer type) throws FinderException, NamingException {
        m_log.debug((Object)("notify() : sessionId=" + sessionId + ", jobId=" + jobId + ", type=" + type));
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        JobInfoLocal job = sessionJob.getJobInfo();
        JobNoticeInfoLocal notice = JobNoticeInfoUtil.getLocalHome().findByPrimaryKey(new JobNoticeInfoPK(sessionId, jobId, type));
        if (notice.getNotify_id() != null && notice.getNotify_id().length() > 0) {
            Object[] args1;
            LogOutputNotifyInfo info = new LogOutputNotifyInfo();
            info.setPluginId("JOB");
            info.setApplication(Messages.getString((String)"job.management"));
            info.setMonitorId(sessionId);
            if (type == 3) {
                info.setMessageId("001");
                args1 = new String[]{jobId};
                info.setMessage(Messages.getString((String)"message.job.38", (Object[])args1));
            } else if (type == 0) {
                info.setMessageId("002");
                args1 = new String[]{jobId};
                info.setMessage(Messages.getString((String)"message.job.39", (Object[])args1));
            } else if (type == 1) {
                info.setMessageId("003");
                args1 = new String[]{jobId};
                info.setMessage(Messages.getString((String)"message.job.40", (Object[])args1));
            } else if (type == 2) {
                info.setMessageId("004");
                args1 = new String[]{jobId};
                info.setMessage(Messages.getString((String)"message.job.41", (Object[])args1));
            }
            if (job.getJob_type() == 2) {
                JobCommandInfoLocal command = job.getJobCommandInfo();
                info.setFacilityId(command.getFacility_id());
                info.setScopeText(sessionJob.getScope_text());
            } else {
                info.setFacilityId("");
                info.setScopeText("");
            }
            info.setPriority(notice.getPriority().intValue());
            info.setGenerationDate(new Date());
            info.setNotifyId(notice.getNotify_id());
            try {
                new SendEvent().put(info);
            }
            catch (JMSException e) {
            }
            catch (NamingException e) {
                // empty catch block
            }
        }
    }

    public void delayNotify(String sessionId, String jobId, boolean startDelay) throws FinderException, NamingException {
        m_log.debug((Object)("delayNotify() : sessionId=" + sessionId + ", jobId=" + jobId + ", startDelay=" + startDelay));
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        JobInfoLocal job = sessionJob.getJobInfo();
        JobStartInfoLocal start = job.getJobStartInfo();
        JobNoticeInfoLocal notice = JobNoticeInfoUtil.getLocalHome().findByPrimaryKey(new JobNoticeInfoPK(sessionId, jobId, new Integer(0)));
        if (notice.getNotify_id() != null && notice.getNotify_id().length() > 0) {
            Object[] args1;
            LogOutputNotifyInfo info = new LogOutputNotifyInfo();
            info.setPluginId("JOB");
            info.setApplication(Messages.getString((String)"job.management"));
            info.setMonitorId(sessionId);
            StringBuilder message = new StringBuilder();
            if (startDelay) {
                info.setMessageId("101");
                args1 = new String[]{jobId};
                message.append(Messages.getString((String)"message.job.55", (Object[])args1));
                if (start.getStart_delay_operation() == 1) {
                    int type = start.getStart_delay_operation_type();
                    Object[] args2 = new String[]{OperationConstant.typeToString((int)type)};
                    message.append(" " + Messages.getString((String)"message.job.57", (Object[])args2));
                    if (type == 4) {
                        info.setMessageId("102");
                        Object[] args3 = new String[]{start.getStart_delay_operation_end_value().toString()};
                        message.append(" " + Messages.getString((String)"message.job.58", (Object[])args3));
                    } else if (type == 6) {
                        info.setMessageId("103");
                    }
                }
                info.setMessage(message.toString());
            } else {
                info.setMessageId("201");
                args1 = new String[]{jobId};
                message.append(Messages.getString((String)"message.job.56", (Object[])args1));
                if (start.getEnd_delay_operation() == 1) {
                    int type = start.getEnd_delay_operation_type();
                    Object[] args2 = new String[]{OperationConstant.typeToString((int)type)};
                    message.append(" " + Messages.getString((String)"message.job.57", (Object[])args2));
                    if (type == 0) {
                        info.setMessageId("202");
                    } else if (type == 2) {
                        info.setMessageId("203");
                    } else if (type == 10) {
                        info.setMessageId("204");
                    }
                }
                info.setMessage(message.toString());
            }
            if (job.getJob_type() == 2) {
                JobCommandInfoLocal command = job.getJobCommandInfo();
                info.setFacilityId(command.getFacility_id());
                info.setScopeText(sessionJob.getScope_text());
            } else {
                info.setFacilityId("");
                info.setScopeText("");
            }
            if (startDelay) {
                info.setPriority(start.getStart_delay_notify_priority().intValue());
            } else {
                info.setPriority(start.getEnd_delay_notify_priority().intValue());
            }
            info.setGenerationDate(new Date());
            info.setNotifyId(notice.getNotify_id());
            try {
                new SendEvent().put(info);
            }
            catch (JMSException e) {
            }
            catch (NamingException e) {
                // empty catch block
            }
        }
    }
}

