/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.accesscontrol.dao;

import com.clustercontrol.accesscontrol.dao.RoleDAO;
import com.clustercontrol.accesscontrol.ejb.entity.RoleBean;
import com.clustercontrol.accesscontrol.ejb.entity.RolePK;
import com.clustercontrol.accesscontrol.util.LdapConnectionManager;
import com.clustercontrol.util.apllog.AplLogger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RoleDAOImpl
implements RoleDAO {
    protected static Log m_log = LogFactory.getLog(RoleDAOImpl.class);
    protected static final String OBJECTCLASS = "objectClass";
    protected static final String BASE_DN = "ou=roles";
    protected static final String OBJECT_CLASS_ROLE = "ccRole";

    public void init() {
    }

    public void load(RolePK pk, RoleBean ejb) throws EJBException {
        DirContext ctx = null;
        try {
            this.clearBean(ejb);
            ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            Attributes attrs = ctx.getAttributes(pk.getDn());
            ejb.setDn(pk.getDn());
            ejb.setCn((String)attrs.get("cn").get(0));
            if (attrs.get("description") != null) {
                ejb.setDescription((String)attrs.get("description").get(0));
            }
            if (attrs.get("ccCreateTimestamp") != null) {
                ejb.setCreateTimestamp(this.stringToDate((String)attrs.get("ccCreateTimestamp").get(0)));
            }
            if (attrs.get("ccCreatorsName") != null) {
                ejb.setCreatorsName((String)attrs.get("ccCreatorsName").get(0));
            }
            if (attrs.get("ccModifiersName") != null) {
                ejb.setModifiersName((String)attrs.get("ccModifiersName").get(0));
            }
            if (attrs.get("ccModifyTimestamp") != null) {
                ejb.setModifyTimestamp(this.stringToDate((String)attrs.get("ccModifyTimestamp").get(0)));
            }
            if (attrs.get("member") != null) {
                NamingEnumeration<?> hosts = attrs.get("member").getAll();
                ArrayList<String> memberList = new ArrayList<String>();
                while (hosts.hasMoreElements()) {
                    String member = (String)hosts.nextElement();
                    memberList.add(member);
                }
                ejb.setMember(memberList);
                hosts.close();
            }
        }
        catch (NamingException ex) {
            if (ex instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            throw new EJBException((Exception)ex);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {}
        }
    }

    public void store(RoleBean ejb) throws EJBException {
        DirContext ctx = null;
        try {
            ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            Attributes attrs = ctx.getAttributes(ejb.getDn());
            BasicAttributes addAttrs = new BasicAttributes();
            BasicAttributes replaceAttrs = new BasicAttributes();
            BasicAttributes removeAttrs = new BasicAttributes();
            if (attrs.get("description") == null && ejb.getDescription() != null) {
                addAttrs.put("description", ejb.getDescription());
            } else if (attrs.get("description") != null && ejb.getDescription() == null) {
                removeAttrs.put("description", null);
            } else if (attrs.get("description") != null && ejb.getDescription() != null) {
                replaceAttrs.put("description", ejb.getDescription());
            }
            if (attrs.get("ccCreateTimestamp") == null && ejb.getCreateTimestamp() != null) {
                addAttrs.put("ccCreateTimestamp", this.dateToString(ejb.getCreateTimestamp()));
            } else if (attrs.get("ccCreateTimestamp") != null && ejb.getCreateTimestamp() == null) {
                removeAttrs.put("ccCreateTimestamp", null);
            } else if (attrs.get("ccCreateTimestamp") != null && ejb.getCreateTimestamp() != null) {
                replaceAttrs.put("ccCreateTimestamp", this.dateToString(ejb.getCreateTimestamp()));
            }
            if (attrs.get("ccCreatorsName") == null && ejb.getCreatorsName() != null) {
                addAttrs.put("ccCreatorsName", ejb.getCreatorsName());
            } else if (attrs.get("ccCreatorsName") != null && ejb.getCreatorsName() == null) {
                removeAttrs.put("ccCreatorsName", null);
            } else if (attrs.get("ccCreatorsName") != null && ejb.getCreatorsName() != null) {
                replaceAttrs.put("ccCreatorsName", ejb.getCreatorsName());
            }
            if (attrs.get("ccModifiersName") == null && ejb.getModifiersName() != null) {
                addAttrs.put("ccModifiersName", ejb.getModifiersName());
            } else if (attrs.get("ccModifiersName") != null && ejb.getModifiersName() == null) {
                removeAttrs.put("ccModifiersName", null);
            } else if (attrs.get("ccModifiersName") != null && ejb.getModifiersName() != null) {
                replaceAttrs.put("ccModifiersName", ejb.getModifiersName());
            }
            if (attrs.get("ccModifyTimestamp") == null && ejb.getModifyTimestamp() != null) {
                addAttrs.put("ccModifyTimestamp", this.dateToString(ejb.getModifyTimestamp()));
            } else if (attrs.get("ccModifyTimestamp") != null && ejb.getModifyTimestamp() == null) {
                removeAttrs.put("ccModifyTimestamp", null);
            } else if (attrs.get("ccModifyTimestamp") != null && ejb.getModifyTimestamp() != null) {
                replaceAttrs.put("ccModifyTimestamp", this.dateToString(ejb.getModifyTimestamp()));
            }
            if (attrs.get("member") == null && ejb.getMember() != null) {
                BasicAttribute attr = new BasicAttribute("member");
                ArrayList list = ejb.getMember();
                for (int i = 0; i < list.size(); ++i) {
                    String member = (String)list.get(i);
                    attr.add(i, member);
                }
                if (attr.size() > 0) {
                    addAttrs.put(attr);
                }
            } else if (attrs.get("member") != null && ejb.getMember() == null) {
                removeAttrs.put("member", null);
            } else if (attrs.get("member") != null && ejb.getMember() != null) {
                BasicAttribute attr = new BasicAttribute("member");
                ArrayList list = ejb.getMember();
                for (int i = 0; i < list.size(); ++i) {
                    String member = (String)list.get(i);
                    attr.add(i, member);
                }
                replaceAttrs.put(attr);
            }
            ctx.modifyAttributes(ejb.getDn(), 1, (Attributes)addAttrs);
            ctx.modifyAttributes(ejb.getDn(), 2, (Attributes)replaceAttrs);
            ctx.modifyAttributes(ejb.getDn(), 3, (Attributes)removeAttrs);
        }
        catch (NamingException ex) {
            if (ex instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            throw new EJBException((Exception)ex);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {}
        }
    }

    public void remove(RolePK pk) throws RemoveException, EJBException {
        DirContext ctx = null;
        try {
            ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            ctx.destroySubcontext(pk.getDn());
        }
        catch (NamingException ex) {
            if (ex instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            AplLogger apllog = new AplLogger("ACC", "acc");
            Object[] args = new String[]{pk.getDn()};
            apllog.put("SYS", "005", args);
            throw new EJBException((Exception)ex);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {}
        }
    }

    public RolePK create(RoleBean ejb) throws CreateException, EJBException {
        RolePK pk = null;
        DirContext ctx = null;
        try {
            ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            BasicAttributes attrs = new BasicAttributes();
            BasicAttribute attr = new BasicAttribute(OBJECTCLASS);
            attr.add(0, OBJECT_CLASS_ROLE);
            attrs.put(attr);
            attrs.put("cn", ejb.getCn());
            StringBuffer dn = new StringBuffer();
            dn.append("cn");
            dn.append("=");
            dn.append(ejb.getCn());
            dn.append(",");
            dn.append(BASE_DN);
            ejb.setDn(dn.toString());
            ctx.createSubcontext(ejb.getDn(), (Attributes)attrs);
            pk = new RolePK(ejb.getDn());
        }
        catch (NamingException ex) {
            if (ex instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            AplLogger apllog = new AplLogger("ACC", "acc");
            Object[] args = new String[]{ejb.getDn()};
            apllog.put("SYS", "004", args);
            throw new EJBException((Exception)ex);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {}
        }
        return pk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findAll() throws FinderException {
        ArrayList<RolePK> ret = new ArrayList<RolePK>();
        m_log.debug((Object)"findAll()");
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        StringBuffer search = new StringBuffer();
        search.append("(&(");
        search.append(OBJECTCLASS);
        search.append("=");
        search.append(OBJECT_CLASS_ROLE);
        search.append("))");
        NamingEnumeration<SearchResult> results = null;
        DirContext ctx = null;
        try {
            ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            results = ctx.search(BASE_DN, search.toString(), constraints);
            if (results == null) {
                m_log.debug((Object)"findAll() : No Search Result");
                ArrayList<RolePK> arrayList = ret;
                return arrayList;
            }
            while (results.hasMoreElements()) {
                SearchResult aResult = (SearchResult)results.nextElement();
                RolePK pk = new RolePK(aResult.getName() + "," + BASE_DN);
                ret.add(pk);
            }
        }
        catch (NamingException e) {
            if (e instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            m_log.debug((Object)("findAll() : " + e.getMessage()));
        }
        finally {
            try {
                if (results != null) {
                    results.close();
                }
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {}
        }
        return ret;
    }

    public RolePK findByPrimaryKey(RolePK pk) throws FinderException {
        Context ctx = null;
        try {
            m_log.debug((Object)("findByPrimaryKey() : dn = " + pk.getDn()));
            ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            Attributes attrs = ctx.getAttributes(pk.getDn());
            attrs.hashCode();
            RolePK rolePK = pk;
            return rolePK;
        }
        catch (NamingException ex) {
            if (ex instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            m_log.debug((Object)("findByPrimaryKey() : " + ex.getMessage()));
            throw new FinderException("dn=" + pk.getDn() + " not found.");
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {}
        }
    }

    public RolePK findByCn(String cn) throws FinderException {
        m_log.debug((Object)("findByCn() : cn = " + cn));
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        StringBuffer search = new StringBuffer();
        search.append("(&(");
        search.append(OBJECTCLASS);
        search.append("=");
        search.append(OBJECT_CLASS_ROLE);
        search.append(")(");
        search.append("cn");
        search.append("=");
        search.append(cn);
        search.append("))");
        NamingEnumeration<SearchResult> results = null;
        DirContext ctx = null;
        RolePK pk = null;
        try {
            ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            results = ctx.search(BASE_DN, search.toString(), constraints);
            if (results == null) {
                throw new FinderException("cn=" + cn + " not found.");
            }
            SearchResult aResult = null;
            Attributes attrs = null;
            if (results.hasMoreElements()) {
                aResult = (SearchResult)results.nextElement();
                attrs = aResult.getAttributes();
            }
            if (attrs == null) {
                throw new FinderException("cn=" + cn + " not found.");
            }
            pk = new RolePK(aResult.getName() + "," + BASE_DN);
        }
        catch (NamingException e) {
            if (e instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            m_log.debug((Object)("findByCn() : " + e.getMessage()));
            throw new FinderException("cn=" + cn + " not found.");
        }
        finally {
            try {
                if (results != null) {
                    results.close();
                }
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {}
        }
        return pk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findByMember(String dn) throws FinderException {
        ArrayList<RolePK> ret = new ArrayList<RolePK>();
        m_log.debug((Object)("findByMember() : dn = " + dn));
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        StringBuffer search = new StringBuffer();
        search.append("(&(");
        search.append(OBJECTCLASS);
        search.append("=");
        search.append(OBJECT_CLASS_ROLE);
        search.append(")(");
        search.append("member");
        search.append("=");
        search.append(dn);
        search.append("))");
        NamingEnumeration<SearchResult> results = null;
        DirContext ctx = null;
        try {
            ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            results = ctx.search(BASE_DN, search.toString(), constraints);
            if (results == null) {
                m_log.debug((Object)("findByMember() : No Search Result : dn = " + dn));
                ArrayList<RolePK> arrayList = ret;
                return arrayList;
            }
            while (results.hasMoreElements()) {
                SearchResult aResult = (SearchResult)results.nextElement();
                RolePK pk = new RolePK(aResult.getName() + "," + BASE_DN);
                ret.add(pk);
            }
        }
        catch (NamingException e) {
            if (e instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            m_log.debug((Object)("findByMember() : " + e.getMessage()));
        }
        finally {
            try {
                if (results != null) {
                    results.close();
                }
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {}
        }
        return ret;
    }

    public RolePK findByCnAndMenber(String cn, String dn) throws FinderException {
        m_log.debug((Object)("findByCnAndMenber() : cn = " + cn + ", dn = " + dn));
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        StringBuffer search = new StringBuffer();
        search.append("(&(");
        search.append(OBJECTCLASS);
        search.append("=");
        search.append(OBJECT_CLASS_ROLE);
        search.append(")(");
        search.append("cn");
        search.append("=");
        search.append(cn);
        search.append(")(");
        search.append("member");
        search.append("=");
        search.append(dn);
        search.append("))");
        NamingEnumeration<SearchResult> results = null;
        DirContext ctx = null;
        RolePK pk = null;
        try {
            ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            results = ctx.search(BASE_DN, search.toString(), constraints);
            if (results == null) {
                throw new FinderException("cn=" + cn + ", dn = " + dn + " not found.");
            }
            SearchResult aResult = null;
            Attributes attrs = null;
            if (results.hasMoreElements()) {
                aResult = (SearchResult)results.nextElement();
                attrs = aResult.getAttributes();
            }
            if (attrs == null) {
                throw new FinderException("cn=" + cn + ", dn = " + dn + " not found.");
            }
            pk = new RolePK(aResult.getName() + "," + BASE_DN);
        }
        catch (NamingException e) {
            if (e instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            m_log.debug((Object)("findByCnAndMenber() : " + e.getMessage()));
            throw new FinderException("cn=" + cn + ", dn = " + dn + " not found.");
        }
        finally {
            try {
                if (results != null) {
                    results.close();
                }
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {}
        }
        return pk;
    }

    public Boolean stringToBoolean(String value) {
        Boolean ret = null;
        ret = value.compareTo("TRUE") == 0 ? new Boolean(true) : new Boolean(false);
        return ret;
    }

    public String booleanToString(Boolean value) {
        String ret = null;
        ret = value != false ? "TRUE" : "FALSE";
        return ret;
    }

    public Date stringToDate(String value) {
        Date ret = null;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss.SSS");
        try {
            ret = formatter.parse(value);
        }
        catch (ParseException e) {
            // empty catch block
        }
        return ret;
    }

    public String dateToString(Date value) {
        String ret = null;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss.SSSZ");
        ret = formatter.format(value);
        return ret;
    }

    protected void clearBean(RoleBean ejb) {
        ejb.setDn(null);
        ejb.setCn(null);
        ejb.setMember(null);
        ejb.setDescription(null);
        ejb.setCreateTimestamp(null);
        ejb.setCreatorsName(null);
        ejb.setModifiersName(null);
        ejb.setModifyTimestamp(null);
    }
}

