/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.view.action;

import com.clustercontrol.performance.action.RecordController;
import com.clustercontrol.performance.dialog.ExportDialog;
import com.clustercontrol.performance.util.Messages;
import com.clustercontrol.performance.view.CurrentListView;
import com.clustercontrol.performanceMGR.bean.CollectorProperty;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class ExportCollectedDataAction
implements IViewActionDelegate {
    public static final String ID = "com.clustercontrol.performance.view.action.ExportCollectedDataAction";
    private static ExportDialog exportDialog;
    private IViewPart viewPart;

    public void init(IViewPart view) {
        this.viewPart = view;
    }

    public void run(IAction action) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        CurrentListView listView = (CurrentListView)page.findView(Messages.getString("VIEW_CURRENT_LIST"));
        String collectorID = listView.getSelectedID();
        if (collectorID != null) {
            if (!RecordController.getInstance().checkPermissionRead()) {
                MessageDialog.openInformation(null, (String)com.clustercontrol.util.Messages.getString((String)"message"), (String)com.clustercontrol.util.Messages.getString((String)"message.accesscontrol.16"));
                return;
            }
            RecordController controller = RecordController.getInstance();
            if (controller == null) {
                MessageDialog.openError((Shell)this.viewPart.getSite().getShell(), (String)Messages.getString("MESSAGE_0020"), (String)Messages.getString("CONNECTION_ERROR_MESSAGE"));
                return;
            }
            controller.lock(collectorID);
            CollectorProperty property = controller.getCollectorProperty(collectorID);
            if (property == null) {
                MessageDialog.openError((Shell)this.viewPart.getSite().getShell(), (String)Messages.getString("MESSAGE_0020"), (String)Messages.getString("GET_PROPERTY_ERROR_MESSAGE"));
                return;
            }
            if (property.getCollectorData().getCount() <= 0) {
                MessageDialog.openError((Shell)this.viewPart.getSite().getShell(), (String)Messages.getString("MESSAGE_0020"), (String)Messages.getString("INSUFFICIENT_DATA"));
                return;
            }
            Shell shell = new Shell();
            exportDialog = new ExportDialog(shell);
            exportDialog.setCollectorProperty(property);
            exportDialog.open();
            controller.unlock();
        } else {
            String msg = Messages.getString("MESSAGE_0014");
            MessageDialog.openError(null, (String)Messages.getString("ERROR_IN_JP"), (String)msg);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

