/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.view;

import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.performance.action.RecordController;
import com.clustercontrol.performance.bean.GraphProperty;
import com.clustercontrol.performance.composite.RealtimeGraphComposite;
import com.clustercontrol.performance.composite.RecordGraphHolderComposite;
import com.clustercontrol.performance.preference.PerformancePreferencePage;
import com.clustercontrol.performance.util.CollectorItemCodeFactory;
import com.clustercontrol.performance.util.Messages;
import com.clustercontrol.performance.util.RealtimeCollectorInfo;
import com.clustercontrol.performance.util.RealtimeCollectorItemInfo;
import com.clustercontrol.performanceMGR.bean.CollectedDataInfo;
import com.clustercontrol.performanceMGR.bean.CollectedDataSet;
import com.clustercontrol.performanceMGR.bean.CollectorItemInfo;
import com.clustercontrol.performanceMGR.bean.CollectorProperty;
import com.clustercontrol.view.ScopeListBaseView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;

public class RecordGraphView
extends ScopeListBaseView {
    public static final String ID = Messages.getString("VIEW_RECORD_GRAPH");
    private RecordGraphHolderComposite graphCompositeR = null;
    public RealtimeGraphComposite graphComposite = null;
    private CollectorProperty collectorProperty;
    public RealtimeCollectorInfo collectorInfo;
    public RealtimeCollectorItemInfo collectorItemInfo;
    private Composite parent;
    public FacilityTreeItem item;
    private PerformancePreferencePage perfPrePage;
    static boolean isRequestCollectorToRun = false;

    public RecordGraphView() {
        this.initialize();
    }

    private void initialize() {
        this.collectorInfo = new RealtimeCollectorInfo();
        this.collectorItemInfo = new RealtimeCollectorItemInfo();
        this.collectorInfo.setGraphPlotNum(0);
        this.perfPrePage = new PerformancePreferencePage();
    }

    protected void doSelectTreeItem(FacilityTreeItem item) {
        if (this.collectorProperty != null) {
            Label pathLabel = this.getPathLabel();
            pathLabel.setText(String.valueOf(this.getPathLabel().getText()) + " \n" + Messages.getString("COLLECTION_ID") + " : " + this.collectorProperty.getCollectorData().getCollectorID());
            this.getBaseComposite().layout(true, true);
        }
        if (this.collectorInfo.getFacilityId() == null || !this.collectorInfo.getFacilityId().equals(item.getData().getFacilityId())) {
            this.collectorInfo.setFacilityId(item.getData().getFacilityId());
            this.collectorInfo.setSubScopeNum(item.getChildren().length);
            FacilityTreeItem[] childrenList = item.getChildren();
            Arrays.sort(childrenList, new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (o1 instanceof FacilityTreeItem && o2 instanceof FacilityTreeItem) {
                        String object1 = ((FacilityTreeItem)o1).getData().getFacilityId();
                        String object2 = ((FacilityTreeItem)o2).getData().getFacilityId();
                        return object1.compareTo(object2);
                    }
                    return 0;
                }
            });
            if (item.getChildren().length > 0) {
                ArrayList<String> subScopeFacilityId = new ArrayList<String>();
                ArrayList<String> subScopeFacilityName = new ArrayList<String>();
                int i = 0;
                while (i < childrenList.length) {
                    subScopeFacilityId.add(childrenList[i].getData().getFacilityId());
                    subScopeFacilityName.add(childrenList[i].getData().getFacilityName());
                    ++i;
                }
                this.collectorInfo.setSubScopeFacilityId(subScopeFacilityId);
                this.collectorInfo.setSubScopeFacilityName(subScopeFacilityName);
            }
            this.update();
        }
    }

    public void initialize(CollectorProperty property) {
        if (this.graphComposite != null) {
            this.graphComposite.dispose();
            this.getPathLabel().setText(String.valueOf(Messages.getString("SCOPE")) + " : ");
            this.getBaseComposite().layout(true, true);
            this.collectorInfo.setFacilityId(null);
        }
        this.collectorProperty = property;
        this.item = this.collectorProperty.getCollectorData().getFacilityTree();
        this.getScopeTreeComposite().setScopeTree(this.collectorProperty.getCollectorData().getFacilityTree());
        int interval = property.getCollectorData().getInterval();
        this.collectorInfo.setInterval(interval);
        this.collectorInfo.setCollectStartTime(this.collectorProperty.getCollectorData().getStartDate());
        this.collectorInfo.setCollectEndTime(this.collectorProperty.getCollectorData().getStopDate());
        this.collectorInfo.setGraphStartTime(this.collectorProperty.getCollectorData().getStartDate());
        long startTime = this.collectorProperty.getCollectorData().getStartDate().getTime();
        this.collectorInfo.setGraphEndTime(new Date(startTime + (long)(interval * 1000 * 201)));
        this.collectorInfo.setGraphPlotNum(0);
        ArrayList itemList = this.collectorProperty.getItemList();
        this.collectorItemInfo.createItemInfoForCollector(itemList.size());
        int i = 0;
        while (i < itemList.size()) {
            CollectorItemInfo info = (CollectorItemInfo)itemList.get(i);
            this.collectorItemInfo.setItemInfoForCollector(i, info.getCollectorItemCode(), String.valueOf(info.getDeviceIndex()), String.valueOf(info.getCollectorItemID()), info.getDeviceName(), true);
            ++i;
        }
        i = 0;
        while (i < itemList.size()) {
            List factorySubItemCodeList = CollectorItemCodeFactory.getSubItemCode(this.collectorItemInfo.getItemCodeForCollector(i));
            String deviceIndex = this.collectorItemInfo.getIndexForCollector(i);
            boolean a = true;
            if (factorySubItemCodeList == null || factorySubItemCodeList.size() == 0) {
                a = false;
            } else {
                int m = 0;
                while (m < factorySubItemCodeList.size()) {
                    boolean c = false;
                    int n = 0;
                    while (n < this.collectorItemInfo.getItemNumForCollector()) {
                        if (this.collectorItemInfo.getItemCodeForCollector(n).equals(factorySubItemCodeList.get(m).toString()) && String.valueOf(deviceIndex).equals(this.collectorItemInfo.getIndexForCollector(n))) {
                            c = true;
                            break;
                        }
                        ++n;
                    }
                    if (!c) {
                        a = false;
                        break;
                    }
                    ++m;
                }
            }
            if (!a) {
                this.collectorItemInfo.isItemDetailedForCollector(i, false);
            }
            ++i;
        }
        if (itemList != null && itemList.size() > 0) {
            CollectorItemInfo info = (CollectorItemInfo)itemList.get(0);
            int i2 = 0;
            while (i2 < 4) {
                this.collectorItemInfo.setItemInfo(i2, info.getCollectorItemCode(), "NonDisplay", String.valueOf(info.getDeviceIndex()), "0", info.getDeviceName(), true);
                ++i2;
            }
        }
    }

    public void dispose() {
        RecordController.getInstance().unlock();
        RecordController.deleteInstance();
        super.dispose();
    }

    public CollectorProperty getCollectorProperty() {
        return this.collectorProperty;
    }

    public GraphProperty[] getGraphProperty() {
        return this.graphCompositeR.getGraphPropertys();
    }

    protected Composite createListContents(Composite parent) {
        this.parent = parent;
        GridLayout layout = new GridLayout(1, true);
        this.parent.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        if (this.loadCollectorPropertey()) {
            this.initialize(this.collectorProperty);
            this.getPreference();
        }
        this.update();
        return this.graphComposite;
    }

    public void update() {
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        int interval = this.collectorInfo.getInterval();
        int graphPlotNum = this.collectorInfo.getGraphPlotNum();
        isRequestCollectorToRun = false;
        if (interval != 0 && this.collectorInfo.getFacilityId() != null) {
            boolean isXRangeAuto = false;
            if (this.collectorInfo.getGraphPlotNum() == 0) {
                isXRangeAuto = true;
            }
            if (this.graphComposite != null) {
                this.graphComposite.dispose();
            }
            this.graphComposite = new RealtimeGraphComposite(this.parent, 0);
            this.graphComposite.setCollectorInfo(this.collectorInfo);
            this.graphComposite.setCollectorItemInfo(this.collectorItemInfo);
            GridData baseGridData = new GridData();
            baseGridData.horizontalAlignment = 4;
            baseGridData.verticalAlignment = 4;
            baseGridData.grabExcessHorizontalSpace = true;
            baseGridData.grabExcessVerticalSpace = true;
            this.graphComposite.setLayoutData(baseGridData);
            GridLayout baseLayout = new GridLayout(1, true);
            this.graphComposite.setLayout((Layout)baseLayout);
            baseLayout.marginHeight = 0;
            baseLayout.marginWidth = 0;
            int graphNum = this.collectorInfo.getGraphNum();
            String facilityId = this.collectorInfo.getFacilityId();
            int i = 0;
            while (i < graphNum) {
                String itemCode = this.collectorItemInfo.getItemCode(i);
                String deviceName = this.collectorItemInfo.getDeviceNameForCollector(Integer.valueOf(this.collectorItemInfo.getItemId(i)));
                String displayType = this.collectorItemInfo.getDisplayType(i);
                String deviceIndex = this.collectorItemInfo.getDeviceIndex(i);
                this.graphComposite.addGraph(i, itemCode, deviceName, this.collectorInfo.getSubScopeNum(), displayType, interval, isXRangeAuto, graphPlotNum);
                this.collectorItemInfo.setIsCollect(i, this.graphComposite.isCollect());
                if (this.graphComposite.isCollect()) {
                    this.setCollector(itemCode, deviceIndex, displayType, interval, facilityId);
                }
                ++i;
            }
            if (!isRequestCollectorToRun) {
                // empty if block
            }
            SashForm treeSash = this.getTreeSash();
            treeSash.setWeights(new int[]{29, 71});
            treeSash.setWeights(new int[]{30, 70});
            this.setPreference();
        }
    }

    private void setCollector(String itemCode, String deviceIndex, String displayType, int interval, String facilityId) {
        String[] facilityIdList;
        String collectorId = this.collectorProperty.getCollectorData().getCollectorID();
        if (this.collectorInfo.getSubScopeNum() > 0 && displayType.equals("SubScope")) {
            facilityIdList = new String[this.collectorInfo.getSubScopeNum()];
            int i = 0;
            while (i < this.collectorInfo.getSubScopeNum()) {
                facilityIdList[i] = this.collectorInfo.getSubScopeFacilityId(i);
                ++i;
            }
        } else {
            facilityIdList = new String[]{facilityId};
        }
        this.collectorProperty.getItemList();
        Date startDate = this.collectorInfo.getGraphStartTime();
        Date endDate = this.collectorInfo.getGraphEndTime();
        Date nowDate = new Date();
        if (this.collectorInfo.getGraphStartTime().before(this.collectorInfo.getCollectStartTime()) && (endDate = new Date((startDate = this.collectorInfo.getCollectStartTime()).getTime() + (long)(this.collectorInfo.getInterval() * 1000 * 200))).after(nowDate)) {
            endDate = nowDate;
        }
        ArrayList<String> ItemCodeCheckList = null;
        if (displayType.equals("Detail")) {
            ItemCodeCheckList = CollectorItemCodeFactory.getSubItemCode(itemCode);
        } else {
            ItemCodeCheckList = new ArrayList<String>();
            ItemCodeCheckList.add(itemCode);
        }
        int[] collectorItemIdList = new int[ItemCodeCheckList.size()];
        int collectorItemNum = this.collectorItemInfo.getItemNumForCollector();
        int m = 0;
        while (m < ItemCodeCheckList.size()) {
            boolean found = false;
            int n = 0;
            while (n < collectorItemNum) {
                if (this.collectorItemInfo.getItemCodeForCollector(n).equals(ItemCodeCheckList.get(m).toString()) && deviceIndex.equals(this.collectorItemInfo.getIndexForCollector(n))) {
                    collectorItemIdList[m] = n;
                    found = true;
                    break;
                }
                ++n;
            }
            if (!found) break;
            ++m;
        }
        this.drawGraph1Test(collectorId, collectorItemIdList, facilityIdList, startDate, endDate, displayType);
        isRequestCollectorToRun = true;
    }

    public synchronized void drawGraph1Test(String collectorId, int[] collectorItemIdList, String[] facilityIdList, Date startDate, Date endDate, String displayType) {
        int i;
        RecordController controller = RecordController.getInstance();
        if (controller == null) {
            return;
        }
        CollectedDataSet dataSet = controller.getRecordCollectedData(collectorId, facilityIdList, collectorItemIdList, startDate, endDate);
        if (dataSet == null) {
            return;
        }
        int counter = 0;
        counter = displayType.equals("SelectedScope") ? 1 : (displayType.equals("SubScope") ? this.collectorInfo.getSubScopeNum() : collectorItemIdList.length);
        int graphDotNum = 0;
        if (displayType.equals("SelectedScope") || displayType.equals("Detail")) {
            i = 0;
            while (i < counter) {
                dataSet.getCollectedDataList(facilityIdList[0], collectorItemIdList[i]);
                ++i;
            }
        } else {
            i = 0;
            while (i < counter) {
                dataSet.getCollectedDataList(facilityIdList[i], collectorItemIdList[0]);
                ++i;
            }
        }
        List dataListForCheck = dataSet.getCollectedDataList(facilityIdList[0], collectorItemIdList[0]);
        graphDotNum = dataListForCheck.size();
        double[] sumOfDataInfoValueSum = new double[graphDotNum];
        int i2 = counter - 1;
        while (i2 >= 0) {
            List dataList = null;
            dataList = displayType.equals("Detail") ? dataSet.getCollectedDataList(facilityIdList[0], collectorItemIdList[i2]) : dataSet.getCollectedDataList(facilityIdList[i2], collectorItemIdList[0]);
            if (dataList.size() != 0) {
                double dataInfoValue = 0.0;
                int j = 0;
                while (j < dataList.size()) {
                    CollectedDataInfo dataInfo = (CollectedDataInfo)dataList.get(j);
                    if (!Double.isNaN(dataInfo.getValue()) && dataInfo.getValue() >= 0.0) {
                        if (displayType.equals("SelectedScope") || displayType.equals("SubScope")) {
                            dataInfoValue = dataInfo.getValue();
                        } else if (displayType.equals("Detail")) {
                            sumOfDataInfoValueSum[j] = sumOfDataInfoValueSum[j] + dataInfo.getValue();
                            dataInfoValue = sumOfDataInfoValueSum[j];
                        }
                        if (!Double.isNaN(dataInfoValue)) {
                            this.graphComposite.m_timeseries[i2].addOrUpdate((RegularTimePeriod)new Second(dataInfo.getDate()), dataInfoValue);
                        }
                    }
                    ++j;
                }
            }
            --i2;
        }
    }

    private boolean loadCollectorPropertey() {
        String collectorID = this.perfPrePage.getCollectorId();
        if (!"".equals(collectorID)) {
            this.collectorProperty = RecordController.getInstance().getCollectorProperty(collectorID);
            if (this.collectorProperty != null) {
                return true;
            }
        }
        return false;
    }

    private void getPreference() {
        this.collectorInfo = this.perfPrePage.getRealtimeCollectorInfo(this.collectorInfo);
        this.collectorItemInfo = this.perfPrePage.getRealtimeCollectorItemInfo(this.collectorItemInfo);
        Label pathLabel = this.getPathLabel();
        pathLabel.setText(String.valueOf(Messages.getString("SCOPE")) + " : " + this.perfPrePage.getPathLabel() + " \n" + Messages.getString("COLLECTION_ID") + " : " + this.perfPrePage.getCollectorId());
    }

    private void setPreference() {
        this.perfPrePage.setCollectorId(this.collectorProperty.getCollectorData().getCollectorID());
        String[] pathLabelSplit = this.getPathLabel().getText().split(" ");
        this.perfPrePage.setPathLabel(pathLabelSplit[2]);
        this.perfPrePage.setRealtimeCollectorInfo(this.collectorInfo);
        this.perfPrePage.setRealtimeCollectorItemInfo(this.collectorItemInfo);
        this.perfPrePage.savePreference();
    }
}

