/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.update.configuration.IActivity;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.configuration.IProblemHandler;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.model.InstallAbortedException;
import org.eclipse.update.internal.core.InstallConfiguration;
import org.eclipse.update.internal.ui.UpdateLabelProvider;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIImages;
import org.eclipse.update.internal.ui.UpdateUIMessages;
import org.eclipse.update.internal.ui.wizards.ActivitiesTableViewer;
import org.eclipse.update.internal.ui.wizards.TableLayoutComposite;
import org.eclipse.update.internal.ui.wizards.UIProblemHandler;
import org.eclipse.update.operations.IRevertConfigurationOperation;
import org.eclipse.update.operations.OperationsManager;

public class RevertConfigurationWizardPage
extends WizardPage {
    private TableViewer activitiesViewer;
    private TableViewer configViewer;
    public static Color blueBGColor;
    private SashForm sashForm;

    public RevertConfigurationWizardPage() {
        super("RevertConfiguration");
        this.setTitle(UpdateUIMessages.RevertConfigurationWizardPage_title);
        this.setDescription(UpdateUIMessages.RevertConfigurationWizardPage_desc);
        blueBGColor = new Color(null, 238, 238, 255);
    }

    public void createControl(Composite parent) {
        this.sashForm = new SashForm(parent, 512);
        this.sashForm.setLayout((Layout)new GridLayout());
        this.sashForm.setLayoutData((Object)new GridData(1808));
        this.createConfigurationsSection((Composite)this.sashForm);
        this.createActivitiesSection((Composite)this.sashForm);
        this.setControl((Control)this.sashForm);
        Object element = this.configViewer.getElementAt(0);
        if (element != null) {
            this.configViewer.setSelection((ISelection)new StructuredSelection(element));
        }
        Dialog.applyDialogFont((Control)this.sashForm);
    }

    private void createConfigurationsSection(Composite parent) {
        Composite tableContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        tableContainer.setLayout((Layout)layout);
        tableContainer.setLayoutData((Object)new GridData(1808));
        Label label = new Label(tableContainer, 0);
        label.setText(UpdateUIMessages.RevertConfigurationWizardPage_label);
        Table table = new Table(tableContainer, 2560);
        table.setLayoutData((Object)new GridData(1808));
        this.configViewer = new TableViewer(table);
        this.configViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                UpdateLabelProvider provider = UpdateUI.getDefault().getLabelProvider();
                return provider.get(UpdateUIImages.DESC_CONFIG_OBJ, 0);
            }

            public String getText(Object element) {
                return Utilities.format((Date)((IInstallConfiguration)element).getCreationDate());
            }
        });
        this.configViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object element) {
                ArrayList<IInstallConfiguration> result = new ArrayList<IInstallConfiguration>();
                ILocalSite localSite = (ILocalSite)element;
                IInstallConfiguration current = localSite.getCurrentConfiguration();
                IInstallConfiguration[] configurations = localSite.getConfigurationHistory();
                int i = configurations.length - 1;
                while (i >= 0) {
                    if (!current.equals(configurations[i])) {
                        result.add(configurations[i]);
                    }
                    --i;
                }
                return result.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.configViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                IStructuredSelection ssel = (IStructuredSelection)e.getSelection();
                InstallConfiguration currentConfig = (InstallConfiguration)ssel.getFirstElement();
                RevertConfigurationWizardPage.this.activitiesViewer.setInput((Object)currentConfig);
                RevertConfigurationWizardPage.this.activitiesViewer.refresh();
                TableItem[] items = RevertConfigurationWizardPage.this.activitiesViewer.getTable().getItems();
                int i = 0;
                while (i < items.length) {
                    IActivity activity = (IActivity)items[i].getData();
                    if (((InstallConfiguration)activity.getInstallConfiguration()).equals((Object)currentConfig)) {
                        items[i].setBackground(blueBGColor);
                    } else {
                        items[i].setBackground(RevertConfigurationWizardPage.this.activitiesViewer.getControl().getBackground());
                    }
                    ++i;
                }
            }
        });
        try {
            this.configViewer.setInput((Object)SiteManager.getLocalSite());
        }
        catch (CoreException coreException) {}
    }

    private void createActivitiesSection(Composite parent) {
        final Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        Label label = new Label(composite, 0);
        label.setText(UpdateUIMessages.RevertConfigurationWizardPage_activities);
        TableLayoutComposite tlComposite = new TableLayoutComposite(composite, 0);
        tlComposite.setLayoutData(new GridData(1808));
        this.activitiesViewer = ActivitiesTableViewer.createViewer(tlComposite, false);
        tlComposite.addColumnData((ColumnLayoutData)new ColumnPixelData(16, true, true));
        tlComposite.addColumnData((ColumnLayoutData)new ColumnWeightData(2, 150, true));
        tlComposite.addColumnData((ColumnLayoutData)new ColumnWeightData(5, 200, true));
        tlComposite.addColumnData((ColumnLayoutData)new ColumnWeightData(4, 100, true));
        TableItem[] configs = this.configViewer.getTable().getItems();
        if (configs.length > 0) {
            this.activitiesViewer.setInput(configs[0].getData());
        }
        composite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int sashHeight = RevertConfigurationWizardPage.this.getSashForm().getSize().y;
                int sashWidth = RevertConfigurationWizardPage.this.getSashForm().getSize().x;
                if ((double)composite.getSize().y > (double)sashHeight * 0.85 && (double)composite.getSize().x > (double)sashWidth * 0.5) {
                    RevertConfigurationWizardPage.this.getSashForm().setOrientation(256);
                } else {
                    RevertConfigurationWizardPage.this.getSashForm().setOrientation(512);
                }
            }
        });
    }

    public void dispose() {
        blueBGColor.dispose();
    }

    public SashForm getSashForm() {
        return this.sashForm;
    }

    public boolean performFinish() {
        Shell shell = this.getContainer().getShell();
        boolean result = MessageDialog.openQuestion((Shell)shell, (String)shell.getText(), (String)UpdateUIMessages.RevertConfigurationWizardPage_question);
        if (!result) {
            return false;
        }
        boolean finish = this.performRevert();
        if (finish) {
            PlatformUI.getWorkbench().restart();
        }
        return finish;
    }

    public boolean performRevert() {
        IStructuredSelection ssel = (IStructuredSelection)this.configViewer.getSelection();
        final IInstallConfiguration target = (IInstallConfiguration)ssel.getFirstElement();
        IStatus status = OperationsManager.getValidator().validatePendingRevert(target);
        if (status != null && status.getCode() == 4) {
            ErrorDialog.openError((Shell)UpdateUI.getActiveWorkbenchShell(), null, null, (IStatus)status);
            return false;
        }
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                IRevertConfigurationOperation revertOperation = OperationsManager.getOperationFactory().createRevertConfigurationOperation(target, (IProblemHandler)new UIProblemHandler());
                try {
                    try {
                        revertOperation.execute(monitor, null);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var4_6 = null;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, true, operation);
            return true;
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof InstallAbortedException) {
                return true;
            }
            UpdateUI.logException(e);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }
}

