/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.eclipse.ui.views.markers.internal.MarkerFilter;

public class BookmarkFilter
extends MarkerFilter {
    private static final String TAG_CONTAINS = "contains";
    private static final String TAG_DESCRIPTION = "description";
    private static final String TAG_DIALOG_SECTION = "filter";
    static final boolean DEFAULT_CONTAINS = true;
    static final String DEFAULT_DESCRIPTION = "";
    private boolean contains;
    private String description;

    public BookmarkFilter() {
        super(new String[]{"org.eclipse.core.resources.bookmark"});
    }

    public boolean selectMarker(ConcreteMarker marker) {
        return !this.isEnabled() || super.selectMarker(marker) && this.selectByDescription(marker);
    }

    private boolean selectByDescription(ConcreteMarker marker) {
        if (this.description == null || this.description.equals(DEFAULT_DESCRIPTION)) {
            return true;
        }
        String markerDescription = marker.getDescription();
        int index = markerDescription.indexOf(this.description);
        return this.contains ? index >= 0 : index < 0;
    }

    boolean getContains() {
        return this.contains;
    }

    String getDescription() {
        return this.description;
    }

    void setContains(boolean contains) {
        this.contains = contains;
    }

    void setDescription(String description) {
        this.description = description;
    }

    void resetState() {
        super.resetState();
        this.contains = true;
        this.description = DEFAULT_DESCRIPTION;
    }

    public void restoreState(IDialogSettings dialogSettings) {
        super.restoreState(dialogSettings);
        IDialogSettings settings = dialogSettings.getSection(TAG_DIALOG_SECTION);
        if (settings != null) {
            String setting = settings.get(TAG_CONTAINS);
            if (setting != null) {
                this.contains = Boolean.valueOf(setting);
            }
            if ((setting = settings.get(TAG_DESCRIPTION)) != null) {
                this.description = new String(setting);
            }
        }
    }

    public void saveState(IDialogSettings dialogSettings) {
        super.saveState(dialogSettings);
        if (dialogSettings != null) {
            IDialogSettings settings = dialogSettings.getSection(TAG_DIALOG_SECTION);
            if (settings == null) {
                settings = dialogSettings.addNewSection(TAG_DIALOG_SECTION);
            }
            settings.put(TAG_CONTAINS, this.contains);
            settings.put(TAG_DESCRIPTION, this.description);
        }
    }
}

