/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xml.binding;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.XSTypeDefinition;
import org.jboss.logging.Logger;
import org.jboss.xml.binding.ContentNavigator;
import org.jboss.xml.binding.GenericObjectModelFactory;
import org.jboss.xml.binding.parser.JBossXBParser;
import org.xml.sax.Attributes;

public class ObjectModelBuilder
implements ContentNavigator,
JBossXBParser.ContentHandler {
    private static final Logger log = Logger.getLogger(ObjectModelBuilder.class);
    private static final Object IGNORED = new Object();
    private Object root;
    private Stack all = new StackImpl();
    private Stack accepted = new StackImpl();
    private GenericObjectModelFactory curFactory;
    private String curNameSwitchingFactory;
    private String curNsSwitchingFactory;
    private Stack nameSwitchingFactory;
    private Stack nsSwitchingFactory;
    private GenericObjectModelFactory defaultFactory;
    private Map factoriesToNs = Collections.EMPTY_MAP;
    private Map prefixToUri = new HashMap();
    private StringBuffer value = new StringBuffer();
    private XSTypeDefinition currentType;

    public void mapFactoryToNamespace(GenericObjectModelFactory factory, String namespaceUri) {
        if (this.factoriesToNs == Collections.EMPTY_MAP) {
            this.factoriesToNs = new HashMap();
        }
        this.factoriesToNs.put(namespaceUri, factory);
    }

    public void init(GenericObjectModelFactory defaultFactory, Object root) {
        this.defaultFactory = defaultFactory;
        this.all.clear();
        this.accepted.clear();
        this.value.delete(0, this.value.length());
        this.root = root;
    }

    public Map getPrefixToNamespaceMap() {
        return Collections.unmodifiableMap(this.prefixToUri);
    }

    public String resolveNamespacePrefix(String prefix) {
        LinkedList prefixStack = (LinkedList)this.prefixToUri.get(prefix);
        String uri = prefixStack != null && !prefixStack.isEmpty() ? (String)prefixStack.getFirst() : null;
        return uri;
    }

    public QName resolveQName(String value) {
        StringTokenizer st = new StringTokenizer(value, ":");
        if (st.countTokens() == 1) {
            return new QName(value);
        }
        if (st.countTokens() != 2) {
            throw new IllegalArgumentException("Illegal QName: " + value);
        }
        String prefix = st.nextToken();
        String local = st.nextToken();
        String nsURI = this.resolveNamespacePrefix(prefix);
        return new QName(nsURI, local);
    }

    public String getChildContent(String namespaceURI, String qName) {
        throw new UnsupportedOperationException();
    }

    public XSTypeDefinition getType() {
        return this.currentType;
    }

    public void startPrefixMapping(String prefix, String uri) {
        LinkedList<String> prefixStack = (LinkedList<String>)this.prefixToUri.get(prefix);
        if (prefixStack == null || prefixStack.isEmpty()) {
            prefixStack = new LinkedList<String>();
            this.prefixToUri.put(prefix, prefixStack);
        }
        prefixStack.addFirst(uri);
    }

    public void endPrefixMapping(String prefix) {
        LinkedList prefixStack = (LinkedList)this.prefixToUri.get(prefix);
        if (prefixStack != null) {
            prefixStack.removeFirst();
        }
    }

    public Object getRoot() {
        if (!this.all.isEmpty()) {
            this.all.pop();
            this.accepted.pop();
        }
        return this.root;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts, XSTypeDefinition type) {
        Object element;
        Object parent = this.accepted.isEmpty() ? this.root : this.accepted.peek();
        this.currentType = type;
        if (!namespaceURI.equals(this.curNsSwitchingFactory)) {
            if (this.curNsSwitchingFactory != null) {
                if (this.nsSwitchingFactory == null) {
                    this.nsSwitchingFactory = new StackImpl();
                    this.nameSwitchingFactory = new StackImpl();
                }
                this.nsSwitchingFactory.push(this.curNsSwitchingFactory);
                this.nameSwitchingFactory.push(this.curNameSwitchingFactory);
            }
            this.curNsSwitchingFactory = namespaceURI;
            this.curNameSwitchingFactory = localName;
            this.curFactory = this.getFactory(namespaceURI);
            element = this.curFactory.newRoot(parent, this, namespaceURI, localName, atts);
        } else {
            element = this.curFactory.newChild(parent, this, namespaceURI, localName, atts);
        }
        if (element == null) {
            this.all.push(IGNORED);
            if (log.isTraceEnabled()) {
                log.trace("ignored " + namespaceURI + ':' + qName);
            }
        } else {
            this.all.push(element);
            this.accepted.push(element);
            if (log.isTraceEnabled()) {
                log.trace("accepted " + namespaceURI + ':' + qName);
            }
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        Object element;
        if (this.value.length() > 0) {
            try {
                element = this.accepted.peek();
            }
            catch (NoSuchElementException e) {
                log.error("value=" + this.value, e);
                throw e;
            }
            this.curFactory.setValue(element, this, namespaceURI, localName, this.value.toString().trim());
            this.value.delete(0, this.value.length());
        }
        if (localName.equals(this.curNameSwitchingFactory) && namespaceURI.equals(this.curNsSwitchingFactory)) {
            if (this.nsSwitchingFactory == null || this.nsSwitchingFactory.isEmpty()) {
                this.curNameSwitchingFactory = null;
                this.curNsSwitchingFactory = null;
            } else {
                this.curNameSwitchingFactory = (String)this.nameSwitchingFactory.pop();
                this.curNsSwitchingFactory = (String)this.nsSwitchingFactory.pop();
            }
            this.curFactory = this.getFactory(this.curNsSwitchingFactory);
        }
        if ((element = this.all.pop()) != IGNORED) {
            Object parent;
            element = this.accepted.pop();
            Object object = parent = this.accepted.isEmpty() ? null : this.accepted.peek();
            if (parent != null) {
                this.curFactory.addChild(parent, element, this, namespaceURI, localName);
            } else {
                this.root = this.curFactory.completedRoot(element, this, namespaceURI, localName);
            }
        }
    }

    public void characters(char[] ch, int start, int length) {
        this.value.append(ch, start, length);
    }

    private GenericObjectModelFactory getFactory(String namespaceUri) {
        GenericObjectModelFactory factory = (GenericObjectModelFactory)this.factoriesToNs.get(namespaceUri);
        if (factory == null) {
            factory = this.defaultFactory;
        }
        return factory;
    }

    static Object invokeFactory(Object factory, Method method, Object[] args) {
        try {
            return method.invoke(factory, args);
        }
        catch (InvocationTargetException e) {
            log.error("Failed to invoke method " + method.getName(), e.getTargetException());
            throw new IllegalStateException("Failed to invoke method " + method.getName());
        }
        catch (Exception e) {
            log.error("Failed to invoke method " + method.getName(), e);
            throw new IllegalStateException("Failed to invoke method " + method.getName());
        }
    }

    static Method getMethodForElement(Object factory, String name, Class[] params) {
        Method method = null;
        try {
            method = factory.getClass().getMethod(name, params);
        }
        catch (NoSuchMethodException e) {
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e.getMessage());
        }
        return method;
    }

    private static class StackImpl
    implements Stack {
        private LinkedList list = new LinkedList();

        private StackImpl() {
        }

        public void clear() {
            this.list.clear();
        }

        public void push(Object o) {
            this.list.addLast(o);
        }

        public Object pop() {
            return this.list.removeLast();
        }

        public Object peek() {
            return this.list.getLast();
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }
    }

    private static interface Stack {
        public void clear();

        public void push(Object var1);

        public Object pop();

        public Object peek();

        public boolean isEmpty();
    }
}

