/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.run.composite;

import com.clustercontrol.bean.PriorityColorConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.composite.NumberVerifyListener;
import com.clustercontrol.composite.PositiveNumberVerifyListener;
import com.clustercontrol.composite.PositiveRealNumberVerifyListener;
import com.clustercontrol.composite.RealNumberVerifyListener;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorNumericValueInfo;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NumericValueInfoComposite
extends Composite {
    public static final int WIDTH_TITLE = 5;
    public static final int WIDTH_VALUE = 2;
    public static final int INPUT_VERIFICATION_INTEGER_NUMBER = 0;
    public static final int INPUT_VERIFICATION_REAL_NUMBER = 1;
    public static final int INPUT_VERIFICATION_POSITIVE_INTEGER = 2;
    public static final int INPUT_VERIFICATION_POSITIVE_REAL = 3;
    private boolean m_rangeFlg = false;
    private String m_itemName1 = null;
    private String m_itemName2 = null;
    private String m_criterion1 = Messages.getString((String)"greater");
    private String m_criterion2 = Messages.getString((String)"less");
    private int m_inputVerifyType1 = 0;
    private int m_inputVerifyType2 = 0;
    private Double m_inputFloor1 = null;
    private Double m_inputCeiling1 = null;
    private Double m_inputFloor2 = null;
    private Double m_inputCeiling2 = null;
    private Text m_textInfoThresholdLowerLimit = null;
    private Text m_textInfoThresholdUpperLimit = null;
    private Text m_textWarnThresholdLowerLimit = null;
    private Text m_textWarnThresholdUpperLimit = null;
    private Combo m_comboFailurePriority = null;

    public NumericValueInfoComposite(Composite parent, int style, boolean rangeFlg, String item1, String item2) {
        super(parent, style);
        this.m_rangeFlg = rangeFlg;
        this.m_itemName1 = item1;
        this.m_itemName2 = item2;
        this.initialize();
    }

    public NumericValueInfoComposite(Composite parent, int style, boolean rangeFlg, String item1, String item2, int inputVerifyType) {
        super(parent, style);
        this.m_rangeFlg = rangeFlg;
        this.m_itemName1 = item1;
        this.m_itemName2 = item2;
        this.m_inputVerifyType1 = inputVerifyType;
        this.m_inputVerifyType2 = inputVerifyType;
        this.initialize();
    }

    public NumericValueInfoComposite(Composite parent, int style, boolean rangeFlg, String item1, String item2, int inputVerifyType1, int inputVerifyType2) {
        super(parent, style);
        this.m_rangeFlg = rangeFlg;
        this.m_itemName1 = item1;
        this.m_itemName2 = item2;
        this.m_inputVerifyType1 = inputVerifyType1;
        this.m_inputVerifyType2 = inputVerifyType2;
        this.initialize();
    }

    public NumericValueInfoComposite(Composite parent, int style, boolean rangeFlg, String item1, String item2, String criterion1, String criterion2, int inputVerifyType1, int inputVerifyType2) {
        super(parent, style);
        this.m_rangeFlg = rangeFlg;
        this.m_itemName1 = item1;
        this.m_itemName2 = item2;
        this.m_criterion1 = criterion1;
        this.m_criterion2 = criterion2;
        this.m_inputVerifyType1 = inputVerifyType1;
        this.m_inputVerifyType2 = inputVerifyType2;
        this.initialize();
    }

    public NumericValueInfoComposite(Composite parent, int style, boolean rangeFlg, String item1, String item2, int inputVerifyType, Double inputFloor, Double inputCeiling) {
        super(parent, style);
        this.m_rangeFlg = rangeFlg;
        this.m_itemName1 = item1;
        this.m_itemName2 = item2;
        this.m_inputVerifyType1 = inputVerifyType;
        this.m_inputVerifyType2 = inputVerifyType;
        this.m_inputFloor1 = inputFloor;
        this.m_inputFloor2 = inputFloor;
        this.m_inputCeiling1 = inputCeiling;
        this.m_inputCeiling2 = inputCeiling;
        this.initialize();
    }

    public NumericValueInfoComposite(Composite parent, int style, boolean rangeFlg, String item1, String item2, int inputVerifyType1, int inputVerifyType2, Double inputFloor1, Double inputCeiling1, Double inputFloor2, Double inputCeiling2) {
        super(parent, style);
        this.m_rangeFlg = rangeFlg;
        this.m_itemName1 = item1;
        this.m_itemName2 = item2;
        this.m_inputVerifyType1 = inputVerifyType1;
        this.m_inputVerifyType2 = inputVerifyType2;
        this.m_inputFloor1 = inputFloor1;
        this.m_inputFloor2 = inputFloor2;
        this.m_inputCeiling1 = inputCeiling1;
        this.m_inputCeiling2 = inputCeiling2;
        this.initialize();
    }

    public NumericValueInfoComposite(Composite parent, int style, boolean rangeFlg, String item1, String item2, String criterion1, String criterion2, int inputVerifyType1, int inputVerifyType2, Double inputFloor1, Double inputCeiling1, Double inputFloor2, Double inputCeiling2) {
        super(parent, style);
        this.m_rangeFlg = rangeFlg;
        this.m_itemName1 = item1;
        this.m_itemName2 = item2;
        this.m_criterion1 = criterion1;
        this.m_criterion2 = criterion2;
        this.m_inputVerifyType1 = inputVerifyType1;
        this.m_inputVerifyType2 = inputVerifyType2;
        this.m_inputFloor1 = inputFloor1;
        this.m_inputFloor2 = inputFloor2;
        this.m_inputCeiling1 = inputCeiling1;
        this.m_inputCeiling2 = inputCeiling2;
        this.initialize();
    }

    private void initialize() {
        Label label = null;
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 15;
        this.setLayout((Layout)layout);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"successful.select.value")) + " : ");
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString((String)"priority"));
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(this.m_itemName1);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(this.m_itemName2);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        Object verifyListener1 = null;
        verifyListener1 = this.m_inputVerifyType1 == 1 ? new RealNumberVerifyListener() : (this.m_inputVerifyType1 == 2 ? new PositiveNumberVerifyListener() : (this.m_inputVerifyType1 == 3 ? new PositiveRealNumberVerifyListener() : new NumberVerifyListener()));
        Object verifyListener2 = null;
        verifyListener2 = this.m_inputVerifyType2 == 1 ? new RealNumberVerifyListener() : (this.m_inputVerifyType2 == 2 ? new PositiveNumberVerifyListener() : (this.m_inputVerifyType2 == 3 ? new PositiveRealNumberVerifyListener() : new NumberVerifyListener()));
        label = this.getLabelPriority(this, Messages.getString((String)"info"), PriorityColorConstant.COLOR_INFO);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.m_textInfoThresholdLowerLimit = new Text((Composite)this, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textInfoThresholdLowerLimit.addVerifyListener((VerifyListener)verifyListener1);
        this.m_textInfoThresholdLowerLimit.setLayoutData((Object)gridData);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(this.m_criterion1);
        this.m_textInfoThresholdUpperLimit = new Text((Composite)this, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textInfoThresholdUpperLimit.addVerifyListener((VerifyListener)verifyListener2);
        this.m_textInfoThresholdUpperLimit.setLayoutData((Object)gridData);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(this.m_criterion2);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = this.getLabelPriority(this, Messages.getString((String)"warning"), PriorityColorConstant.COLOR_WARNING);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.m_textWarnThresholdLowerLimit = new Text((Composite)this, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textWarnThresholdLowerLimit.addVerifyListener((VerifyListener)verifyListener1);
        this.m_textWarnThresholdLowerLimit.setLayoutData((Object)gridData);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(this.m_criterion1);
        this.m_textWarnThresholdUpperLimit = new Text((Composite)this, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textWarnThresholdUpperLimit.addVerifyListener((VerifyListener)verifyListener2);
        this.m_textWarnThresholdUpperLimit.setLayoutData((Object)gridData);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(this.m_criterion2);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = this.getLabelPriority(this, Messages.getString((String)"critical"), PriorityColorConstant.COLOR_CRITICAL);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString((String)"other.priority"));
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"failure.select.value")) + " : ");
        this.m_comboFailurePriority = new Combo((Composite)this, 12);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboFailurePriority.setLayoutData((Object)gridData);
        this.m_comboFailurePriority.add(PriorityConstant.STRING_CRITICAL);
        this.m_comboFailurePriority.add(PriorityConstant.STRING_WARNING);
        this.m_comboFailurePriority.add(PriorityConstant.STRING_INFO);
        this.m_comboFailurePriority.add(PriorityConstant.STRING_UNKNOWN);
        this.m_comboFailurePriority.setText(PriorityConstant.STRING_WARNING);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
    }

    public void setInputData(MonitorInfo info) {
        if (info != null) {
            ArrayList list = info.getJudgementInfo();
            if (list != null) {
                int index = 0;
                while (index < list.size()) {
                    MonitorNumericValueInfo numericValueInfo = (MonitorNumericValueInfo)list.get(index);
                    if (numericValueInfo != null) {
                        String upper;
                        String lower;
                        if (3 == numericValueInfo.getPriority()) {
                            lower = "";
                            upper = "";
                            lower = this.m_inputVerifyType1 == 0 || this.m_inputVerifyType1 == 2 ? Long.toString(Double.valueOf(numericValueInfo.getThresholdLowerLimit()).longValue()) : Double.toString(numericValueInfo.getThresholdLowerLimit());
                            upper = this.m_inputVerifyType2 == 0 || this.m_inputVerifyType2 == 2 ? Long.toString(Double.valueOf(numericValueInfo.getThresholdUpperLimit()).longValue()) : Double.toString(numericValueInfo.getThresholdUpperLimit());
                            this.m_textInfoThresholdLowerLimit.setText(lower);
                            this.m_textInfoThresholdUpperLimit.setText(upper);
                        } else if (2 == numericValueInfo.getPriority()) {
                            lower = "";
                            upper = "";
                            lower = this.m_inputVerifyType1 == 0 || this.m_inputVerifyType1 == 2 ? Long.toString(Double.valueOf(numericValueInfo.getThresholdLowerLimit()).longValue()) : Double.toString(numericValueInfo.getThresholdLowerLimit());
                            upper = this.m_inputVerifyType2 == 0 || this.m_inputVerifyType2 == 2 ? Long.toString(Double.valueOf(numericValueInfo.getThresholdUpperLimit()).longValue()) : Double.toString(numericValueInfo.getThresholdUpperLimit());
                            this.m_textWarnThresholdLowerLimit.setText(lower);
                            this.m_textWarnThresholdUpperLimit.setText(upper);
                        }
                    }
                    ++index;
                }
            }
            this.m_comboFailurePriority.setText(PriorityConstant.typeToString((int)info.getFailurePriority()));
        }
    }

    public ValidateResult createInputData(MonitorInfo info) {
        ArrayList<MonitorNumericValueInfo> valueList = new ArrayList<MonitorNumericValueInfo>();
        String lowerText = null;
        String upperText = null;
        Double lower = null;
        Double upper = null;
        MonitorNumericValueInfo valueInfo = this.getDefaultValueInfo(info, 3);
        lowerText = this.m_textInfoThresholdLowerLimit.getText();
        upperText = this.m_textInfoThresholdUpperLimit.getText();
        if (lowerText != null && !"".equals(lowerText.trim())) {
            try {
                lower = new Double(lowerText);
                if (this.m_inputFloor1 != null && this.m_inputCeiling1 != null) {
                    if (lower < this.m_inputFloor1 || lower > this.m_inputCeiling1) {
                        Object[] args = new String[]{this.m_itemName1, this.m_inputFloor1.toString(), this.m_inputCeiling1.toString()};
                        return this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.19", (Object[])args));
                    }
                } else if (this.m_inputFloor1 != null && this.m_inputCeiling1 == null) {
                    if (lower < this.m_inputFloor1) {
                        Object[] args = new String[]{this.m_itemName1, this.m_inputFloor1.toString()};
                        return this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.20", (Object[])args));
                    }
                } else if (this.m_inputFloor1 == null && this.m_inputCeiling1 != null && lower > this.m_inputCeiling1) {
                    Object[] args = new String[]{this.m_itemName1, this.m_inputCeiling1.toString()};
                    return this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.21", (Object[])args));
                }
                valueInfo.setThresholdLowerLimit(lower.doubleValue());
            }
            catch (NumberFormatException numberFormatException) {
                Object[] args = new String[]{this.m_itemName1};
                return this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.3", (Object[])args));
            }
        } else {
            Object[] args = new String[]{this.m_itemName1};
            return this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.3", (Object[])args));
        }
        if (upperText != null && !"".equals(upperText.trim())) {
            try {
                upper = new Double(upperText);
                if (this.m_inputFloor2 != null && this.m_inputCeiling2 != null) {
                    if (upper < this.m_inputFloor2 || upper > this.m_inputCeiling2) {
                        Object[] args = new String[]{this.m_itemName2, this.m_inputFloor2.toString(), this.m_inputCeiling2.toString()};
                        return this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.19", (Object[])args));
                    }
                } else if (this.m_inputFloor2 != null && this.m_inputCeiling2 == null) {
                    if (upper < this.m_inputFloor2) {
                        Object[] args = new String[]{this.m_itemName2, this.m_inputFloor2.toString()};
                        return this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.20", (Object[])args));
                    }
                } else if (this.m_inputFloor2 == null && this.m_inputCeiling2 != null && upper > this.m_inputCeiling2) {
                    Object[] args = new String[]{this.m_itemName2, this.m_inputCeiling2.toString()};
                    return this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.21", (Object[])args));
                }
                valueInfo.setThresholdUpperLimit(upper.doubleValue());
            }
            catch (NumberFormatException numberFormatException) {
                Object[] args = new String[]{this.m_itemName2};
                return this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.4", (Object[])args));
            }
        } else {
            Object[] args = new String[]{this.m_itemName2};
            return this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.4", (Object[])args));
        }
        if (this.m_rangeFlg && upper < lower) {
            return this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.7"));
        }
        valueList.add(valueInfo);
        MonitorNumericValueInfo valueWarn = this.getDefaultValueInfo(info, 2);
        lowerText = this.m_textWarnThresholdLowerLimit.getText();
        upperText = this.m_textWarnThresholdUpperLimit.getText();
        if (lowerText != null && !"".equals(lowerText.trim())) {
            try {
                lower = new Double(lowerText);
                if (this.m_inputFloor1 != null && this.m_inputCeiling1 != null) {
                    if (lower < this.m_inputFloor1 || lower > this.m_inputCeiling1) {
                        Object[] args = new String[]{this.m_itemName1, this.m_inputFloor1.toString(), this.m_inputCeiling1.toString()};
                        return this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.22", (Object[])args));
                    }
                } else if (this.m_inputFloor1 != null && this.m_inputCeiling1 == null) {
                    if (lower < this.m_inputFloor1) {
                        Object[] args = new String[]{this.m_itemName1, this.m_inputFloor1.toString()};
                        return this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.23", (Object[])args));
                    }
                } else if (this.m_inputFloor1 == null && this.m_inputCeiling1 != null && lower > this.m_inputCeiling1) {
                    Object[] args = new String[]{this.m_itemName1, this.m_inputCeiling1.toString()};
                    return this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.24", (Object[])args));
                }
                valueWarn.setThresholdLowerLimit(lower.doubleValue());
            }
            catch (NumberFormatException numberFormatException) {
                Object[] args = new String[]{this.m_itemName1};
                return this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.5", (Object[])args));
            }
        } else {
            Object[] args = new String[]{this.m_itemName1};
            return this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.5", (Object[])args));
        }
        if (this.m_textWarnThresholdUpperLimit.getText() != null && !"".equals(this.m_textWarnThresholdUpperLimit.getText().trim())) {
            try {
                upper = new Double(upperText);
                if (this.m_inputFloor2 != null && this.m_inputCeiling2 != null) {
                    if (upper < this.m_inputFloor2 || upper > this.m_inputCeiling2) {
                        Object[] args = new String[]{this.m_itemName2, this.m_inputFloor2.toString(), this.m_inputCeiling2.toString()};
                        return this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.22", (Object[])args));
                    }
                } else if (this.m_inputFloor2 != null && this.m_inputCeiling2 == null) {
                    if (upper < this.m_inputFloor2) {
                        Object[] args = new String[]{this.m_itemName2, this.m_inputFloor2.toString()};
                        return this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.23", (Object[])args));
                    }
                } else if (this.m_inputFloor2 == null && this.m_inputCeiling2 != null && upper > this.m_inputCeiling2) {
                    Object[] args = new String[]{this.m_itemName2, this.m_inputCeiling2.toString()};
                    return this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.24", (Object[])args));
                }
                valueWarn.setThresholdUpperLimit(upper.doubleValue());
            }
            catch (NumberFormatException numberFormatException) {
                Object[] args = new String[]{this.m_itemName2};
                return this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.6", (Object[])args));
            }
        } else {
            Object[] args = new String[]{this.m_itemName2};
            return this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.6", (Object[])args));
        }
        if (this.m_rangeFlg && upper < lower) {
            return this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.8"));
        }
        valueList.add(valueWarn);
        MonitorNumericValueInfo valueCritical = this.getDefaultValueInfo(info, 0);
        valueCritical.setThresholdLowerLimit(Double.valueOf(0.0).doubleValue());
        valueCritical.setThresholdUpperLimit(Double.valueOf(0.0).doubleValue());
        valueList.add(valueCritical);
        MonitorNumericValueInfo valueUnknown = this.getDefaultValueInfo(info, 1);
        valueUnknown.setThresholdLowerLimit(Double.valueOf(0.0).doubleValue());
        valueUnknown.setThresholdUpperLimit(Double.valueOf(0.0).doubleValue());
        valueList.add(valueUnknown);
        info.setJudgementInfo(valueList);
        info.setFailurePriority(PriorityConstant.stringToType((String)this.m_comboFailurePriority.getText()));
        return null;
    }

    public void setEnabled(boolean enabled) {
        this.m_textInfoThresholdLowerLimit.setEnabled(enabled);
        this.m_textInfoThresholdUpperLimit.setEnabled(enabled);
        this.m_textWarnThresholdLowerLimit.setEnabled(enabled);
        this.m_textWarnThresholdUpperLimit.setEnabled(enabled);
        this.m_comboFailurePriority.setEnabled(enabled);
    }

    protected Label getLabelPriority(Composite parent, String text, Color background) {
        Label label = new Label(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(text) + " : ");
        label.setBackground(background);
        return label;
    }

    protected ValidateResult setValidateResult(String id, String message) {
        ValidateResult validateResult = new ValidateResult();
        validateResult.setValid(false);
        validateResult.setID(id);
        validateResult.setMessage(message);
        return validateResult;
    }

    protected MonitorNumericValueInfo getDefaultValueInfo(MonitorInfo info, int priority) {
        MonitorNumericValueInfo value = new MonitorNumericValueInfo();
        value.setMonitorId(info.getMonitorId());
        value.setMonitorTypeId(info.getMonitorTypeId());
        value.setPriority(Integer.valueOf(priority).intValue());
        return value;
    }
}

