/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.xy.SignalsDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.util.PublicCloneable;

public class SignalRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private double markOffset = 5.0;
    private double shapeWidth = 15.0;
    private double shapeHeight = 25.0;

    public double getMarkOffset() {
        return this.markOffset;
    }

    public void setMarkOffset(double offset) {
        this.markOffset = offset;
    }

    public double getShapeWidth() {
        return this.shapeWidth;
    }

    public void setShapeWidth(double width) {
        this.shapeWidth = width;
    }

    public double getShapeHeight() {
        return this.shapeHeight;
    }

    public void setShapeHeight(double height) {
        this.shapeHeight = height;
    }

    public void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis horizontalAxis, ValueAxis verticalAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        EntityCollection entities = null;
        if (info != null) {
            entities = info.getOwner().getEntityCollection();
        }
        SignalsDataset signalData = (SignalsDataset)dataset;
        Number x = signalData.getX(series, item);
        Number y = signalData.getY(series, item);
        int type = signalData.getType(series, item);
        double xx = horizontalAxis.valueToJava2D(x.doubleValue(), dataArea, plot.getDomainAxisEdge());
        double yy = verticalAxis.valueToJava2D(y.doubleValue(), dataArea, plot.getRangeAxisEdge());
        Paint p = this.getItemPaint(series, item);
        Stroke s = this.getItemStroke(series, item);
        g2.setPaint(p);
        g2.setStroke(s);
        int direction = 1;
        if (type == 1 || type == -2) {
            yy += this.markOffset;
            direction = -1;
        } else {
            yy -= this.markOffset;
        }
        GeneralPath path = new GeneralPath();
        if (type == 1 || type == -1) {
            path.moveTo((float)xx, (float)yy);
            path.lineTo((float)(xx + this.shapeWidth / 2.0), (float)(yy - (double)direction * this.shapeHeight / 3.0));
            path.lineTo((float)(xx + this.shapeWidth / 6.0), (float)(yy - (double)direction * this.shapeHeight / 3.0));
            path.lineTo((float)(xx + this.shapeWidth / 6.0), (float)(yy - (double)direction * this.shapeHeight));
            path.lineTo((float)(xx - this.shapeWidth / 6.0), (float)(yy - (double)direction * this.shapeHeight));
            path.lineTo((float)(xx - this.shapeWidth / 6.0), (float)(yy - (double)direction * this.shapeHeight / 3.0));
            path.lineTo((float)(xx - this.shapeWidth / 2.0), (float)(yy - (double)direction * this.shapeHeight / 3.0));
            path.lineTo((float)xx, (float)yy);
        } else {
            path.moveTo((float)xx, (float)yy);
            path.lineTo((float)xx, (float)(yy - (double)direction * this.shapeHeight));
            Ellipse2D.Double ellipse = new Ellipse2D.Double(xx - this.shapeWidth / 2.0, yy + (direction == 1 ? -this.shapeHeight : this.shapeHeight - this.shapeWidth), this.shapeWidth, this.shapeWidth);
            path.append(ellipse, false);
        }
        g2.fill(path);
        g2.setPaint(Color.black);
        g2.draw(path);
        if (entities != null) {
            String tip = null;
            XYToolTipGenerator generator = this.getToolTipGenerator(series, item);
            if (generator != null) {
                tip = generator.generateToolTip(dataset, series, item);
            }
            String url = null;
            if (this.getURLGenerator() != null) {
                url = this.getURLGenerator().generateURL(dataset, series, item);
            }
            XYItemEntity entity = new XYItemEntity(path, dataset, series, item, tip, url);
            entities.addEntity(entity);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

