/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.collectiverun.composite;

import com.clustercontrol.collectiverun.action.ModifyMaster;
import com.clustercontrol.collectiverun.bean.CommandParameterInfo;
import com.clustercontrol.collectiverun.bean.ItemInfo;
import com.clustercontrol.collectiverun.bean.TreeItem;
import com.clustercontrol.collectiverun.composite.TreeComposite;
import com.clustercontrol.collectiverun.composite.action.MasterInfoModifyListener;
import com.clustercontrol.collectiverun.util.TreeItemUtil;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.util.Messages;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;

public class CommandParameterComposite
extends Composite {
    private Combo id = null;
    private Text option = null;
    private TreeItem selectItem = null;
    private TreeComposite composite = null;

    public CommandParameterComposite(Composite parent, int style, TreeComposite composite) {
        super(parent, style);
        this.composite = composite;
        this.selectItem = composite.getSelectItem();
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(10, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        GridData gridData = null;
        Label label = null;
        Group group = new Group((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 10;
        group.setLayoutData((Object)gridData);
        group.setText(Messages.getString((String)"parameter"));
        layout = new GridLayout(10, true);
        group.setLayout((Layout)layout);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 10;
        label = new Label((Composite)group, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"parameter.id")) + " : ");
        this.id = new Combo((Composite)group, 2056);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 7;
        this.id.setLayoutData((Object)gridData);
        this.id.addModifyListener((ModifyListener)new MasterInfoModifyListener(this.composite));
        List list = TreeItemUtil.getParameterIdList((TreeItem)TreeItemUtil.getTopTreeItem((TreeItem)this.selectItem));
        int i = 0;
        while (i < list.size()) {
            this.id.add((String)list.get(i));
            ++i;
        }
        label = new Label((Composite)group, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"option")) + " : ");
        this.option = new Text((Composite)group, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 7;
        this.option.setLayoutData((Object)gridData);
        this.option.addModifyListener((ModifyListener)new MasterInfoModifyListener(this.composite));
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 8;
        label.setLayoutData((Object)gridData);
        Button buttonCreate = new Button((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        buttonCreate.setLayoutData((Object)gridData);
        buttonCreate.setText(Messages.getString((String)"apply"));
        buttonCreate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ValidateResult result = CommandParameterComposite.this.validate();
                if (result != null) {
                    CommandParameterComposite.this.displayError(result);
                }
            }
        });
        this.setEnabled();
        this.update();
    }

    public void setEnabled() {
        if (this.composite.getCreateItem() == null) {
            this.id.setEnabled(false);
        } else {
            this.id.setEnabled(true);
        }
    }

    public void update() {
        if (this.selectItem instanceof TreeItem && this.selectItem.getInfo() instanceof CommandParameterInfo) {
            CommandParameterInfo info = (CommandParameterInfo)this.selectItem.getInfo();
            if (info.getId() != null) {
                this.id.setText(info.getId());
            }
            if (info.getPrefix() != null) {
                this.option.setText(info.getPrefix());
            }
        }
        this.composite.setUpdateItem(null);
    }

    public ValidateResult createCommandParameterInfo() {
        ValidateResult result = null;
        if (this.selectItem instanceof TreeItem && this.selectItem.getInfo() instanceof CommandParameterInfo) {
            CommandParameterInfo info = (CommandParameterInfo)this.selectItem.getInfo();
            CommandParameterInfo cloneInfo = (CommandParameterInfo)info.clone();
            ItemInfo parentInfo = this.selectItem.getParent().getInfo();
            if (this.id.getText().length() <= 0) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.collective.run.6"));
                return result;
            }
            cloneInfo.setId(this.id.getText());
            if (this.id.isEnabled() && TreeItemUtil.findId((String)cloneInfo.getId(), (TreeItem)this.selectItem.getParent())) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                Object[] args = new String[]{Messages.getString((String)"parameter.id"), cloneInfo.getId()};
                result.setMessage(Messages.getString((String)"message.collective.run.16", (Object[])args));
                return result;
            }
            cloneInfo.setName(TreeItemUtil.getParameterName((String)cloneInfo.getId(), (TreeItem)TreeItemUtil.getTopTreeItem((TreeItem)this.selectItem)));
            if (this.option.getText().length() > 0) {
                cloneInfo.setPrefix(this.option.getText());
            } else {
                cloneInfo.setPrefix("");
            }
            ModifyMaster modify = new ModifyMaster();
            if (modify.update((ItemInfo)cloneInfo, parentInfo)) {
                this.selectItem.setInfo((ItemInfo)cloneInfo);
                this.composite.setCreateItem(null);
                this.composite.setUpdateItem(null);
                this.composite.getTreeViewer().refresh((Object)this.selectItem);
            } else {
                Object[] args = new Object[]{cloneInfo.getName()};
                MessageDialog.openError(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.collective.run.13", (Object[])args));
            }
        }
        return null;
    }

    protected ValidateResult validate() {
        ValidateResult result = null;
        result = this.createCommandParameterInfo();
        if (result != null) {
            return result;
        }
        return null;
    }

    protected void displayError(ValidateResult result) {
        MessageBox messageBox = new MessageBox(this.getShell(), 40);
        messageBox.setText(result.getID());
        messageBox.setMessage(result.getMessage());
        messageBox.open();
    }

    public TreeItem getSelectItem() {
        return this.selectItem;
    }

    public void setSelectItem(TreeItem selectItem) {
        this.selectItem = selectItem;
    }
}

