/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.run.util;

import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorStringValueInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class StringValueInfoManager {
    private static StringValueInfoManager INSTANCE = null;
    private Map<String, MonitorStringValueInfo> m_cashe = null;
    private ArrayList<MonitorStringValueInfo> m_orderList = null;
    private MonitorInfo m_monitorInfo = null;
    static /* synthetic */ Class class$0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StringValueInfoManager getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<StringValueInfoManager> clazz = StringValueInfoManager.class;
        synchronized (StringValueInfoManager.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new StringValueInfoManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private StringValueInfoManager() {
    }

    public void initialize(MonitorInfo monitorInfo) {
        this.m_monitorInfo = monitorInfo;
        this.loadLog();
    }

    public Object[] get() {
        Object[] records = this.m_orderList.toArray();
        return records;
    }

    public ArrayList getMonitorStringValueInfo() {
        return this.m_orderList;
    }

    public MonitorStringValueInfo get(String identifier) {
        return this.m_cashe.get(identifier);
    }

    public boolean add(MonitorStringValueInfo info) {
        int order = this.m_cashe.size() + 1;
        info.setOrderNo(order);
        info.setIdentifier("new" + order);
        this.m_cashe.put(info.getIdentifier(), info);
        this.m_orderList.add(info);
        return true;
    }

    public boolean modify(MonitorStringValueInfo info) {
        if (!this.m_cashe.containsKey(info.getIdentifier())) {
            return false;
        }
        this.m_cashe.put(info.getIdentifier(), info);
        this.m_orderList.set(info.getOrderNo() - 1, info);
        return true;
    }

    public boolean delete(String identifier) {
        if (!this.m_cashe.containsKey(identifier)) {
            return false;
        }
        MonitorStringValueInfo info = this.m_cashe.remove(identifier);
        this.m_orderList.remove(info.getOrderNo() - 1);
        int order = 0;
        Iterator<MonitorStringValueInfo> ite = this.m_orderList.iterator();
        while (ite.hasNext()) {
            ite.next().setOrderNo(++order);
        }
        return true;
    }

    public boolean upOrder(String identifier) {
        if (!this.m_cashe.containsKey(identifier)) {
            return false;
        }
        MonitorStringValueInfo info = this.m_cashe.get(identifier);
        int oldOrder = info.getOrderNo();
        int newOrder = oldOrder - 1;
        if (newOrder < 1) {
            return false;
        }
        return this.change(oldOrder, newOrder);
    }

    public boolean downOrder(String identifier) {
        if (!this.m_cashe.containsKey(identifier)) {
            return false;
        }
        MonitorStringValueInfo info = this.m_cashe.get(identifier);
        int oldOrder = info.getOrderNo();
        int newOrder = oldOrder + 1;
        if (newOrder > this.m_cashe.size()) {
            return false;
        }
        return this.change(oldOrder, newOrder);
    }

    private void loadLog() {
        ArrayList records;
        this.m_cashe = new HashMap<String, MonitorStringValueInfo>();
        this.m_orderList = new ArrayList();
        if (this.m_monitorInfo != null && (records = this.m_monitorInfo.getJudgementInfo()) != null) {
            int index = 0;
            for (Object o : records) {
                MonitorStringValueInfo info = (MonitorStringValueInfo)o;
                info.setIdentifier("new" + index);
                this.m_cashe.put(info.getIdentifier(), info);
                this.m_orderList.add(info);
                ++index;
            }
        }
    }

    private boolean change(int index1, int index2) {
        MonitorStringValueInfo info1 = this.m_orderList.get(--index1);
        MonitorStringValueInfo info2 = this.m_orderList.get(--index2);
        int order1 = info1.getOrderNo();
        int order2 = info2.getOrderNo();
        info1.setOrderNo(order2);
        info2.setOrderNo(order1);
        this.m_orderList.set(index1, info2);
        this.m_orderList.set(index2, info1);
        return true;
    }
}

