/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.view.action;

import com.clustercontrol.performance.action.RecordController;
import com.clustercontrol.performance.dialog.RecordSetDialog;
import com.clustercontrol.performance.util.Messages;
import com.clustercontrol.performance.view.CurrentListView;
import com.clustercontrol.performanceMGR.bean.CollectorProperty;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class ShowPropertyAction
implements IViewActionDelegate {
    public static final String ID = "com.clustercontrol.performance.view.action.ShowPropertyAction";
    private IViewPart viewPart;

    public void init(IViewPart view) {
        this.viewPart = view;
    }

    public void run(IAction action) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        CurrentListView currentListView = (CurrentListView)page.findView(Messages.getString("VIEW_CURRENT_LIST"));
        String collectorId = currentListView.getSelectedID();
        if (collectorId != null) {
            if (!RecordController.getInstance().checkPermissionRead()) {
                MessageDialog.openInformation(null, (String)com.clustercontrol.util.Messages.getString((String)"message"), (String)com.clustercontrol.util.Messages.getString((String)"message.accesscontrol.16"));
                return;
            }
            RecordController controller = RecordController.getInstance();
            if (controller == null) {
                MessageDialog.openError((Shell)this.viewPart.getSite().getShell(), (String)Messages.getString("MESSAGE_0020"), (String)Messages.getString("CONNECTION_ERROR_MESSAGE"));
                return;
            }
            controller.lock(collectorId);
            CollectorProperty property = controller.getCollectorProperty(collectorId);
            if (property == null) {
                MessageDialog.openError((Shell)this.viewPart.getSite().getShell(), (String)Messages.getString("MESSAGE_0020"), (String)Messages.getString("GET_PROPERTY_ERROR_MESSAGE"));
                return;
            }
            Shell shell = new Shell();
            RecordSetDialog propertyDialog = new RecordSetDialog(shell, property, false);
            propertyDialog.open();
        } else {
            String msg = Messages.getString("MESSAGE_0014");
            MessageDialog.openError(null, (String)Messages.getString("ERROR_IN_JP"), (String)msg);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

