/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.action;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.performance.composite.RealtimeGraphComposite;
import com.clustercontrol.performance.util.CollectorItemCodeFactory;
import com.clustercontrol.performance.util.RealtimeCollectThread;
import com.clustercontrol.performance.util.RealtimeCollectorInfo;
import com.clustercontrol.performance.view.RealtimeGraphView;
import com.clustercontrol.performanceMGR.bean.CollectorItemInfo;
import com.clustercontrol.performanceMGR.ejb.session.CollectorController;
import com.clustercontrol.performanceMGR.ejb.session.CollectorControllerHome;
import com.clustercontrol.util.LoginManager;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.ejb.CreateException;
import javax.naming.NamingException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;
import org.jnp.interfaces.NamingContext;

public class RealtimeController {
    private static int RETRYCOUNT = 1;
    private Collection dataCollection;
    private static RealtimeController m_instance = null;
    private CollectorController bean;
    private boolean isRun = false;
    private static boolean running = false;
    private RealtimeGraphView view;
    private static Composite local_parent = null;
    private RealtimeCollectorInfo collectorInfo = null;
    private Date startTimestamp;
    private Iterator itr;
    public static final String KEY_EJB_URL = "ejbUrl";
    public static final String VALUE_EJB_URL = "jnp://localhost:1099";

    private RealtimeController() {
        this.initialize();
    }

    private void initialize() {
    }

    public static synchronized RealtimeController getInstance() {
        if (m_instance == null) {
            m_instance = new RealtimeController();
            m_instance.createBean();
        }
        if (RealtimeController.m_instance.bean == null) {
            m_instance = null;
            return null;
        }
        return m_instance;
    }

    public void setCollectorInfo(RealtimeCollectorInfo collectorInfo) {
        this.collectorInfo = collectorInfo;
    }

    private void createBean() {
        try {
            this.bean = this.getCollectorControllerHome().create();
        }
        catch (RemoteException remoteException) {
            this.bean = null;
        }
        catch (CreateException createException) {
            this.bean = null;
        }
        catch (NamingException namingException) {
            this.bean = null;
        }
    }

    private CollectorControllerHome getCollectorControllerHome() throws NamingException {
        return (CollectorControllerHome)this.getContext().lookup("CollectorController");
    }

    private NamingContext getContext() throws NamingException {
        NamingContext namingContext = LoginManager.getContextManager().getNamingContext();
        return namingContext;
    }

    private String getUrl() {
        IPreferenceStore store = ClusterControlPlugin.getDefault().getPreferenceStore();
        String url = store.getString(KEY_EJB_URL);
        if (url.compareTo("") == 0) {
            url = VALUE_EJB_URL;
        }
        return url;
    }

    public void startCollect(Date timestamp, int timestampId, int interval, int requestInterval, RealtimeCollectThread collector, String itemCode, String itemId, int deviceIndex, String displayType, String facilityId, boolean check, RealtimeGraphComposite graphComposite) {
        ArrayList<CollectorItemInfo> itemList = new ArrayList<CollectorItemInfo>();
        if (displayType.equals("SelectedScope") || displayType.equals("SubScope")) {
            itemList.add(new CollectorItemInfo(null, 0, itemCode, deviceIndex, "", false));
        } else if (displayType.equals("Detail")) {
            List itemCodeList = CollectorItemCodeFactory.getSubItemCode(itemCode);
            int i = 0;
            while (i < itemCodeList.size()) {
                itemList.add(new CollectorItemInfo(null, i, itemCodeList.get(i).toString(), deviceIndex, "", false));
                ++i;
            }
        }
        CollectorController myBean = null;
        CollectorItemInfo[] cii = null;
        try {
            myBean = this.getCollectorControllerHome().create();
            cii = new CollectorItemInfo[itemList.size()];
            itemList.toArray(cii);
            myBean.createRealtimeColletor(facilityId, requestInterval, itemList);
        }
        catch (CreateException createException) {
        }
        catch (NamingException namingException) {
        }
        catch (RemoteException remoteException) {}
        running = true;
        this.setStartTimestamp();
        while (this.collectorInfo.isCurrentCollect(timestamp, timestampId)) {
            if (myBean == null) continue;
            try {
                if (displayType.equals("SelectedScope")) {
                    this.dataCollection = myBean.getRealtimeCollectedData(facilityId, 0, 0);
                } else if (displayType.equals("Detail")) {
                    this.dataCollection = myBean.getRealtimeCollectedDataAll(facilityId);
                } else if (displayType.equals("SubScope")) {
                    this.dataCollection = myBean.getRealtimeCollectedData(facilityId, 0, 1);
                }
                this.itr = this.dataCollection.iterator();
            }
            catch (RemoteException e) {
                e.printStackTrace();
                myBean = null;
                this.itr = null;
            }
            if (this.itr == null) continue;
            this.isRun = collector.setDataList(this.itr, displayType);
            try {
                Thread.sleep(interval * 1000);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    public void changeRunning(boolean _running) {
        running = _running;
    }

    public static boolean isRunning() {
        return running;
    }

    public static void setRunning(boolean _running) {
        running = _running;
    }

    public Date getStartTimestamp() {
        return this.startTimestamp;
    }

    public void setStartTimestamp() {
        this.startTimestamp = new Date(System.currentTimeMillis());
    }
}

