/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.preference;

import com.clustercontrol.monitor.ui.MonitorUIPlugin;
import com.clustercontrol.monitor.view.EventView;
import com.clustercontrol.monitor.view.ScopeView;
import com.clustercontrol.monitor.view.StatusView;
import com.clustercontrol.util.Messages;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;

public class MonitorPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String P_SCOPE_UPDATE_FLG = "scopeUpdateFlg";
    public static final String P_SCOPE_UPDATE_CYCLE = "scopeUpdateCycle";
    public static final String P_STATUS_UPDATE_FLG = "statusUpdateFlg";
    public static final String P_STATUS_UPDATE_CYCLE = "stateUpdateCycle";
    public static final String P_EVENT_UPDATE_FLG = "eventUpdateFlg";
    public static final String P_EVENT_UPDATE_CYCLE = "eventUpdateCycle";
    public static final String P_EVENT_MESSAGE_FLG = "eventMessageFlg";
    private static final String MSG_ENABLE = Messages.getString((String)"autoupdate.enable");
    private static final String MSG_CYCLE = String.valueOf(Messages.getString((String)"autoupdate.cycle")) + " : ";
    private static final String MSG_MESSAGE = Messages.getString((String)"over.limit.message");

    public MonitorPreferencePage() {
        super(1);
        this.setPreferenceStore(MonitorUIPlugin.getDefault().getPreferenceStore());
        this.initializeDefaults();
    }

    private void initializeDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setDefault(P_SCOPE_UPDATE_FLG, true);
        store.setDefault(P_SCOPE_UPDATE_CYCLE, 10);
        store.setDefault(P_STATUS_UPDATE_FLG, true);
        store.setDefault(P_STATUS_UPDATE_CYCLE, 10);
        store.setDefault(P_EVENT_UPDATE_FLG, true);
        store.setDefault(P_EVENT_UPDATE_CYCLE, 10);
        store.setDefault(P_EVENT_MESSAGE_FLG, true);
    }

    public void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        GridData gridData = null;
        Group scopeGroup = new Group(parent, 32);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 10;
        gridData.verticalSpan = 10;
        scopeGroup.setLayoutData((Object)gridData);
        scopeGroup.setText(Messages.getString((String)"view.monitor.scope"));
        this.addField((FieldEditor)new BooleanFieldEditor(P_SCOPE_UPDATE_FLG, MSG_ENABLE, (Composite)scopeGroup));
        this.addField((FieldEditor)new IntegerFieldEditor(P_SCOPE_UPDATE_CYCLE, MSG_CYCLE, (Composite)scopeGroup));
        Group statusGroup = new Group(parent, 32);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 10;
        gridData.verticalSpan = 10;
        statusGroup.setLayoutData((Object)gridData);
        statusGroup.setText(Messages.getString((String)"view.monitor.status"));
        this.addField((FieldEditor)new BooleanFieldEditor(P_STATUS_UPDATE_FLG, MSG_ENABLE, (Composite)statusGroup));
        this.addField((FieldEditor)new IntegerFieldEditor(P_STATUS_UPDATE_CYCLE, MSG_CYCLE, (Composite)statusGroup));
        Group eventGroup = new Group(parent, 32);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 10;
        gridData.verticalSpan = 10;
        eventGroup.setLayoutData((Object)gridData);
        eventGroup.setText(Messages.getString((String)"view.monitor.event"));
        this.addField((FieldEditor)new BooleanFieldEditor(P_EVENT_UPDATE_FLG, MSG_ENABLE, (Composite)eventGroup));
        this.addField((FieldEditor)new IntegerFieldEditor(P_EVENT_UPDATE_CYCLE, MSG_CYCLE, (Composite)eventGroup));
        this.addField((FieldEditor)new BooleanFieldEditor(P_EVENT_MESSAGE_FLG, MSG_MESSAGE, (Composite)eventGroup));
    }

    public boolean performOk() {
        boolean result = super.performOk();
        this.applySetting();
        return result;
    }

    protected void applySetting() {
        IPreferenceStore store = this.getPreferenceStore();
        IWorkbench workbench = MonitorUIPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int windowCount = windows.length;
        int i = 0;
        while (i < windowCount) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int pageCount = pages.length;
            int j = 0;
            while (j < pageCount) {
                EventView eventView;
                StatusView statusView;
                ScopeView scopeView = (ScopeView)pages[j].findView("com.clustercontrol.monitor.view.ScopeView");
                if (scopeView != null) {
                    int cycle = store.getInt(P_SCOPE_UPDATE_CYCLE);
                    scopeView.setInterval(cycle);
                    if (store.getBoolean(P_SCOPE_UPDATE_FLG)) {
                        scopeView.startAutoReload();
                    } else {
                        scopeView.stopAutoReload();
                    }
                }
                if ((statusView = (StatusView)pages[j].findView("com.clustercontrol.monitor.view.StatusView")) != null) {
                    int cycle = store.getInt(P_STATUS_UPDATE_CYCLE);
                    statusView.setInterval(cycle);
                    if (store.getBoolean(P_STATUS_UPDATE_FLG)) {
                        statusView.startAutoReload();
                    } else {
                        statusView.stopAutoReload();
                    }
                }
                if ((eventView = (EventView)pages[j].findView("com.clustercontrol.monitor.view.EventView")) != null) {
                    int cycle = store.getInt(P_EVENT_UPDATE_CYCLE);
                    eventView.setInterval(cycle);
                    if (store.getBoolean(P_EVENT_UPDATE_FLG)) {
                        eventView.startAutoReload();
                    } else {
                        eventView.stopAutoReload();
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public void init(IWorkbench workbench) {
    }
}

