/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.markers.internal.DialogMarkerFilter;
import org.eclipse.ui.views.markers.internal.Messages;
import org.eclipse.ui.views.markers.internal.TaskFilter;

public class DialogTaskFilter
extends DialogMarkerFilter {
    private DescriptionGroup descriptionGroup;
    private PriorityGroup priorityGroup;
    private StatusGroup statusGroup;

    public DialogTaskFilter(Shell parentShell, TaskFilter filter) {
        super(parentShell, filter);
    }

    protected void createAttributesArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(5, false);
        layout.verticalSpacing = 7;
        composite.setLayout((Layout)layout);
        this.descriptionGroup = new DescriptionGroup(composite);
        this.priorityGroup = new PriorityGroup(composite);
        this.statusGroup = new StatusGroup(composite);
    }

    protected void updateFilterFromUI() {
        TaskFilter filter = (TaskFilter)this.getFilter();
        filter.setContains(this.descriptionGroup.getContains());
        filter.setDescription(this.descriptionGroup.getDescription().trim());
        filter.setSelectByPriority(this.priorityGroup.isEnabled());
        int priority = 0;
        if (this.priorityGroup.isHighSelected()) {
            priority |= 4;
        }
        if (this.priorityGroup.isNormalSelected()) {
            priority |= 2;
        }
        if (this.priorityGroup.isLowSelected()) {
            priority |= 1;
        }
        filter.setPriority(priority);
        filter.setSelectByDone(this.statusGroup.isEnabled());
        filter.setDone(this.statusGroup.getDone());
        super.updateFilterFromUI();
    }

    protected void updateUIFromFilter() {
        TaskFilter filter = (TaskFilter)this.getFilter();
        this.descriptionGroup.setContains(filter.getContains());
        this.descriptionGroup.setDescription(filter.getDescription());
        this.priorityGroup.setEnabled(filter.getSelectByPriority());
        int priority = filter.getPriority();
        this.priorityGroup.setHighSelected((priority & 4) > 0);
        this.priorityGroup.setNormalSelected((priority & 2) > 0);
        this.priorityGroup.setLowSelected((priority & 1) > 0);
        this.statusGroup.setEnabled(filter.getSelectByDone());
        this.statusGroup.setDone(filter.getDone());
        super.updateUIFromFilter();
    }

    protected void updateEnabledState() {
        super.updateEnabledState();
        this.descriptionGroup.updateEnablement();
        this.priorityGroup.updateEnablement();
        this.statusGroup.updateEnablement();
    }

    protected void resetPressed() {
        this.descriptionGroup.setContains(true);
        this.descriptionGroup.setDescription("");
        this.priorityGroup.setEnabled(false);
        this.priorityGroup.setHighSelected(false);
        this.priorityGroup.setNormalSelected(false);
        this.priorityGroup.setLowSelected(false);
        this.statusGroup.setEnabled(false);
        this.statusGroup.setDone(false);
        super.resetPressed();
    }

    private class DescriptionGroup {
        private Label descriptionLabel;
        private Combo combo;
        private Text description;
        private String contains = Messages.getString("filtersDialog.contains");
        private String doesNotContain = Messages.getString("filtersDialog.doesNotContain");

        public DescriptionGroup(Composite parent) {
            this.descriptionLabel = new Label(parent, 0);
            this.descriptionLabel.setFont(parent.getFont());
            this.descriptionLabel.setText(Messages.getString("filtersDialog.descriptionLabel"));
            this.combo = new Combo(parent, 8);
            this.combo.setFont(parent.getFont());
            this.combo.add(this.contains);
            this.combo.add(this.doesNotContain);
            this.combo.addSelectionListener(DialogTaskFilter.this.selectionListener);
            this.combo.addTraverseListener(new TraverseListener(this){
                final /* synthetic */ DescriptionGroup this$1;
                {
                    this.this$1 = descriptionGroup;
                }

                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == 2 || e.detail == 4) {
                        e.doit = false;
                    }
                }
            });
            this.description = new Text(parent, 2052);
            this.description.setFont(parent.getFont());
            GridData data = new GridData(768);
            data.horizontalSpan = 3;
            this.description.setLayoutData((Object)data);
            this.description.addModifyListener(new ModifyListener(this){
                final /* synthetic */ DescriptionGroup this$1;
                {
                    this.this$1 = descriptionGroup;
                }

                public void modifyText(ModifyEvent e) {
                    DescriptionGroup.access$0(this.this$1).markDirty();
                }
            });
        }

        public boolean getContains() {
            return this.combo.getSelectionIndex() == this.combo.indexOf(this.contains);
        }

        public void setContains(boolean value) {
            if (value) {
                this.combo.select(this.combo.indexOf(this.contains));
            } else {
                this.combo.select(this.combo.indexOf(this.doesNotContain));
            }
        }

        public void setDescription(String text) {
            if (text == null) {
                this.description.setText("");
            } else {
                this.description.setText(text);
            }
        }

        public String getDescription() {
            return this.description.getText();
        }

        public void updateEnablement() {
            this.descriptionLabel.setEnabled(DialogTaskFilter.this.isFilterEnabled());
            this.combo.setEnabled(DialogTaskFilter.this.isFilterEnabled());
            this.description.setEnabled(DialogTaskFilter.this.isFilterEnabled());
        }

        static /* synthetic */ DialogTaskFilter access$0(DescriptionGroup descriptionGroup) {
            return descriptionGroup.DialogTaskFilter.this;
        }
    }

    private class PriorityGroup {
        private Button enablementButton;
        private Button highButton;
        private Button normalButton;
        private Button lowButton;

        public PriorityGroup(Composite parent) {
            SelectionAdapter listener = new SelectionAdapter(this){
                final /* synthetic */ PriorityGroup this$1;
                {
                    this.this$1 = priorityGroup;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.updateEnablement();
                    PriorityGroup.access$0(this.this$1).markDirty();
                }
            };
            this.enablementButton = new Button(parent, 32);
            GridData data = new GridData(768);
            data.horizontalSpan = 2;
            this.enablementButton.setLayoutData((Object)data);
            this.enablementButton.setFont(parent.getFont());
            this.enablementButton.setText(Messages.getString("filtersDialog.priorityLabel"));
            this.enablementButton.addSelectionListener((SelectionListener)listener);
            this.highButton = new Button(parent, 32);
            this.highButton.setFont(parent.getFont());
            this.highButton.setText(Messages.getString("filtersDialog.priorityHigh"));
            this.highButton.setLayoutData((Object)new GridData(768));
            this.highButton.addSelectionListener(DialogTaskFilter.this.selectionListener);
            this.normalButton = new Button(parent, 32);
            this.normalButton.setFont(parent.getFont());
            this.normalButton.setText(Messages.getString("filtersDialog.priorityNormal"));
            this.normalButton.setLayoutData((Object)new GridData(768));
            this.normalButton.addSelectionListener(DialogTaskFilter.this.selectionListener);
            this.lowButton = new Button(parent, 32);
            this.lowButton.setFont(parent.getFont());
            this.lowButton.setText(Messages.getString("filtersDialog.priorityLow"));
            this.lowButton.setLayoutData((Object)new GridData(768));
            this.lowButton.addSelectionListener(DialogTaskFilter.this.selectionListener);
        }

        public boolean isEnabled() {
            return this.enablementButton.getSelection();
        }

        public void setEnabled(boolean enabled) {
            this.enablementButton.setSelection(enabled);
        }

        public boolean isHighSelected() {
            return this.highButton.getSelection();
        }

        public void setHighSelected(boolean selected) {
            this.highButton.setSelection(selected);
        }

        public boolean isNormalSelected() {
            return this.normalButton.getSelection();
        }

        public void setNormalSelected(boolean selected) {
            this.normalButton.setSelection(selected);
        }

        public boolean isLowSelected() {
            return this.lowButton.getSelection();
        }

        public void setLowSelected(boolean selected) {
            this.lowButton.setSelection(selected);
        }

        public void updateEnablement() {
            this.enablementButton.setEnabled(DialogTaskFilter.this.isFilterEnabled());
            this.highButton.setEnabled(this.enablementButton.isEnabled() && this.isEnabled());
            this.normalButton.setEnabled(this.enablementButton.isEnabled() && this.isEnabled());
            this.lowButton.setEnabled(this.enablementButton.isEnabled() && this.isEnabled());
        }

        static /* synthetic */ DialogTaskFilter access$0(PriorityGroup priorityGroup) {
            return priorityGroup.DialogTaskFilter.this;
        }
    }

    private class StatusGroup {
        private Button enablementButton;
        private Button completeButton;
        private Button incompleteButton;

        public StatusGroup(Composite parent) {
            SelectionAdapter enablementListener = new SelectionAdapter(this){
                final /* synthetic */ StatusGroup this$1;
                {
                    this.this$1 = statusGroup;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.updateEnablement();
                    StatusGroup.access$2(this.this$1).markDirty();
                }
            };
            this.enablementButton = new Button(parent, 32);
            GridData data = new GridData(768);
            data.horizontalSpan = 2;
            this.enablementButton.setLayoutData((Object)data);
            this.enablementButton.setFont(parent.getFont());
            this.enablementButton.setText(Messages.getString("filtersDialog.statusLabel"));
            this.enablementButton.addSelectionListener((SelectionListener)enablementListener);
            Composite composite = new Composite(parent, 0);
            composite.setFont(parent.getFont());
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            data = new GridData(768);
            data.horizontalSpan = 3;
            composite.setLayoutData((Object)data);
            SelectionAdapter listener = new SelectionAdapter(this){
                final /* synthetic */ StatusGroup this$1;
                {
                    this.this$1 = statusGroup;
                }

                public void widgetSelected(SelectionEvent e) {
                    StatusGroup.access$0(this.this$1).setSelection(!StatusGroup.access$1(this.this$1).getSelection());
                    StatusGroup.access$1(this.this$1).setSelection(!StatusGroup.access$0(this.this$1).getSelection());
                    StatusGroup.access$2(this.this$1).markDirty();
                }
            };
            this.completeButton = new Button(composite, 16);
            this.completeButton.setFont(composite.getFont());
            this.completeButton.setText(Messages.getString("filtersDialog.statusComplete"));
            this.completeButton.addSelectionListener((SelectionListener)listener);
            this.incompleteButton = new Button(composite, 16);
            this.incompleteButton.setFont(composite.getFont());
            this.incompleteButton.setText(Messages.getString("filtersDialog.statusIncomplete"));
            this.incompleteButton.addSelectionListener((SelectionListener)listener);
        }

        public boolean isEnabled() {
            return this.enablementButton.getSelection();
        }

        public void setEnabled(boolean enabled) {
            this.enablementButton.setSelection(enabled);
        }

        public boolean getDone() {
            return this.completeButton.getSelection();
        }

        public void setDone(boolean done) {
            this.completeButton.setSelection(done);
            this.incompleteButton.setSelection(!done);
        }

        public void updateEnablement() {
            this.enablementButton.setEnabled(DialogTaskFilter.this.isFilterEnabled());
            this.completeButton.setEnabled(this.enablementButton.isEnabled() && this.isEnabled());
            this.incompleteButton.setEnabled(this.enablementButton.isEnabled() && this.isEnabled());
        }

        static /* synthetic */ Button access$0(StatusGroup statusGroup) {
            return statusGroup.completeButton;
        }

        static /* synthetic */ Button access$1(StatusGroup statusGroup) {
            return statusGroup.incompleteButton;
        }

        static /* synthetic */ DialogTaskFilter access$2(StatusGroup statusGroup) {
            return statusGroup.DialogTaskFilter.this;
        }
    }
}

