/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.factory;

import com.clustercontrol.bean.ConfirmConstant;
import com.clustercontrol.bean.FacilityTargetConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.monitor.bean.EventListInfo;
import com.clustercontrol.monitor.bean.ReportEventInfo;
import com.clustercontrol.monitor.ejb.entity.EventLogLocal;
import com.clustercontrol.monitor.ejb.entity.EventLogUtil;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.util.apllog.AplLogger;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectEvent {
    protected static Log m_log = LogFactory.getLog(SelectEvent.class);
    private int m_eventMaxDisplayNumber = -1;

    public SelectEvent() {
        try {
            InitialContext initialContext = new InitialContext();
            if (initialContext.lookup("java:comp/env/EventMaxDisplayNumber") instanceof Integer) {
                this.m_eventMaxDisplayNumber = (Integer)initialContext.lookup("java:comp/env/EventMaxDisplayNumber");
            }
        }
        catch (NamingException e) {
            m_log.error((Object)("SelectEvent():" + e.getMessage()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EventListInfo getEventList(String facilityId, int level) throws CreateException, FinderException, NamingException, SQLException {
        EventListInfo list = new EventListInfo();
        try {
            String[] facilityIds = null;
            if (facilityId != null && !"".equals(facilityId)) {
                if (level == -1) {
                    if (facilityId == null || "".equals(facilityId)) return null;
                    facilityIds = new String[]{facilityId};
                } else {
                    ArrayList facilityIdList = RepositoryControllerUtil.getLocalHome().create().getFacilityIdList(facilityId, level);
                    if (facilityIdList != null && facilityIdList.size() > 0) {
                        facilityIds = new String[facilityIdList.size()];
                        facilityIdList.toArray(facilityIds);
                    } else {
                        if (facilityId == null) return null;
                        facilityIds = new String[]{facilityId};
                    }
                }
            }
            Integer limit = null;
            if (this.m_eventMaxDisplayNumber != -1) {
                limit = new Integer(this.m_eventMaxDisplayNumber + 1);
            }
            Collection ct = EventLogUtil.getLocalHome().findEvent(facilityIds, null, null, null, null, null, null, null, new Integer(0), false, limit);
            if (this.m_eventMaxDisplayNumber == -1 || ct.size() > this.m_eventMaxDisplayNumber) {
                int critical = EventLogUtil.getLocalHome().countEvent(facilityIds, 0, null, null, null, null, null, null, new Integer(0));
                int warning = EventLogUtil.getLocalHome().countEvent(facilityIds, 2, null, null, null, null, null, null, new Integer(0));
                int info = EventLogUtil.getLocalHome().countEvent(facilityIds, 3, null, null, null, null, null, null, new Integer(0));
                int unKnown = EventLogUtil.getLocalHome().countEvent(facilityIds, 1, null, null, null, null, null, null, new Integer(0));
                int total = critical + warning + info + unKnown;
                list.setCritical(critical);
                list.setWarning(warning);
                list.setInfo(info);
                list.setUnKnown(unKnown);
                list.setTotal(total);
            }
            this.collectionToEventList(ct, list);
            return list;
        }
        catch (CreateException e) {
            this.outputLog((Exception)((Object)e), "getEventList()", facilityId, null, null, null, null, null, null, null, null, null);
            throw e;
        }
        catch (FinderException e) {
            this.outputLog((Exception)((Object)e), "getEventList()", facilityId, null, null, null, null, null, null, null, null, null);
            throw e;
        }
        catch (NamingException e) {
            this.outputLog(e, "getEventList()", facilityId, null, null, null, null, null, null, null, null, null);
            throw e;
        }
    }

    public EventListInfo getEventList(String facilityId, Property property) throws CreateException, FinderException, NamingException, SQLException {
        EventListInfo list = new EventListInfo();
        Integer priority = null;
        Timestamp outputFromDate = null;
        Timestamp outputToDate = null;
        Timestamp generationFromDate = null;
        Timestamp generationToDate = null;
        String facilityType = null;
        String application = null;
        String message = null;
        Integer confirmFlg = null;
        try {
            int confirmFlgType;
            int priorityType;
            ArrayList values = null;
            values = PropertyUtil.getPropertyValue((Property)property, (String)"priority");
            if (!"".equals((String)values.get(0)) && (priorityType = PriorityConstant.stringToType((String)((String)values.get(0)))) != -1) {
                priority = new Integer(priorityType);
            }
            if ((values = PropertyUtil.getPropertyValue((Property)property, (String)"outputFromDate")).get(0) instanceof Date) {
                outputFromDate = new Timestamp(((Date)values.get(0)).getTime());
                outputFromDate.setNanos(0);
            }
            if ((values = PropertyUtil.getPropertyValue((Property)property, (String)"outputToDate")).get(0) instanceof Date) {
                outputToDate = new Timestamp(((Date)values.get(0)).getTime());
                outputToDate.setNanos(999999999);
            }
            if ((values = PropertyUtil.getPropertyValue((Property)property, (String)"generationFromDate")).get(0) instanceof Date) {
                generationFromDate = new Timestamp(((Date)values.get(0)).getTime());
                generationFromDate.setNanos(0);
            }
            if ((values = PropertyUtil.getPropertyValue((Property)property, (String)"generationToDate")).get(0) instanceof Date) {
                generationToDate = new Timestamp(((Date)values.get(0)).getTime());
                generationToDate.setNanos(999999999);
            }
            if (!"".equals((String)(values = PropertyUtil.getPropertyValue((Property)property, (String)"facilityType")).get(0))) {
                facilityType = (String)values.get(0);
            }
            if (!"".equals((String)(values = PropertyUtil.getPropertyValue((Property)property, (String)"application")).get(0))) {
                application = (String)values.get(0);
            }
            if (!"".equals((String)(values = PropertyUtil.getPropertyValue((Property)property, (String)"message")).get(0))) {
                message = (String)values.get(0);
            }
            if ((confirmFlgType = ConfirmConstant.stringToType((String)((String)(values = PropertyUtil.getPropertyValue((Property)property, (String)"confirmed")).get(0)))) != -1) {
                confirmFlg = new Integer(confirmFlgType);
            }
            String[] facilityIds = null;
            if (facilityId != null && !"".equals(facilityId)) {
                ArrayList facilityIdList;
                int level = 0;
                if (FacilityTargetConstant.STRING_BENEATH.equals(facilityType)) {
                    level = 1;
                }
                if ((facilityIdList = RepositoryControllerUtil.getLocalHome().create().getFacilityIdList(facilityId, level)) != null && facilityIdList.size() > 0) {
                    facilityIds = new String[facilityIdList.size()];
                    facilityIdList.toArray(facilityIds);
                } else if (facilityId != null) {
                    facilityIds = new String[]{facilityId};
                } else {
                    return null;
                }
            }
            Integer limit = null;
            if (this.m_eventMaxDisplayNumber != -1) {
                limit = new Integer(this.m_eventMaxDisplayNumber + 1);
            }
            Collection ct = EventLogUtil.getLocalHome().findEvent(facilityIds, priority, outputFromDate, outputToDate, generationFromDate, generationToDate, application, message, confirmFlg, false, limit);
            if (this.m_eventMaxDisplayNumber == -1 || ct.size() > this.m_eventMaxDisplayNumber) {
                int critical = EventLogUtil.getLocalHome().countEvent(facilityIds, 0, outputFromDate, outputToDate, generationFromDate, generationToDate, application, message, confirmFlg);
                int warning = EventLogUtil.getLocalHome().countEvent(facilityIds, 2, outputFromDate, outputToDate, generationFromDate, generationToDate, application, message, confirmFlg);
                int info = EventLogUtil.getLocalHome().countEvent(facilityIds, 3, outputFromDate, outputToDate, generationFromDate, generationToDate, application, message, confirmFlg);
                int unKnown = EventLogUtil.getLocalHome().countEvent(facilityIds, 1, outputFromDate, outputToDate, generationFromDate, generationToDate, application, message, confirmFlg);
                int total = critical + warning + info + unKnown;
                list.setCritical(critical);
                list.setWarning(warning);
                list.setInfo(info);
                list.setUnKnown(unKnown);
                list.setTotal(total);
            }
            this.collectionToEventList(ct, list);
        }
        catch (CreateException e) {
            this.outputLog((Exception)((Object)e), "getEventList()", facilityId, priority, outputFromDate, outputToDate, generationFromDate, generationToDate, facilityType, application, message, confirmFlg);
            throw e;
        }
        catch (FinderException e) {
            this.outputLog((Exception)((Object)e), "getEventList()", facilityId, priority, outputFromDate, outputToDate, generationFromDate, generationToDate, facilityType, application, message, confirmFlg);
            throw e;
        }
        catch (NamingException e) {
            this.outputLog(e, "getEventList()", facilityId, priority, outputFromDate, outputToDate, generationFromDate, generationToDate, facilityType, application, message, confirmFlg);
            throw e;
        }
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EventLogLocal getHighPriorityEvent(String facilityId, int level) throws CreateException, FinderException, NamingException {
        EventLogLocal event = null;
        try {
            String[] facilityIds = null;
            if (level == -1) {
                if (facilityId == null) return null;
                if ("".equals(facilityId)) return null;
                facilityIds = new String[]{facilityId};
            } else {
                ArrayList facilityIdList = RepositoryControllerUtil.getLocalHome().create().getFacilityIdList(facilityId, level);
                if (facilityIdList != null && facilityIdList.size() > 0) {
                    facilityIds = new String[facilityIdList.size()];
                    facilityIdList.toArray(facilityIds);
                } else {
                    if (facilityId == null) return null;
                    facilityIds = new String[]{facilityId};
                }
            }
            Collection ct = EventLogUtil.getLocalHome().findHighPriorityEvent(facilityIds, null, null, null, null, null, null, null, new Integer(0));
            Iterator itr = ct.iterator();
            if (!itr.hasNext()) return event;
            return (EventLogLocal)itr.next();
        }
        catch (CreateException e) {
            m_log.debug((Object)("getHighPriorityEvent():" + e.getMessage()));
            throw e;
        }
        catch (FinderException e) {
            m_log.debug((Object)("getHighPriorityEvent():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            m_log.debug((Object)("getHighPriorityEvent():" + e.getMessage()));
            throw e;
        }
    }

    public ArrayList getEventListForReport(String facilityId, Property property) throws CreateException, FinderException, NamingException, IndexOutOfBoundsException {
        ArrayList<ReportEventInfo> list = null;
        Integer priority = null;
        Timestamp outputFromDate = null;
        Timestamp outputToDate = null;
        Timestamp generationFromDate = null;
        Timestamp generationToDate = null;
        String facilityType = null;
        String application = null;
        String message = null;
        Integer confirmFlg = null;
        try {
            int confirmFlgType;
            int priorityType;
            ArrayList values = null;
            values = PropertyUtil.getPropertyValue((Property)property, (String)"priority");
            if (!"".equals((String)values.get(0)) && (priorityType = PriorityConstant.stringToType((String)((String)values.get(0)))) != -1) {
                priority = new Integer(priorityType);
            }
            if ((values = PropertyUtil.getPropertyValue((Property)property, (String)"outputFromDate")).get(0) instanceof Date) {
                outputFromDate = new Timestamp(((Date)values.get(0)).getTime());
                outputFromDate.setNanos(0);
            }
            if ((values = PropertyUtil.getPropertyValue((Property)property, (String)"outputToDate")).get(0) instanceof Date) {
                outputToDate = new Timestamp(((Date)values.get(0)).getTime());
                outputToDate.setNanos(999999999);
            }
            if ((values = PropertyUtil.getPropertyValue((Property)property, (String)"generationFromDate")).get(0) instanceof Date) {
                generationFromDate = new Timestamp(((Date)values.get(0)).getTime());
                generationFromDate.setNanos(0);
            }
            if ((values = PropertyUtil.getPropertyValue((Property)property, (String)"generationToDate")).get(0) instanceof Date) {
                generationToDate = new Timestamp(((Date)values.get(0)).getTime());
                generationToDate.setNanos(999999999);
            }
            if (!"".equals((String)(values = PropertyUtil.getPropertyValue((Property)property, (String)"facilityType")).get(0))) {
                facilityType = (String)values.get(0);
            }
            if (!"".equals((String)(values = PropertyUtil.getPropertyValue((Property)property, (String)"application")).get(0))) {
                application = (String)values.get(0);
            }
            if (!"".equals((String)(values = PropertyUtil.getPropertyValue((Property)property, (String)"message")).get(0))) {
                message = (String)values.get(0);
            }
            if ((confirmFlgType = ConfirmConstant.stringToType((String)((String)(values = PropertyUtil.getPropertyValue((Property)property, (String)"confirmed")).get(0)))) != -1) {
                confirmFlg = new Integer(confirmFlgType);
            }
            String[] facilityIds = null;
            if (facilityId != null && !"".equals(facilityId)) {
                ArrayList facilityIdList;
                int level = 0;
                if (FacilityTargetConstant.STRING_BENEATH.equals(facilityType)) {
                    level = 1;
                }
                if ((facilityIdList = RepositoryControllerUtil.getLocalHome().create().getFacilityIdList(facilityId, level)) != null && facilityIdList.size() > 0) {
                    facilityIds = new String[facilityIdList.size()];
                    facilityIdList.toArray(facilityIds);
                } else if (facilityId != null) {
                    facilityIds = new String[]{facilityId};
                } else {
                    return null;
                }
            }
            Collection ct = EventLogUtil.getLocalHome().findEvent(facilityIds, priority, outputFromDate, outputToDate, generationFromDate, generationToDate, application, message, confirmFlg, true, null);
            list = this.collectionToArrayForReportd(ct);
        }
        catch (CreateException e) {
            this.outputLog((Exception)((Object)e), "getEventListForReport()", facilityId, priority, outputFromDate, outputToDate, generationFromDate, generationToDate, facilityType, application, message, confirmFlg);
            throw e;
        }
        catch (FinderException e) {
            this.outputLog((Exception)((Object)e), "getEventListForReport()", facilityId, priority, outputFromDate, outputToDate, generationFromDate, generationToDate, facilityType, application, message, confirmFlg);
            throw e;
        }
        catch (NamingException e) {
            this.outputLog(e, "getEventListForReport()", facilityId, priority, outputFromDate, outputToDate, generationFromDate, generationToDate, facilityType, application, message, confirmFlg);
            throw e;
        }
        return list;
    }

    private void collectionToEventList(Collection ct, EventListInfo eventList) {
        int critical = 0;
        int warning = 0;
        int info = 0;
        int unKnown = 0;
        int total = ct.size();
        ArrayList list = new ArrayList();
        for (EventLogLocal event : ct) {
            ArrayList<Object> eventInfo = new ArrayList<Object>();
            eventInfo.add(event.getPriority());
            eventInfo.add(new Date(event.getOutputDate().getTime()));
            eventInfo.add(new Date(event.getGenerationDate().getTime()));
            eventInfo.add(event.getPluginId());
            eventInfo.add(event.getMonitorId());
            eventInfo.add(event.getFacilityId());
            eventInfo.add(event.getScopeText());
            eventInfo.add(event.getApplication());
            eventInfo.add(event.getMessageId());
            eventInfo.add(event.getMessage());
            eventInfo.add(event.getConfirmFlg());
            list.add(eventInfo);
            if (this.m_eventMaxDisplayNumber == -1) continue;
            if (ct.size() <= this.m_eventMaxDisplayNumber) {
                if (event.getPriority() == 0) {
                    ++critical;
                } else if (event.getPriority() == 2) {
                    ++warning;
                } else if (event.getPriority() == 3) {
                    ++info;
                } else if (event.getPriority() == 1) {
                    ++unKnown;
                }
            }
            if (list.size() < this.m_eventMaxDisplayNumber) continue;
            break;
        }
        if (this.m_eventMaxDisplayNumber != -1 && ct.size() <= this.m_eventMaxDisplayNumber) {
            eventList.setCritical(critical);
            eventList.setWarning(warning);
            eventList.setInfo(info);
            eventList.setUnKnown(unKnown);
            eventList.setTotal(total);
        }
        eventList.setEventList(list);
    }

    private ArrayList<ReportEventInfo> collectionToArrayForReportd(Collection ct) {
        ArrayList<ReportEventInfo> list = new ArrayList<ReportEventInfo>();
        for (EventLogLocal event : ct) {
            ReportEventInfo info = new ReportEventInfo();
            info.setApplication(event.getApplication());
            info.setConfirmFlg(event.getConfirmFlg().intValue());
            info.setFacilityId(event.getFacilityId());
            info.setGenerationDate(new Date(event.getGenerationDate().getTime()));
            info.setMessage(event.getMessage());
            info.setMessageId(event.getMessageId());
            info.setMessageOrg(event.getMessageOrg());
            info.setMonitorId(event.getMonitorId());
            info.setOutputDate(new Date(event.getOutputDate().getTime()));
            info.setPluginId(event.getPluginId());
            info.setPriority(event.getPriority().intValue());
            info.setScopeText(event.getScopeText());
            list.add(info);
        }
        return list;
    }

    private void outputLog(Exception e, String method, String facilityId, Integer priority, Timestamp outputFromDate, Timestamp outputToDate, Timestamp generationFromDate, Timestamp generationToDate, String facilityType, String application, String message, Integer confirmFlg) {
        int priorityInt = -1;
        String outputFromDateString = null;
        String outputToDateString = null;
        String generationFromDateString = null;
        String generationToDateString = null;
        int confirmFlgInt = -1;
        if (priority != null) {
            priorityInt = priority;
        }
        if (outputFromDate != null) {
            outputFromDateString = outputFromDate.toString();
        }
        if (outputToDate != null) {
            outputToDateString = outputToDate.toString();
        }
        if (generationFromDate != null) {
            generationFromDateString = generationFromDate.toString();
        }
        if (generationToDate != null) {
            generationToDateString = generationToDate.toString();
        }
        if (confirmFlg != null) {
            confirmFlgInt = confirmFlg;
        }
        AplLogger apllog = new AplLogger("MON", "mon");
        Object[] args = new String[]{facilityId, PriorityConstant.typeToString((int)priorityInt), outputFromDateString, outputToDateString, generationFromDateString, generationToDateString, facilityType, application, message, ConfirmConstant.typeToString((int)confirmFlgInt)};
        apllog.put("SYS", "003", args);
        m_log.debug((Object)(method + ":" + e.getMessage()));
    }
}

