/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.ejb.session;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.monitor.bean.EventListInfo;
import com.clustercontrol.monitor.factory.DeleteStatus;
import com.clustercontrol.monitor.factory.EventBatchConfirmProperty;
import com.clustercontrol.monitor.factory.EventFilterProperty;
import com.clustercontrol.monitor.factory.EventInfoProperty;
import com.clustercontrol.monitor.factory.ManageStatus;
import com.clustercontrol.monitor.factory.ModifyEventConfirm;
import com.clustercontrol.monitor.factory.SelectEvent;
import com.clustercontrol.monitor.factory.SelectScope;
import com.clustercontrol.monitor.factory.SelectStatus;
import com.clustercontrol.monitor.factory.StatusFilterProperty;
import com.clustercontrol.monitor.util.QuartzUtil;
import com.clustercontrol.quartzmanager.ejb.session.QuartzManager;
import com.clustercontrol.util.Messages;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.jobs.ee.ejb.EJBInvokerJob;

public abstract class MonitorControllerBean
implements SessionBean {
    public static final int ALL = 0;
    public static final int ONE_LEVEL = 1;
    public static final int ONLY = -1;
    protected static Log m_log = LogFactory.getLog(MonitorControllerBean.class);

    public void addQuartz(String cronString) throws NamingException, ParseException, SchedulerException {
        QuartzManager manager = QuartzUtil.getQuartzManager();
        try {
            manager.deleteSchedule("MonitorController", "MON");
        }
        catch (SchedulerException e) {
            m_log.debug((Object)("addQuartz() : deleteJob error = " + e.getMessage()));
        }
        catch (RemoteException e) {
            // empty catch block
        }
        JobDetail job = new JobDetail("MonitorController", "MON", EJBInvokerJob.class);
        String serverName = System.getProperty("jboss.server.name");
        if (serverName.equals("all")) {
            job.getJobDataMap().put("java.naming.provider.url", "jnp://localhost:1100");
        }
        job.setDurability(true);
        job.getJobDataMap().put("ejb", "MonitorController");
        job.getJobDataMap().put("method", "manageStatus");
        CronTrigger cronTrigger = new CronTrigger("MonitorController", "MON");
        cronTrigger.setCronExpression(cronString);
        try {
            manager.addSchedule(job, (Trigger)cronTrigger);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public void deleteQuartz() throws NamingException, ParseException, SchedulerException {
        QuartzManager manager = QuartzUtil.getQuartzManager();
        try {
            manager.deleteSchedule("MonitorController", "MON");
        }
        catch (SchedulerException e) {
            m_log.debug((Object)("deleteQuartz() : deleteJob error = " + e.getMessage()));
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public Property getStatusFilterProperty(Locale local) {
        StatusFilterProperty status = new StatusFilterProperty();
        return status.getProperty(local);
    }

    public Property getEventFilterProperty(Locale local) {
        EventFilterProperty event = new EventFilterProperty();
        return event.getProperty(local);
    }

    public Property getEventBatchConfirmProperty(Locale local) {
        EventBatchConfirmProperty confirm = new EventBatchConfirmProperty();
        return confirm.getProperty(local);
    }

    public ArrayList getScopeList(String facilityId) throws CreateException, FinderException, NamingException {
        SelectScope select = new SelectScope();
        ArrayList list = select.getScopeList(facilityId);
        return list;
    }

    public ArrayList getStatusList(String facilityId) throws CreateException, FinderException, NamingException {
        SelectStatus select = new SelectStatus();
        ArrayList list = select.getStatusList(facilityId, 0);
        return list;
    }

    public boolean deleteStatus(List list) throws FinderException, RemoveException, NamingException {
        DeleteStatus status = new DeleteStatus();
        return status.delete(list);
    }

    public ArrayList getStatusList(String facilityId, Property property) throws CreateException, FinderException, NamingException {
        SelectStatus select = new SelectStatus();
        ArrayList list = select.getStatusList(facilityId, property);
        return list;
    }

    public void manageStatus() throws RemoveException, FinderException, NamingException {
        ManageStatus manage = new ManageStatus();
        manage.execute();
    }

    public EventListInfo getEventList(String facilityId) throws CreateException, FinderException, NamingException, SQLException {
        SelectEvent select = new SelectEvent();
        EventListInfo list = select.getEventList(facilityId, 0);
        return list;
    }

    public EventListInfo getEventList(String facilityId, Property property) throws CreateException, FinderException, NamingException, SQLException {
        SelectEvent select = new SelectEvent();
        EventListInfo list = select.getEventList(facilityId, property);
        return list;
    }

    public ArrayList getEventListForReport(String facilityId, Property property) throws CreateException, FinderException, NamingException, IndexOutOfBoundsException {
        SelectEvent select = new SelectEvent();
        ArrayList list = select.getEventListForReport(facilityId, property);
        return list;
    }

    public Property getEventInfoProperty(String monitorId, String pluginId, String facilityId, Date outputDate, Locale local) throws FinderException, NamingException {
        EventInfoProperty event = new EventInfoProperty();
        return event.getProperty(monitorId, pluginId, facilityId, outputDate, local);
    }

    public void modifyConfirm(String monitorId, String pluginId, String facilityId, Date outputDate, Date confirmDate, int confirmType) throws CreateException, FinderException, NamingException {
        ModifyEventConfirm modify = new ModifyEventConfirm();
        modify.modifyConfirm(monitorId, pluginId, facilityId, outputDate, confirmDate, confirmType);
    }

    public void modifyConfirm(List list, int confirmType) throws CreateException, FinderException, NamingException {
        ModifyEventConfirm modify = new ModifyEventConfirm();
        modify.modifyConfirm(list, confirmType);
    }

    public void modifyBatchConfirm(int confirmType, String facilityId, Property property) throws CreateException, NamingException, FinderException, SQLException {
        ModifyEventConfirm modify = new ModifyEventConfirm();
        modify.modifyBatchConfirm(confirmType, facilityId, property);
    }

    public ArrayList getScopeListTableDefine(Locale local) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(0, new TableColumnInfo(Messages.getString((String)"priority", (Locale)local), 3, 70, 16384));
        tableDefine.add(1, new TableColumnInfo(Messages.getString((String)"facility.id", (Locale)local), -1, 100, 16384));
        tableDefine.add(2, new TableColumnInfo(Messages.getString((String)"scope", (Locale)local), 2, 150, 16384));
        tableDefine.add(3, new TableColumnInfo(Messages.getString((String)"update.time", (Locale)local), -1, 150, 16384));
        return tableDefine;
    }

    public ArrayList getStatusListTableDefine(Locale local) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(0, new TableColumnInfo(Messages.getString((String)"priority", (Locale)local), 3, 70, 16384));
        tableDefine.add(1, new TableColumnInfo(Messages.getString((String)"plugin.id", (Locale)local), -1, 100, 16384));
        tableDefine.add(2, new TableColumnInfo(Messages.getString((String)"monitor.id", (Locale)local), -1, 100, 16384));
        tableDefine.add(3, new TableColumnInfo(Messages.getString((String)"facility.id", (Locale)local), -1, 100, 16384));
        tableDefine.add(4, new TableColumnInfo(Messages.getString((String)"scope", (Locale)local), 2, 150, 16384));
        tableDefine.add(5, new TableColumnInfo(Messages.getString((String)"application", (Locale)local), -1, 100, 16384));
        tableDefine.add(6, new TableColumnInfo(Messages.getString((String)"update.time", (Locale)local), -1, 150, 16384));
        tableDefine.add(7, new TableColumnInfo(Messages.getString((String)"output.time", (Locale)local), -1, 150, 16384));
        tableDefine.add(8, new TableColumnInfo(Messages.getString((String)"message.id", (Locale)local), -1, 200, 16384));
        tableDefine.add(9, new TableColumnInfo(Messages.getString((String)"message", (Locale)local), -1, 200, 16384));
        return tableDefine;
    }

    public ArrayList getEventListTableDefine(Locale local) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(0, new TableColumnInfo(Messages.getString((String)"priority", (Locale)local), 3, 70, 16384));
        tableDefine.add(1, new TableColumnInfo(Messages.getString((String)"receive.time", (Locale)local), -1, 150, 16384));
        tableDefine.add(2, new TableColumnInfo(Messages.getString((String)"output.time", (Locale)local), -1, 150, 16384));
        tableDefine.add(3, new TableColumnInfo(Messages.getString((String)"plugin.id", (Locale)local), -1, 100, 16384));
        tableDefine.add(4, new TableColumnInfo(Messages.getString((String)"monitor.id", (Locale)local), -1, 100, 16384));
        tableDefine.add(5, new TableColumnInfo(Messages.getString((String)"facility.id", (Locale)local), -1, 100, 16384));
        tableDefine.add(6, new TableColumnInfo(Messages.getString((String)"scope", (Locale)local), 2, 150, 16384));
        tableDefine.add(7, new TableColumnInfo(Messages.getString((String)"application", (Locale)local), -1, 100, 16384));
        tableDefine.add(8, new TableColumnInfo(Messages.getString((String)"message.id", (Locale)local), -1, 200, 16384));
        tableDefine.add(9, new TableColumnInfo(Messages.getString((String)"message", (Locale)local), -1, 200, 16384));
        tableDefine.add(10, new TableColumnInfo(Messages.getString((String)"confirmed", (Locale)local), 8, 50, 16384));
        return tableDefine;
    }
}

