/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.snmp.factory;

import com.clustercontrol.monitor.run.factory.RunMonitorNumericValueType;
import com.clustercontrol.snmp.ejb.entity.MonitorSnmpInfoLocal;
import com.clustercontrol.snmp.ejb.entity.MonitorSnmpInfoPK;
import com.clustercontrol.snmp.ejb.entity.MonitorSnmpInfoUtil;
import com.clustercontrol.snmp.ejb.entity.MonitorSnmpValueLocal;
import com.clustercontrol.snmp.ejb.entity.MonitorSnmpValuePK;
import com.clustercontrol.snmp.ejb.entity.MonitorSnmpValueUtil;
import com.clustercontrol.snmp.util.RequestSnmp;
import com.clustercontrol.snmp.util.SnmpProperties;
import com.clustercontrol.util.Messages;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.jms.JMSException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RunMonitorSnmp
extends RunMonitorNumericValueType {
    protected static Log m_log = LogFactory.getLog(RunMonitorSnmp.class);
    public static final String MESSAGE_ID_INFO = "001";
    public static final String MESSAGE_ID_WARNING = "002";
    public static final String MESSAGE_ID_CRITICAL = "003";
    public static final String MESSAGE_ID_UNKNOWN = "004";
    protected static final ArrayList<String> m_attributeList = new ArrayList();
    protected MonitorSnmpInfoLocal m_snmp = null;
    protected RequestSnmp m_request = null;
    protected String m_communityName = null;
    protected String m_snmpOid = null;
    protected int m_convertFlg = 0;
    protected String m_messageOrg = null;
    protected String m_messageId = "";
    protected String m_message = "";

    public boolean collect(String facilityId) {
        this.m_nodeDate = this.m_now.getTime();
        this.m_value = 0.0f;
        this.m_message = "";
        this.m_messageOrg = Messages.getString((String)"oid") + " : " + this.m_snmpOid;
        try {
            String ipNetworkNumber = null;
            try {
                HashMap facilityAttrMap = this.m_repository.getNodeDetail(facilityId, m_attributeList);
                ipNetworkNumber = (String)facilityAttrMap.get("ipNetworkNumber");
            }
            catch (FinderException e) {
                m_log.debug((Object)("run():" + e.getMessage()));
                this.m_message = Messages.getString((String)"message.snmp.6");
                this.m_messageOrg = this.m_messageOrg + " (" + e.getMessage() + ")";
                return false;
            }
            catch (NamingException e) {
                m_log.debug((Object)("run():" + e.getMessage()));
                this.m_message = Messages.getString((String)"message.snmp.6");
                this.m_messageOrg = this.m_messageOrg + " (" + e.getMessage() + ")";
                return false;
            }
            RequestSnmp m_request = new RequestSnmp();
            boolean result = m_request.polling(InetAddress.getByName(ipNetworkNumber), this.m_communityName, this.m_snmpOid);
            if (result) {
                float value = -1.0f;
                try {
                    value = Float.parseFloat(m_request.getValue());
                }
                catch (NumberFormatException e) {
                    Object[] args = new String[]{m_request.getValue()};
                    this.m_message = Messages.getString((String)"message.snmp.8", (Object[])args);
                    return false;
                }
                long date = m_request.getDate();
                if (this.m_convertFlg == 0) {
                    this.m_value = value;
                    this.m_nodeDate = date;
                } else if (this.m_convertFlg == 1) {
                    MonitorSnmpValueLocal valueLocal = null;
                    float prevValue = 0.0f;
                    long prevDate = 0L;
                    try {
                        MonitorSnmpValuePK pk = new MonitorSnmpValuePK(facilityId, this.m_monitorId);
                        valueLocal = MonitorSnmpValueUtil.getLocalHome().findByPrimaryKey(pk);
                        prevValue = valueLocal.getValue().floatValue();
                        prevDate = valueLocal.getGetDate().getTime();
                        valueLocal.setValue(Float.valueOf(value));
                        valueLocal.setGetDate(new Timestamp(date));
                    }
                    catch (FinderException e) {
                        try {
                            valueLocal = MonitorSnmpValueUtil.getLocalHome().create(this.m_monitorId, facilityId, Float.valueOf(value), new Timestamp(date));
                            prevValue = value;
                            prevDate = date;
                        }
                        catch (CreateException ce) {
                            m_log.debug((Object)("run():" + e.getMessage()));
                            this.m_message = Messages.getString((String)"message.snmp.7");
                            this.m_messageOrg = this.m_messageOrg + " (" + e.getMessage() + ")";
                            return false;
                        }
                    }
                    int tolerance = (this.m_monitor.getRunInterval() + SnmpProperties.getProperties().getValidSecond()) * 1000;
                    if (prevDate > date - (long)tolerance) {
                        this.m_value = value - prevValue;
                        this.m_nodeDate = m_request.getDate();
                    } else {
                        Object[] args = new String[]{DateFormat.getDateTimeInstance().format(new Date(prevDate))};
                        this.m_message = Messages.getString((String)"message.snmp.9", (Object[])args);
                        return false;
                    }
                }
                this.m_message = Messages.getString((String)"select.value") + " : " + this.m_value;
            } else {
                this.m_message = m_request.getMessage();
            }
            return result;
        }
        catch (UnknownHostException e) {
            m_log.debug((Object)("run():" + e.getMessage()));
            this.m_message = Messages.getString((String)"message.snmp.5");
            this.m_messageOrg = this.m_messageOrg + " (" + e.getMessage() + ")";
            return false;
        }
        catch (NamingException e) {
            m_log.debug((Object)("run():" + e.getMessage()));
            this.m_message = Messages.getString((String)"message.snmp.7");
            this.m_messageOrg = this.m_messageOrg + " (" + e.getMessage() + ")";
            return false;
        }
    }

    public void setCheckInfo() throws FinderException, NamingException {
        MonitorSnmpInfoPK pk = new MonitorSnmpInfoPK(this.m_monitorId, this.m_monitorTypeId);
        this.m_snmp = MonitorSnmpInfoUtil.getLocalHome().findByPrimaryKey(pk);
        this.m_communityName = this.m_snmp.getCommunityName().trim();
        this.m_snmpOid = this.m_snmp.getSnmpOid().trim();
        this.m_convertFlg = this.m_snmp.getConvertFlg();
    }

    public String getMessageId(int id) {
        if (id == 3) {
            return MESSAGE_ID_INFO;
        }
        if (id == 2) {
            return MESSAGE_ID_WARNING;
        }
        if (id == 0) {
            return MESSAGE_ID_CRITICAL;
        }
        return MESSAGE_ID_UNKNOWN;
    }

    public String getMessage(int id) {
        return this.m_message;
    }

    public String getMessageOrg(int id) {
        return this.m_messageOrg;
    }

    public String getMessageIdForScope(int priority) {
        if (priority == 3) {
            return MESSAGE_ID_INFO;
        }
        if (priority == 2) {
            return MESSAGE_ID_WARNING;
        }
        if (priority == 0) {
            return MESSAGE_ID_CRITICAL;
        }
        return MESSAGE_ID_UNKNOWN;
    }

    static {
        m_attributeList.add("ipNetworkNumber");
        m_attributeList.add("ccIpNetworkNumberV6");
    }
}

