/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.http.factory;

import com.clustercontrol.http.ejb.entity.MonitorHttpInfoLocal;
import com.clustercontrol.http.ejb.entity.MonitorHttpInfoPK;
import com.clustercontrol.http.ejb.entity.MonitorHttpInfoUtil;
import com.clustercontrol.http.util.GetHttpResponse;
import com.clustercontrol.monitor.run.factory.RunMonitorNumericValueType;
import com.clustercontrol.util.Messages;
import java.text.NumberFormat;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.jms.JMSException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RunMonitorHttp
extends RunMonitorNumericValueType {
    protected static Log m_log = LogFactory.getLog(RunMonitorHttp.class);
    public static final String MESSAGE_ID_INFO = "001";
    public static final String MESSAGE_ID_WARNING = "002";
    public static final String MESSAGE_ID_CRITICAL = "003";
    public static final String MESSAGE_ID_UNKNOWN = "004";
    protected MonitorHttpInfoLocal m_http = null;
    protected String m_requestUrl = null;
    protected int m_httpTimeout;
    protected int m_urlReplace = 0;
    protected int m_proxySet = 0;
    protected String m_proxyHost;
    protected int m_proxyPort;
    protected String m_message = "";
    protected String m_messageOrg = null;

    public boolean runMonitorInfo() throws FinderException, RemoveException, JMSException, NamingException, CreateException {
        this.setCheckInfo();
        if (this.m_urlReplace == 1) {
            return super.runMonitorInfo();
        }
        this.m_now = new Date();
        try {
            boolean run = this.setMonitorInfo(this.m_monitorTypeId, this.m_monitorId);
            if (!run) {
                return true;
            }
            this.setJudgementInfo();
            boolean ret = this.collect(null);
            int checkResult = this.getCheckResult(ret);
            this.notify(true, this.m_facilityId, checkResult, new Date(this.m_nodeDate));
            return true;
        }
        catch (FinderException e) {
            m_log.error((Object)("runMonitorInfo(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()));
            throw e;
        }
        catch (CreateException e) {
            m_log.error((Object)("runMonitorInfo(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()));
            throw e;
        }
        catch (JMSException e) {
            m_log.error((Object)("runMonitorInfo(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            m_log.error((Object)("runMonitorInfo(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()));
            throw e;
        }
    }

    public boolean collect(String facilityId) {
        this.m_nodeDate = this.m_now.getTime();
        this.m_value = 0.0f;
        this.m_message = "";
        this.m_messageOrg = "";
        GetHttpResponse m_request = new GetHttpResponse();
        String url = this.m_requestUrl;
        boolean result = m_request.execute(url, this.m_httpTimeout * 1000);
        if (result) {
            this.m_value = m_request.getResponseTime() / 1000L;
            this.m_message = Messages.getString((String)"response.time.sec") + " : " + NumberFormat.getNumberInstance().format(this.m_value);
            StringBuffer response = new StringBuffer();
            response.append(Messages.getString((String)"status.code") + " : " + m_request.getStatusCode());
            if (m_request.getHeader() != null && !"".equals(m_request.getHeader().trim())) {
                response.append("\n" + Messages.getString((String)"header") + " :\n" + m_request.getHeader().trim());
            }
            if (m_request.getFooter() != null && !"".equals(m_request.getFooter().trim())) {
                response.append("\n" + Messages.getString((String)"footer") + " :\n" + m_request.getFooter().trim());
            }
            if (m_request.getResponseBody() != null && !"".equals(m_request.getResponseBody().trim())) {
                response.append("\n" + Messages.getString((String)"response.body") + " :\n" + m_request.getResponseBody().trim());
            }
            this.m_messageOrg = response.toString();
        } else {
            this.m_message = Messages.getString((String)"message.http.3");
            StringBuffer response = new StringBuffer();
            response.append(m_request.getErrorMessage());
            response.append("\n" + Messages.getString((String)"status.code") + " : " + m_request.getStatusCode());
            if (m_request.getHeader() != null && !"".equals(m_request.getHeader().trim())) {
                response.append("\n" + Messages.getString((String)"header") + " :\n" + m_request.getHeader().trim());
            }
            if (m_request.getFooter() != null && !"".equals(m_request.getFooter().trim())) {
                response.append("\n" + Messages.getString((String)"footer") + " :\n" + m_request.getFooter().trim());
            }
            this.m_messageOrg = response.toString();
        }
        return result;
    }

    public void setCheckInfo() throws FinderException, NamingException {
        if (this.m_http == null) {
            MonitorHttpInfoPK pk = new MonitorHttpInfoPK(this.m_monitorId, this.m_monitorTypeId);
            this.m_http = MonitorHttpInfoUtil.getLocalHome().findByPrimaryKey(pk);
            this.m_requestUrl = this.m_http.getRequestUrl().trim();
            this.m_httpTimeout = this.m_http.getTimeout();
            this.m_urlReplace = this.m_http.getUrlReplace();
            this.m_proxySet = this.m_http.getProxySet();
            if (this.m_http.getProxyHost() != null) {
                this.m_proxyHost = this.m_http.getProxyHost().trim();
            }
            this.m_proxyPort = this.m_http.getProxyPort();
        }
    }

    public String getMessageId(int id) {
        if (id == 3) {
            return MESSAGE_ID_INFO;
        }
        if (id == 2) {
            return MESSAGE_ID_WARNING;
        }
        if (id == 0) {
            return MESSAGE_ID_CRITICAL;
        }
        return MESSAGE_ID_UNKNOWN;
    }

    public String getMessage(int id) {
        return this.m_message;
    }

    public String getMessageOrg(int id) {
        return this.m_messageOrg;
    }
}

