/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.view;

import com.clustercontrol.bean.Property;
import com.clustercontrol.jobmanagement.composite.HistoryComposite;
import com.clustercontrol.jobmanagement.ui.JobManagementUIPlugin;
import com.clustercontrol.view.AutoUpdateView;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class JobHistoryView
extends AutoUpdateView {
    public static final String ID = "com.clustercontrol.jobmanagement.view.JobHistoryView";
    private HistoryComposite m_history = null;
    private Property m_condition = null;

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.m_history = new HistoryComposite(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.m_history.setLayoutData(gridData);
        this.createContextMenu();
        this.update();
        IPreferenceStore store = JobManagementUIPlugin.getDefault().getPreferenceStore();
        this.setInterval(store.getInt("historyUpdateCycle"));
        if (store.getBoolean("historyUpdateFlg")) {
            this.startAutoReload();
        }
    }

    protected void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                JobHistoryView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this.m_history.getTable());
        this.m_history.getTable().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        IToolBarManager toolbar = this.getViewSite().getActionBars().getToolBarManager();
        ActionContributionItem startJobAction = (ActionContributionItem)toolbar.find("com.clustercontrol.jobmanagement.view.action.StartJobAction");
        ActionContributionItem stopJobAction = (ActionContributionItem)toolbar.find("com.clustercontrol.jobmanagement.view.action.StopJobAction");
        manager.add(startJobAction.getAction());
        manager.add(stopJobAction.getAction());
    }

    public Property getFilterCondition() {
        return this.m_condition;
    }

    public void setFilterCondition(Property condition) {
        this.m_condition = condition;
    }

    public void update() {
        if (this.m_condition == null) {
            this.m_history.update();
        } else {
            this.m_history.update(this.m_condition);
        }
    }

    public HistoryComposite getComposite() {
        return this.m_history;
    }
}

