/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.collectiverun.composite;

import com.clustercontrol.bean.Property;
import com.clustercontrol.collectiverun.action.GetHistoryInfo;
import com.clustercontrol.collectiverun.action.GetHistoryTabelDefine;
import com.clustercontrol.collectiverun.bean.HistoryTableDefine;
import com.clustercontrol.collectiverun.composite.action.HistorySelectionChangedListener;
import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.util.Messages;
import java.rmi.AccessException;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class HistoryComposite
extends Composite {
    private CommonTableViewer m_viewer = null;
    protected String m_sessionId = null;
    private boolean openAccessInformation = false;

    public HistoryComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Table table = new Table((Composite)this, 66308);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData((Object)gridData);
        this.m_viewer = new CommonTableViewer(table);
        this.m_viewer.createTableColumn(GetHistoryTabelDefine.get(), HistoryTableDefine.SORT_COLUMN_INDEX, HistoryTableDefine.SORT_ORDER);
        this.update();
        this.m_viewer.addSelectionChangedListener((ISelectionChangedListener)new HistorySelectionChangedListener(this));
    }

    public void update() {
        ArrayList historyInfo = null;
        GetHistoryInfo history = new GetHistoryInfo();
        try {
            historyInfo = history.getHistory();
        }
        catch (AccessException accessException) {
            if (!this.openAccessInformation) {
                this.openAccessInformation = true;
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            historyInfo = new ArrayList();
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.job.33"));
        }
        if (historyInfo == null) {
            historyInfo = new ArrayList();
        }
        this.m_viewer.setInput(historyInfo);
        this.selectHistory(historyInfo);
    }

    public void update(Property condition) {
        ArrayList historyInfo = null;
        GetHistoryInfo history = new GetHistoryInfo();
        try {
            historyInfo = history.getHistory(condition);
        }
        catch (AccessException accessException) {
            if (!this.openAccessInformation) {
                this.openAccessInformation = true;
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            historyInfo = new ArrayList();
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.job.33"));
        }
        this.m_viewer.setInput(historyInfo);
        this.selectHistory(historyInfo);
    }

    public void selectHistory(ArrayList historyInfo) {
        if (this.m_sessionId != null && this.m_sessionId.length() > 0) {
            int index = -1;
            int i = 0;
            while (i < historyInfo.size()) {
                ArrayList line = (ArrayList)historyInfo.get(i);
                String sessionId = (String)line.get(HistoryTableDefine.SESSION_ID);
                if (this.m_sessionId.compareTo(sessionId) == 0) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index == -1) {
                this.m_sessionId = null;
            } else {
                this.m_viewer.setSelection((ISelection)new StructuredSelection(historyInfo.get(index)), true);
            }
        }
    }

    public CommonTableViewer getTableViewer() {
        return this.m_viewer;
    }

    public String getSessionId() {
        return this.m_sessionId;
    }

    public void setSessionId(String sessionId) {
        this.m_sessionId = sessionId;
    }
}

