/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.accesscontrol.ejb.session;

import com.clustercontrol.accesscontrol.factory.ModifyUser;
import com.clustercontrol.accesscontrol.factory.SelectUser;
import com.clustercontrol.accesscontrol.factory.UserFilterProperty;
import com.clustercontrol.accesscontrol.factory.UserProperty;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.util.Messages;
import java.rmi.RemoteException;
import java.security.Principal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AccessControllerBean
implements SessionBean {
    protected static Log m_log = LogFactory.getLog(AccessControllerBean.class);
    private SessionContext m_context;
    public static final int ALL = 0;
    public static final int ONE_LEVEL = 1;

    public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
        this.m_context = ctx;
    }

    public ArrayList getUserListTableDefine(Locale local) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(0, new TableColumnInfo(Messages.getString((String)"user.id", (Locale)local), -1, 100, 16384));
        tableDefine.add(1, new TableColumnInfo(Messages.getString((String)"name", (Locale)local), -1, 100, 16384));
        tableDefine.add(2, new TableColumnInfo(Messages.getString((String)"description", (Locale)local), -1, 150, 16384));
        tableDefine.add(3, new TableColumnInfo(Messages.getString((String)"creator.name", (Locale)local), -1, 100, 16384));
        tableDefine.add(4, new TableColumnInfo(Messages.getString((String)"create.time", (Locale)local), -1, 100, 16384));
        tableDefine.add(5, new TableColumnInfo(Messages.getString((String)"modifier.name", (Locale)local), -1, 100, 16384));
        tableDefine.add(6, new TableColumnInfo(Messages.getString((String)"update.time", (Locale)local), -1, 100, 16384));
        return tableDefine;
    }

    public ArrayList getUserList() throws FinderException, NamingException {
        SelectUser select = new SelectUser();
        ArrayList list = select.getUserList();
        return list;
    }

    public ArrayList getUserList(Property property) throws FinderException, NamingException {
        SelectUser select = new SelectUser();
        ArrayList list = select.getUserList(property);
        return list;
    }

    public Property getUserFilterProperty(Locale local) {
        UserFilterProperty user = new UserFilterProperty();
        return user.getProperty(local);
    }

    public Property getUserProperty(String uid, int mode, Locale local) throws FinderException, NamingException {
        UserProperty user = new UserProperty();
        return user.getProperty(uid, mode, local);
    }

    public void addUser(Property property) throws NamingException, CreateException, FinderException, ParseException {
        Principal pri = this.m_context.getCallerPrincipal();
        ModifyUser modify = new ModifyUser();
        modify.addUser(property, pri.getName());
    }

    public void modifyUser(Property property) throws NamingException, FinderException {
        Principal pri = this.m_context.getCallerPrincipal();
        ModifyUser modify = new ModifyUser();
        modify.modifyUser(property, pri.getName());
    }

    public void deleteUser(String uid) throws NamingException, RemoveException, FinderException {
        ModifyUser modify = new ModifyUser();
        modify.deleteUser(uid);
    }

    public void changePassword(String uid, String password) throws NamingException, RemoveException, FinderException {
        ModifyUser modify = new ModifyUser();
        modify.modifyPassword(uid, password);
    }

    public boolean isPermission(String roleName) throws NamingException {
        return this.m_context.isCallerInRole(roleName);
    }

    public String getUserName() throws NamingException, FinderException {
        Principal pri = this.m_context.getCallerPrincipal();
        SelectUser select = new SelectUser();
        return select.getUserName(pri.getName());
    }
}

