/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.agent;

import com.clustercontrol.agent.AgentThread;
import com.clustercontrol.agent.SendQueue;
import com.clustercontrol.agent.util.RunHistoryUtil;
import com.clustercontrol.jobmanagement.message.RunInstructionInfo;
import com.clustercontrol.jobmanagement.message.RunResultInfo;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublicKeyThread
extends AgentThread {
    private static final String PUBLIC_KEY = ".public.key";
    private static final String AUTHORIZED_KEY_PATH = ".authorized.keys.path";
    private static Log log = LogFactory.getLog(PublicKeyThread.class);

    public PublicKeyThread(RunInstructionInfo info, SendQueue sendQueue, Hashtable<String, Date> runHistory, Properties props) {
        super(info, sendQueue, runHistory, props);
    }

    @Override
    public void run() {
        log.debug((Object)"run start");
        Date startDate = new Date();
        RunHistoryUtil.addRunHistory(this.m_info, this.m_runHistory, startDate);
        RunResultInfo info = new RunResultInfo();
        info.setSessionId(this.m_info.getSessionId());
        info.setJobId(this.m_info.getJobId());
        info.setFacilityId(this.m_info.getFacilityId());
        info.setCommand(this.m_info.getCommand());
        info.setCommandType(this.m_info.getCommandType());
        info.setUser(this.m_info.getUser());
        info.setStatus(0);
        info.setTime(startDate);
        log.info((Object)("run SessionID=" + this.m_info.getSessionId() + ", JobID=" + this.m_info.getJobId()));
        this.m_sendQueue.put(info);
        if (this.m_info.getCommand().equals("getPublicKey")) {
            String key = this.m_props.getProperty(this.m_info.getUser().toLowerCase() + PUBLIC_KEY);
            if (key != null && key.length() > 0) {
                info.setStatus(1);
                info.setPublicKey(key);
                info.setTime(new Date());
                info.setErrorMessage("");
                info.setMessage("");
                info.setEndValue(0);
            } else {
                info.setStatus(2);
                info.setPublicKey("");
                info.setTime(new Date());
                info.setErrorMessage("");
                info.setMessage("");
                info.setEndValue(-1);
            }
        } else if (this.m_info.getCommand().equals("addPublicKey")) {
            if (this.addKey(this.m_info.getPublicKey())) {
                info.setStatus(1);
                info.setTime(new Date());
                info.setErrorMessage("");
                info.setMessage("");
                info.setEndValue(0);
            } else {
                info.setStatus(2);
                info.setTime(new Date());
                info.setErrorMessage("");
                info.setMessage("");
                info.setEndValue(-1);
            }
        } else if (this.m_info.getCommand().equals("deletePublicKey")) {
            if (this.deleteKey(this.m_info.getPublicKey())) {
                info.setStatus(1);
                info.setTime(new Date());
                info.setErrorMessage("");
                info.setMessage("");
                info.setEndValue(0);
            } else {
                info.setStatus(2);
                info.setTime(new Date());
                info.setErrorMessage("");
                info.setMessage("");
                info.setEndValue(-1);
            }
        }
        this.m_sendQueue.put(info);
        this.sendDeleteHistory(info);
        log.debug((Object)"run end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean addKey(String publicKey) {
        log.debug((Object)"add key start");
        String fileName = this.m_props.getProperty(this.m_info.getUser().toLowerCase() + AUTHORIZED_KEY_PATH);
        if (fileName == null || fileName.length() == 0) {
            return false;
        }
        File fi = new File(fileName);
        RandomAccessFile randomAccessFile = null;
        AbstractInterruptibleChannel channel = null;
        FileLock lock = null;
        boolean add = false;
        try {
            randomAccessFile = new RandomAccessFile(fi, "rw");
            channel = randomAccessFile.getChannel();
            lock = ((FileChannel)channel).lock();
            ((FileChannel)channel).position(((FileChannel)channel).size());
            String writeData = "\n" + publicKey;
            ByteBuffer buffer = ByteBuffer.allocate(512);
            buffer.clear();
            buffer.put(writeData.getBytes());
            buffer.flip();
            ((FileChannel)channel).write(buffer);
            add = true;
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        finally {
            try {
                if (channel != null) {
                    channel.close();
                }
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
                if (lock != null) {
                    lock.release();
                }
            }
            catch (Exception e) {}
        }
        return add;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean deleteKey(String publicKey) {
        log.debug((Object)"delete key start");
        Charset charset = Charset.forName("UTF-8");
        CharsetEncoder encoder = charset.newEncoder();
        CharsetDecoder decoder = charset.newDecoder();
        String fileName = this.m_props.getProperty(this.m_info.getUser().toLowerCase() + AUTHORIZED_KEY_PATH);
        if (fileName == null || fileName.length() == 0) {
            return false;
        }
        File fi = new File(fileName);
        RandomAccessFile randomAccessFile = null;
        AbstractInterruptibleChannel channel = null;
        FileLock lock = null;
        boolean delete = false;
        try {
            randomAccessFile = new RandomAccessFile(fi, "rw");
            channel = randomAccessFile.getChannel();
            lock = ((FileChannel)channel).lock();
            ByteBuffer buffer = ByteBuffer.allocate(512);
            ((FileChannel)channel).read(buffer);
            buffer.flip();
            String contents = decoder.decode(buffer).toString();
            ArrayList<String> keyCheck = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer(contents, "\n");
            while (tokenizer.hasMoreTokens()) {
                keyCheck.add(tokenizer.nextToken());
            }
            int s = keyCheck.indexOf(publicKey);
            while (s != -1) {
                keyCheck.remove(s);
                s = keyCheck.indexOf(publicKey);
            }
            encoder.reset();
            buffer.clear();
            if (keyCheck.size() > 0) {
                int i;
                for (i = 0; i < keyCheck.size() - 1; ++i) {
                    encoder.encode(CharBuffer.wrap((String)keyCheck.get(i) + "\n"), buffer, false);
                }
                encoder.encode(CharBuffer.wrap((String)keyCheck.get(i)), buffer, true);
            }
            buffer.flip();
            ((FileChannel)channel).truncate(0L);
            ((FileChannel)channel).write(buffer);
            delete = true;
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        finally {
            try {
                if (channel != null) {
                    channel.close();
                }
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
                if (lock != null) {
                    lock.release();
                }
            }
            catch (Exception e) {}
        }
        return delete;
    }
}

