#!/bin/bash

#Copyright (C) 2006 - 2009 NTT DATA Corporation
#
#This program is free software; you can redistribute it and/or
#Modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation, version 2.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details

# check for incorrect user

EXEC_USER=`/usr/bin/whoami`
if [ ${EXEC_USER} != "hinemos" ]; then
	echo "";
	echo "ERROR  Hinemos Maneger boot at incorrect user "; 
	echo "";
	exit 1;
fi

. /opt/hinemos/hinemos.cfg

# check on option
for OPTION in "$@"
do
	case $OPTION in
		-c)
			OPT=-c
			;;
		*)
			echo "usage"
			echo "hinemos_start.sh    : Hinemos is started as usual. "
			echo "hinemos_start.sh -c : After the JMS message is annulled, JBoss is started. "
			exit 1
			;;
	esac
done

echo "Hinemos starting"
echo ""

# Start up PostgreSQL

${HINEMOS_HOME}/bin/pg_start.sh

REVAL=$?
if [ "$REVAL" -ne 0 -a "$REVAL" -ne 24 ]; then
        exit 1
fi
echo ""


#Start up OpenLDAP

${HINEMOS_HOME}/bin/ldap_start.sh

REVAL=$?
if [ "$REVAL" -ne 0 -a "$REVAL" -ne 24 ]; then
        exit 1
fi
echo ""


#Start up JBoss

#echo -n "waiting for jboss to start";

${HINEMOS_HOME}/bin/jboss_start.sh $OPT

REVAL=$?
if [ "$REVAL" -ne 0 -a "$REVAL" -ne 24 ] ; then
	echo "Hinemos didn't start"
    exit 1
fi

echo "Hinemos started"

