/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.accesscontrol.util;

import com.clustercontrol.accesscontrol.util.TimeKeeper;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimeKeeperService {
    private static Log m_log = LogFactory.getLog(TimeKeeperService.class);
    private static String LDAP_CONNECT_MAXSIZE_PROPERTY = "com.sun.jndi.ldap.connect.pool.maxsize";
    private static String LDAP_TIMEOUT = "common.ldap.timeout";
    private static String LDAP_TIMEKEEPER_THREAD_COUNT = "common.ldap.timekeeper.thread.count";
    private static ExecutorService exes;
    private static long timeout;

    public static TimeKeeper start() {
        TimeKeeper keeper = new TimeKeeper(timeout);
        exes.execute(keeper);
        return keeper;
    }

    public static void stop(TimeKeeper timeKeeper) {
        timeKeeper.stop();
        Thread.interrupted();
    }

    static {
        timeout = 15000L;
        Properties properties = new Properties();
        try {
            String homedir = System.getProperty("jboss.server.home.dir");
            String propertyFile = homedir + File.separator + "conf" + File.separator + "ldap-timeout.properties";
            properties.load(new FileInputStream(propertyFile));
        }
        catch (Exception e) {
            m_log.debug((Object)e.getMessage());
        }
        try {
            timeout = Integer.parseInt(properties.getProperty(LDAP_TIMEOUT));
        }
        catch (Exception e) {
            // empty catch block
        }
        int threadSize = 10;
        try {
            threadSize = Integer.parseInt(properties.getProperty(LDAP_TIMEKEEPER_THREAD_COUNT));
        }
        catch (Exception e) {
            String conMaxSizeString = System.getProperty(LDAP_CONNECT_MAXSIZE_PROPERTY);
            try {
                threadSize = Integer.parseInt(conMaxSizeString);
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        m_log.info((Object)("LDAP TimeKeeperThread ThreadPoolSize : " + threadSize));
        TimeKeeperThreadFactory threadFactory = new TimeKeeperThreadFactory();
        exes = Executors.newFixedThreadPool(threadSize, threadFactory);
    }

    private static class TimeKeeperThreadFactory
    implements ThreadFactory {
        private TimeKeeperThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            return new Thread(r, Thread.currentThread().getName() + "-TimeKeeper");
        }
    }
}

