/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.dao;

import com.clustercontrol.accesscontrol.util.LdapConnectionManager;
import com.clustercontrol.accesscontrol.util.TimeKeeper;
import com.clustercontrol.accesscontrol.util.TimeKeeperService;
import com.clustercontrol.repository.dao.FileSystemInfoDAO;
import com.clustercontrol.repository.ejb.entity.FileSystemInfoBean;
import com.clustercontrol.repository.ejb.entity.FileSystemInfoPK;
import com.clustercontrol.util.apllog.AplLogger;
import java.util.ArrayList;
import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileSystemInfoDAOImpl
implements FileSystemInfoDAO {
    protected static Log m_log = LogFactory.getLog(FileSystemInfoDAOImpl.class);
    protected static final String OBJECTCLASS = "objectClass";
    protected static final String BASE_DN = "ou=facility";
    protected static final String OBJECT_CLASS_FILE_SYSTEM_INFO = "ccFileSystemInfo";
    private static int MAX_RETRY = 3;

    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void load(FileSystemInfoPK pk, FileSystemInfoBean ejb) throws EJBException {
        DirContext ctx = null;
        int retryCount = 0;
        while (MAX_RETRY > retryCount) {
            TimeKeeper timer;
            block23: {
                timer = null;
                this.clearBean(ejb);
                ctx = LdapConnectionManager.getConnectionManager().getDirContext();
                timer = TimeKeeperService.start();
                Attributes attrs = ctx.getAttributes(pk.getDn());
                ejb.setDn(pk.getDn());
                ejb.setCn(new Integer((String)attrs.get("cn").get(0)));
                if (attrs.get("ccSnmpOID") != null) {
                    ejb.setSnmpOID((String)attrs.get("ccSnmpOID").get(0));
                }
                if (attrs.get("ccFileSystemMountPoint") != null) {
                    ejb.setFileSystemMountPoint((String)attrs.get("ccFileSystemMountPoint").get(0));
                }
                if (attrs.get("ccFileSystemType") != null) {
                    ejb.setFileSystemType((String)attrs.get("ccFileSystemType").get(0));
                }
                if (attrs.get("description") != null) {
                    ejb.setDescription((String)attrs.get("description").get(0));
                }
                if (attrs.get("ccDisplayName") != null) {
                    ejb.setDisplayName((String)attrs.get("ccDisplayName").get(0));
                }
                String dn = ejb.getDn();
                dn = dn.replaceFirst("[^,]*,", "");
                dn = dn.replaceFirst(",[\\s\\w=]*", "");
                dn = dn.replaceFirst("ccFacilityId=", "");
                ejb.setFacilityId(dn);
                Object var9_9 = null;
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                    break block23;
                }
                catch (NamingException e2) {
                    m_log.error((Object)("load() context close failed : " + e2.getMessage()));
                }
                {
                    break block23;
                    catch (NamingException ex) {
                        if (ex instanceof CommunicationException) {
                            LdapConnectionManager.getConnectionManager().setDirContext(null);
                        }
                        m_log.debug((Object)("load(): catch NamingException" + ex.getMessage()));
                        if (++retryCount >= MAX_RETRY) {
                            throw new EJBException((Exception)ex);
                        }
                        var9_9 = null;
                        try {
                            if (ctx != null) {
                                ctx.close();
                            }
                        }
                        catch (NamingException e2) {
                            m_log.error((Object)("load() context close failed : " + e2.getMessage()));
                        }
                        TimeKeeperService.stop((TimeKeeper)timer);
                        continue;
                    }
                    catch (NullPointerException e) {
                        m_log.debug((Object)"load() : LDAP query result is null");
                        if (++retryCount >= MAX_RETRY) {
                            throw new EJBException((Exception)e);
                        }
                        var9_9 = null;
                        try {
                            if (ctx != null) {
                                ctx.close();
                            }
                        }
                        catch (NamingException e2) {
                            m_log.error((Object)("load() context close failed : " + e2.getMessage()));
                        }
                        TimeKeeperService.stop((TimeKeeper)timer);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var9_9 = null;
                    try {
                        if (ctx != null) {
                            ctx.close();
                        }
                    }
                    catch (NamingException e2) {
                        m_log.error((Object)("load() context close failed : " + e2.getMessage()));
                    }
                    TimeKeeperService.stop((TimeKeeper)timer);
                    throw throwable;
                }
            }
            TimeKeeperService.stop((TimeKeeper)timer);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void store(FileSystemInfoBean ejb) throws EJBException {
        DirContext ctx = null;
        int retryCount = 0;
        while (MAX_RETRY > retryCount) {
            TimeKeeper timer;
            block43: {
                timer = null;
                ctx = LdapConnectionManager.getConnectionManager().getDirContext();
                timer = TimeKeeperService.start();
                Attributes attrs = ctx.getAttributes(ejb.getDn());
                BasicAttributes addAttrs = new BasicAttributes();
                BasicAttributes replaceAttrs = new BasicAttributes();
                BasicAttributes removeAttrs = new BasicAttributes();
                if (attrs.get("description") == null && ejb.getDescription() != null) {
                    addAttrs.put("description", ejb.getDescription());
                } else if (attrs.get("description") != null && ejb.getDescription() == null) {
                    removeAttrs.put("description", null);
                } else if (attrs.get("description") != null && ejb.getDescription() != null) {
                    replaceAttrs.put("description", ejb.getDescription());
                }
                if (attrs.get("ccSnmpOID") == null && ejb.getSnmpOID() != null) {
                    addAttrs.put("ccSnmpOID", ejb.getSnmpOID());
                } else if (attrs.get("ccSnmpOID") != null && ejb.getSnmpOID() == null) {
                    removeAttrs.put("ccSnmpOID", null);
                } else if (attrs.get("ccSnmpOID") != null && ejb.getSnmpOID() != null) {
                    replaceAttrs.put("ccSnmpOID", ejb.getSnmpOID());
                }
                if (attrs.get("ccFileSystemMountPoint") == null && ejb.getFileSystemMountPoint() != null) {
                    addAttrs.put("ccFileSystemMountPoint", ejb.getFileSystemMountPoint());
                } else if (attrs.get("ccFileSystemMountPoint") != null && ejb.getFileSystemMountPoint() == null) {
                    removeAttrs.put("ccFileSystemMountPoint", null);
                } else if (attrs.get("ccFileSystemMountPoint") != null && ejb.getFileSystemMountPoint() != null) {
                    replaceAttrs.put("ccFileSystemMountPoint", ejb.getFileSystemMountPoint());
                }
                if (attrs.get("ccFileSystemType") == null && ejb.getFileSystemType() != null) {
                    addAttrs.put("ccFileSystemType", ejb.getFileSystemType());
                } else if (attrs.get("ccFileSystemType") != null && ejb.getFileSystemType() == null) {
                    removeAttrs.put("ccFileSystemType", null);
                } else if (attrs.get("ccFileSystemType") != null && ejb.getFileSystemType() != null) {
                    replaceAttrs.put("ccFileSystemType", ejb.getFileSystemType());
                }
                if (attrs.get("ccDisplayName") == null && ejb.getDisplayName() != null) {
                    addAttrs.put("ccDisplayName", ejb.getDisplayName());
                } else if (attrs.get("ccDisplayName") != null && ejb.getDisplayName() == null) {
                    removeAttrs.put("ccDisplayName", null);
                } else if (attrs.get("ccDisplayName") != null && ejb.getDisplayName() != null) {
                    replaceAttrs.put("ccDisplayName", ejb.getDisplayName());
                }
                ctx.modifyAttributes(ejb.getDn(), 1, (Attributes)addAttrs);
                ctx.modifyAttributes(ejb.getDn(), 2, (Attributes)replaceAttrs);
                ctx.modifyAttributes(ejb.getDn(), 3, (Attributes)removeAttrs);
                Object var10_8 = null;
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                    break block43;
                }
                catch (NamingException e2) {
                    m_log.error((Object)("store() context close failed : " + e2.getMessage()));
                }
                {
                    break block43;
                    catch (NamingException ex) {
                        if (ex instanceof CommunicationException) {
                            LdapConnectionManager.getConnectionManager().setDirContext(null);
                        }
                        if (++retryCount >= MAX_RETRY) {
                            throw new EJBException((Exception)ex);
                        }
                        var10_8 = null;
                        try {
                            if (ctx != null) {
                                ctx.close();
                            }
                        }
                        catch (NamingException e2) {
                            m_log.error((Object)("store() context close failed : " + e2.getMessage()));
                        }
                        TimeKeeperService.stop((TimeKeeper)timer);
                        continue;
                    }
                    catch (NullPointerException e) {
                        m_log.debug((Object)"store() : LDAP query result is null");
                        if (++retryCount >= MAX_RETRY) {
                            throw new EJBException((Exception)e);
                        }
                        var10_8 = null;
                        try {
                            if (ctx != null) {
                                ctx.close();
                            }
                        }
                        catch (NamingException e2) {
                            m_log.error((Object)("store() context close failed : " + e2.getMessage()));
                        }
                        TimeKeeperService.stop((TimeKeeper)timer);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var10_8 = null;
                    try {
                        if (ctx != null) {
                            ctx.close();
                        }
                    }
                    catch (NamingException e2) {
                        m_log.error((Object)("store() context close failed : " + e2.getMessage()));
                    }
                    TimeKeeperService.stop((TimeKeeper)timer);
                    throw throwable;
                }
            }
            TimeKeeperService.stop((TimeKeeper)timer);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(FileSystemInfoPK pk) throws RemoveException, EJBException {
        block22: {
            ctx = null;
            retryCount = 0;
            while (true) {
                if (FileSystemInfoDAOImpl.MAX_RETRY <= retryCount) {
                    return;
                }
                timer = null;
                try {
                    try {
                        ctx = LdapConnectionManager.getConnectionManager().getDirContext();
                        timer = TimeKeeperService.start();
                        ctx.destroySubcontext(pk.getDn());
                        var9_10 = null;
                        break;
                    }
                    catch (NamingException ex) {
                        if (ex instanceof CommunicationException) {
                            LdapConnectionManager.getConnectionManager().setDirContext(null);
                        }
                        apllog = new AplLogger("REP", "rep");
                        args = new String[]{pk.getDn()};
                        apllog.put("SYS", "004", args);
                        if (++retryCount >= FileSystemInfoDAOImpl.MAX_RETRY) {
                            throw new EJBException((Exception)ex);
                        }
                        var9_10 = null;
                        try {
                            if (ctx != null) {
                                ctx.close();
                            }
                        }
                        catch (NamingException e) {
                            FileSystemInfoDAOImpl.m_log.error((Object)("remove() context close failed : " + e.getMessage()));
                        }
                        TimeKeeperService.stop((TimeKeeper)timer);
                    }
                    catch (NullPointerException e) {
                        block20: {
                            FileSystemInfoDAOImpl.m_log.debug((Object)"remove() : LDAP query result is null");
                            if (++retryCount >= FileSystemInfoDAOImpl.MAX_RETRY) {
                                throw new EJBException((Exception)e);
                            }
                            var9_10 = null;
                            ** try [egrp 2[TRYBLOCK] [6 : 168->181)] { 
lbl39:
                            // 1 sources

                            if (ctx != null) {
                                ctx.close();
                            }
                            break block20;
lbl42:
                            // 1 sources

                            catch (NamingException e) {
                                FileSystemInfoDAOImpl.m_log.error((Object)("remove() context close failed : " + e.getMessage()));
                            }
                        }
                        TimeKeeperService.stop((TimeKeeper)timer);
                    }
                }
                catch (Throwable var8_12) {
                    block21: {
                        var9_10 = null;
                        ** try [egrp 2[TRYBLOCK] [6 : 168->181)] { 
lbl51:
                        // 1 sources

                        if (ctx != null) {
                            ctx.close();
                        }
                        break block21;
lbl54:
                        // 1 sources

                        catch (NamingException e) {
                            FileSystemInfoDAOImpl.m_log.error((Object)("remove() context close failed : " + e.getMessage()));
                        }
                    }
                    TimeKeeperService.stop((TimeKeeper)timer);
                    throw var8_12;
                }
            }
            ** try [egrp 2[TRYBLOCK] [6 : 168->181)] { 
lbl61:
            // 1 sources

            if (ctx != null) {
                ctx.close();
            }
            break block22;
lbl64:
            // 1 sources

            catch (NamingException e) {
                FileSystemInfoDAOImpl.m_log.error((Object)("remove() context close failed : " + e.getMessage()));
            }
        }
        TimeKeeperService.stop((TimeKeeper)timer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public FileSystemInfoPK create(FileSystemInfoBean ejb) throws CreateException, EJBException {
        FileSystemInfoPK pk = null;
        DirContext ctx = null;
        int retryCount = 0;
        while (MAX_RETRY > retryCount) {
            TimeKeeper timer = null;
            ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            BasicAttributes attrs = new BasicAttributes();
            attrs.put(OBJECTCLASS, OBJECT_CLASS_FILE_SYSTEM_INFO);
            attrs.put("cn", ejb.getCn().toString());
            StringBuffer dn = new StringBuffer();
            dn.append("cn");
            dn.append("=");
            dn.append(ejb.getCn());
            dn.append(",");
            dn.append("ccFacilityId");
            dn.append("=");
            dn.append(ejb.getFacilityId());
            dn.append(",");
            dn.append(BASE_DN);
            ejb.setDn(dn.toString());
            timer = TimeKeeperService.start();
            ctx.createSubcontext(ejb.getDn(), (Attributes)attrs);
            FileSystemInfoPK fileSystemInfoPK = pk = new FileSystemInfoPK(ejb.getDn());
            Object var10_11 = null;
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e2) {
                m_log.error((Object)("create() context close failed : " + e2.getMessage()));
            }
            TimeKeeperService.stop((TimeKeeper)timer);
            {
                return fileSystemInfoPK;
                catch (NamingException ex) {
                    if (ex instanceof CommunicationException) {
                        LdapConnectionManager.getConnectionManager().setDirContext(null);
                    }
                    AplLogger apllog = new AplLogger("REP", "rep");
                    Object[] args = new String[]{ejb.getDn()};
                    apllog.put("SYS", "003", args);
                    if (++retryCount >= MAX_RETRY) {
                        throw new EJBException((Exception)ex);
                    }
                    var10_11 = null;
                    try {
                        if (ctx != null) {
                            ctx.close();
                        }
                    }
                    catch (NamingException e2) {
                        m_log.error((Object)("create() context close failed : " + e2.getMessage()));
                    }
                    TimeKeeperService.stop(timer);
                    continue;
                }
                catch (NullPointerException e) {
                    m_log.debug((Object)"create() : LDAP query result is null");
                    if (++retryCount >= MAX_RETRY) {
                        throw new EJBException((Exception)e);
                    }
                    var10_11 = null;
                    try {
                        if (ctx != null) {
                            ctx.close();
                        }
                    }
                    catch (NamingException e2) {
                        m_log.error((Object)("create() context close failed : " + e2.getMessage()));
                    }
                    TimeKeeperService.stop(timer);
                    continue;
                }
            }
            catch (Throwable throwable) {
                var10_11 = null;
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (NamingException e2) {
                    m_log.error((Object)("create() context close failed : " + e2.getMessage()));
                }
                TimeKeeperService.stop(timer);
                throw throwable;
            }
        }
        return pk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Collection findAll() throws FinderException {
        ArrayList<FileSystemInfoPK> ret = new ArrayList<FileSystemInfoPK>();
        m_log.debug((Object)"findAll()");
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        StringBuffer search = new StringBuffer();
        search.append("(&(");
        search.append(OBJECTCLASS);
        search.append("=");
        search.append(OBJECT_CLASS_FILE_SYSTEM_INFO);
        search.append("))");
        NamingEnumeration<SearchResult> results = null;
        DirContext ctx = null;
        int retryCount = 0;
        while (MAX_RETRY > retryCount) {
            NamingException e222;
            Object var11_12;
            TimeKeeper timer;
            block27: {
                timer = null;
                ctx = LdapConnectionManager.getConnectionManager().getDirContext();
                timer = TimeKeeperService.start();
                results = ctx.search(BASE_DN, search.toString(), constraints);
                if (results != null) break block27;
                m_log.debug((Object)"findAll() : No Search Result");
                ArrayList<FileSystemInfoPK> arrayList = ret;
                var11_12 = null;
                try {
                    if (results != null) {
                        results.close();
                    }
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (NamingException e222) {
                    m_log.error((Object)("findAll() context close failed : " + e222.getMessage()));
                }
                TimeKeeperService.stop((TimeKeeper)timer);
                return arrayList;
            }
            while (results.hasMoreElements()) {
                SearchResult aResult = (SearchResult)results.nextElement();
                FileSystemInfoPK pk = new FileSystemInfoPK(aResult.getName() + "," + BASE_DN);
                ret.add(pk);
            }
            var11_12 = null;
            try {
                if (results != null) {
                    results.close();
                }
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e222) {
                m_log.error((Object)("findAll() context close failed : " + e222.getMessage()));
            }
            TimeKeeperService.stop((TimeKeeper)timer);
            {
                continue;
                catch (NamingException e3) {
                    if (e3 instanceof CommunicationException) {
                        LdapConnectionManager.getConnectionManager().setDirContext(null);
                    }
                    m_log.debug((Object)("findAll() : " + e3.getMessage()));
                    ret.clear();
                    if (++retryCount >= MAX_RETRY) {
                        throw new EJBException((Exception)e3);
                    }
                    var11_12 = null;
                    try {
                        if (results != null) {
                            results.close();
                        }
                        if (ctx != null) {
                            ctx.close();
                        }
                    }
                    catch (NamingException e222) {
                        m_log.error((Object)("findAll() context close failed : " + e222.getMessage()));
                    }
                    TimeKeeperService.stop((TimeKeeper)timer);
                    continue;
                }
                catch (NullPointerException e4) {
                    m_log.debug((Object)"findAll() : LDAP query result is null");
                    ret.clear();
                    if (++retryCount >= MAX_RETRY) {
                        throw new EJBException((Exception)e4);
                    }
                    var11_12 = null;
                    try {
                        if (results != null) {
                            results.close();
                        }
                        if (ctx != null) {
                            ctx.close();
                        }
                    }
                    catch (NamingException e222) {
                        m_log.error((Object)("findAll() context close failed : " + e222.getMessage()));
                    }
                    TimeKeeperService.stop((TimeKeeper)timer);
                    continue;
                }
            }
            catch (Throwable throwable) {
                var11_12 = null;
                try {
                    if (results != null) {
                        results.close();
                    }
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (NamingException e222) {
                    m_log.error((Object)("findAll() context close failed : " + e222.getMessage()));
                }
                TimeKeeperService.stop((TimeKeeper)timer);
                throw throwable;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public FileSystemInfoPK findByPrimaryKey(FileSystemInfoPK pk) throws FinderException {
        Context ctx = null;
        int retryCount = 0;
        while (MAX_RETRY > retryCount) {
            TimeKeeper timer;
            block18: {
                timer = null;
                m_log.debug((Object)("findByPrimaryKey() : dn = " + pk.getDn()));
                ctx = LdapConnectionManager.getConnectionManager().getDirContext();
                timer = TimeKeeperService.start();
                Attributes attrs = ctx.getAttributes(pk.getDn());
                Object var7_8 = null;
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                    break block18;
                }
                catch (NamingException e2) {
                    m_log.error((Object)("findByPrimaryKey() context close failed : " + e2.getMessage()));
                }
                {
                    break block18;
                    catch (NamingException ex) {
                        if (ex instanceof CommunicationException) {
                            LdapConnectionManager.getConnectionManager().setDirContext(null);
                        }
                        m_log.debug((Object)("findByPrimaryKey() : " + ex.getMessage()));
                        if (++retryCount >= MAX_RETRY) {
                            throw new EJBException((Exception)ex);
                        }
                        var7_8 = null;
                        try {
                            if (ctx != null) {
                                ctx.close();
                            }
                        }
                        catch (NamingException e2) {
                            m_log.error((Object)("findByPrimaryKey() context close failed : " + e2.getMessage()));
                        }
                        TimeKeeperService.stop((TimeKeeper)timer);
                        continue;
                    }
                    catch (NullPointerException e) {
                        m_log.debug((Object)"findByFacilityIdAndName() : LDAP query result is null");
                        if (++retryCount >= MAX_RETRY) {
                            throw new EJBException((Exception)e);
                        }
                        var7_8 = null;
                        try {
                            if (ctx != null) {
                                ctx.close();
                            }
                        }
                        catch (NamingException e2) {
                            m_log.error((Object)("findByPrimaryKey() context close failed : " + e2.getMessage()));
                        }
                        TimeKeeperService.stop((TimeKeeper)timer);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var7_8 = null;
                    try {
                        if (ctx != null) {
                            ctx.close();
                        }
                    }
                    catch (NamingException e2) {
                        m_log.error((Object)("findByPrimaryKey() context close failed : " + e2.getMessage()));
                    }
                    TimeKeeperService.stop(timer);
                    throw throwable;
                }
            }
            TimeKeeperService.stop((TimeKeeper)timer);
            return pk;
        }
        return pk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Collection findByFacilityId(String facilityId) throws FinderException {
        ArrayList<FileSystemInfoPK> ret = new ArrayList<FileSystemInfoPK>();
        m_log.debug((Object)("findByFacilityId() : FacilityId = " + facilityId));
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        StringBuffer baseDn = new StringBuffer();
        baseDn.append("ccFacilityId");
        baseDn.append("=");
        baseDn.append(facilityId);
        baseDn.append(",");
        baseDn.append(BASE_DN);
        StringBuffer search = new StringBuffer();
        search.append("(&(");
        search.append(OBJECTCLASS);
        search.append("=");
        search.append(OBJECT_CLASS_FILE_SYSTEM_INFO);
        search.append("))");
        NamingEnumeration<SearchResult> results = null;
        DirContext ctx = null;
        int retryCount = 0;
        while (MAX_RETRY > retryCount) {
            TimeKeeper timer;
            block29: {
                NamingException e222;
                Object var13_13;
                block27: {
                    timer = null;
                    ctx = LdapConnectionManager.getConnectionManager().getDirContext();
                    timer = TimeKeeperService.start();
                    results = ctx.search(baseDn.toString(), search.toString(), constraints);
                    if (results != null) break block27;
                    m_log.warn((Object)("findByFacilityId() : No Search Result : FacilityId = " + facilityId));
                    ArrayList<FileSystemInfoPK> arrayList = ret;
                    var13_13 = null;
                    try {
                        if (results != null) {
                            results.close();
                        }
                        if (ctx != null) {
                            ctx.close();
                        }
                    }
                    catch (NamingException e222) {
                        m_log.error((Object)("findByFacilityId() context close failed : " + e222.getMessage()));
                    }
                    TimeKeeperService.stop((TimeKeeper)timer);
                    return arrayList;
                }
                while (results.hasMoreElements()) {
                    SearchResult aResult = (SearchResult)results.nextElement();
                    FileSystemInfoPK pk = new FileSystemInfoPK(aResult.getName() + "," + baseDn.toString());
                    ret.add(pk);
                }
                var13_13 = null;
                try {
                    if (results != null) {
                        results.close();
                    }
                    if (ctx != null) {
                        ctx.close();
                    }
                    break block29;
                }
                catch (NamingException e222) {
                    m_log.error((Object)("findByFacilityId() context close failed : " + e222.getMessage()));
                }
                {
                    break block29;
                    catch (NamingException e3) {
                        if (e3 instanceof CommunicationException) {
                            LdapConnectionManager.getConnectionManager().setDirContext(null);
                        }
                        m_log.debug((Object)("findByFacilityId() : " + e3.getMessage()));
                        ret.clear();
                        if (++retryCount >= MAX_RETRY) {
                            throw new EJBException((Exception)e3);
                        }
                        var13_13 = null;
                        try {
                            if (results != null) {
                                results.close();
                            }
                            if (ctx != null) {
                                ctx.close();
                            }
                        }
                        catch (NamingException e222) {
                            m_log.error((Object)("findByFacilityId() context close failed : " + e222.getMessage()));
                        }
                        TimeKeeperService.stop((TimeKeeper)timer);
                        continue;
                    }
                    catch (NullPointerException e4) {
                        m_log.debug((Object)"findByFacilityId() : LDAP query result is null");
                        ret.clear();
                        if (++retryCount >= MAX_RETRY) {
                            throw new EJBException((Exception)e4);
                        }
                        var13_13 = null;
                        try {
                            if (results != null) {
                                results.close();
                            }
                            if (ctx != null) {
                                ctx.close();
                            }
                        }
                        catch (NamingException e222) {
                            m_log.error((Object)("findByFacilityId() context close failed : " + e222.getMessage()));
                        }
                        TimeKeeperService.stop((TimeKeeper)timer);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var13_13 = null;
                    try {
                        if (results != null) {
                            results.close();
                        }
                        if (ctx != null) {
                            ctx.close();
                        }
                    }
                    catch (NamingException e222) {
                        m_log.error((Object)("findByFacilityId() context close failed : " + e222.getMessage()));
                    }
                    TimeKeeperService.stop((TimeKeeper)timer);
                    throw throwable;
                }
            }
            TimeKeeperService.stop((TimeKeeper)timer);
            return ret;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public FileSystemInfoPK findByFacilityIdAndName(String facilityId, String name) throws FinderException {
        m_log.debug((Object)("findByFacilityIdAndName() : FacilityId = " + facilityId + ", FacilityName = " + name));
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        StringBuffer baseDn = new StringBuffer();
        baseDn.append("ccFacilityId");
        baseDn.append("=");
        baseDn.append(facilityId);
        baseDn.append(",");
        baseDn.append(BASE_DN);
        StringBuffer search = new StringBuffer();
        search.append("(&(");
        search.append(OBJECTCLASS);
        search.append("=");
        search.append(OBJECT_CLASS_FILE_SYSTEM_INFO);
        search.append(")(");
        search.append("cn");
        search.append("=");
        search.append(name);
        search.append("))");
        NamingEnumeration<SearchResult> results = null;
        DirContext ctx = null;
        FileSystemInfoPK pk = null;
        int retryCount = 0;
        while (MAX_RETRY > retryCount) {
            TimeKeeper timer;
            block23: {
                timer = null;
                ctx = LdapConnectionManager.getConnectionManager().getDirContext();
                timer = TimeKeeperService.start();
                results = ctx.search(baseDn.toString(), search.toString(), constraints);
                if (!results.hasMoreElements()) {
                    throw new FinderException("FacilityId = " + facilityId + ", FacilityName = " + name + " not found.");
                }
                SearchResult aResult = (SearchResult)results.nextElement();
                pk = new FileSystemInfoPK(aResult.getName() + "," + baseDn.toString());
                Object var13_14 = null;
                try {
                    if (results != null) {
                        results.close();
                    }
                    if (ctx != null) {
                        ctx.close();
                    }
                    break block23;
                }
                catch (NamingException e2) {
                    m_log.error((Object)("findByFacilityIdAndName() context close failed : " + e2.getMessage()));
                }
                {
                    break block23;
                    catch (NamingException ex) {
                        if (ex instanceof CommunicationException) {
                            LdapConnectionManager.getConnectionManager().setDirContext(null);
                        }
                        m_log.debug((Object)("findByFacilityIdAndName() : " + ex.getMessage()));
                        if (++retryCount >= MAX_RETRY) {
                            throw new EJBException((Exception)ex);
                        }
                        var13_14 = null;
                        try {
                            if (results != null) {
                                results.close();
                            }
                            if (ctx != null) {
                                ctx.close();
                            }
                        }
                        catch (NamingException e2) {
                            m_log.error((Object)("findByFacilityIdAndName() context close failed : " + e2.getMessage()));
                        }
                        TimeKeeperService.stop((TimeKeeper)timer);
                        continue;
                    }
                    catch (NullPointerException e) {
                        m_log.debug((Object)"findByFacilityIdAndName() : LDAP query result is null");
                        if (++retryCount >= MAX_RETRY) {
                            throw new EJBException((Exception)e);
                        }
                        var13_14 = null;
                        try {
                            if (results != null) {
                                results.close();
                            }
                            if (ctx != null) {
                                ctx.close();
                            }
                        }
                        catch (NamingException e2) {
                            m_log.error((Object)("findByFacilityIdAndName() context close failed : " + e2.getMessage()));
                        }
                        TimeKeeperService.stop((TimeKeeper)timer);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var13_14 = null;
                    try {
                        if (results != null) {
                            results.close();
                        }
                        if (ctx != null) {
                            ctx.close();
                        }
                    }
                    catch (NamingException e2) {
                        m_log.error((Object)("findByFacilityIdAndName() context close failed : " + e2.getMessage()));
                    }
                    TimeKeeperService.stop((TimeKeeper)timer);
                    throw throwable;
                }
            }
            TimeKeeperService.stop((TimeKeeper)timer);
            return pk;
        }
        return pk;
    }

    protected void clearBean(FileSystemInfoBean ejb) {
        ejb.setCn(null);
        ejb.setDescription(null);
        ejb.setFileSystemMountPoint(null);
        ejb.setFileSystemType(null);
        ejb.setDn(null);
        ejb.setFacilityId(null);
        ejb.setSnmpOID(null);
        ejb.setDisplayName(null);
    }
}

