/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.util.apllog;

import com.clustercontrol.bean.OutputNotifyGroupInfo;
import com.clustercontrol.util.apllog.PropertyUtil;
import com.clustercontrol.util.apllog.SendQueue;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AplLogger {
    public static final String INTERNAL_SCOPE = "INTERNAL";
    public static final String INTERNAL_SCOPE_TEXT = "Hinemos_Internal";
    private static final String PRIORITY_UNKNOWN = "unknown";
    private static final String PRIORITY_INFO = "info";
    private static final String PRIORITY_WARNING = "warning";
    private static final String PRIORITY_CRITICAL = "critical";
    private String m_pluginID;
    private String m_aplID;
    private String m_aplName;
    private static SendQueue m_sendQueue = null;
    private static Map m_priorityMap = null;
    private static Map m_outPutMap = null;
    static Log FILE_LOGGER = LogFactory.getLog((String)"hinemos.apllog");
    static Log log = LogFactory.getLog(AplLogger.class);
    private MessageFormat m_logfmt = new MessageFormat("{0,date,yyyy/MM/dd HH:mm:ss}  {1},{2},{3},{4},{5},{6}");

    public AplLogger(String pluginID, String aplId) {
        this.m_pluginID = pluginID;
        this.m_aplID = aplId;
        if (m_sendQueue == null) {
            m_sendQueue = new SendQueue("queue/clustercontrolNotifyEvent");
        }
        this.m_aplName = PropertyUtil.getString(pluginID + "." + aplId);
        if (m_priorityMap == null) {
            m_priorityMap = Collections.synchronizedMap(new HashMap());
            m_priorityMap.put(PRIORITY_CRITICAL, PropertyUtil.getString("priority.critical"));
            m_priorityMap.put(PRIORITY_WARNING, PropertyUtil.getString("priority.warning"));
            m_priorityMap.put(PRIORITY_INFO, PropertyUtil.getString("priority.info"));
            m_priorityMap.put(PRIORITY_UNKNOWN, PropertyUtil.getString("priority.unknown"));
        }
        if (m_outPutMap == null) {
            m_outPutMap = Collections.synchronizedMap(new HashMap());
            m_outPutMap.put(PRIORITY_CRITICAL, new OutPutInfo(PropertyUtil.getString("priority.critical.output")));
            m_outPutMap.put(PRIORITY_WARNING, new OutPutInfo(PropertyUtil.getString("priority.warning.output")));
            m_outPutMap.put(PRIORITY_INFO, new OutPutInfo(PropertyUtil.getString("priority.info.output")));
            m_outPutMap.put(PRIORITY_UNKNOWN, new OutPutInfo(PropertyUtil.getString("priority.unknown.output")));
        }
    }

    public static void main(String[] args) {
        AplLogger apllog = new AplLogger("REP", "rep");
        apllog.put("SYS", "001");
        apllog.put("USR", "001");
        apllog.put("USR", "002");
        apllog.put("USR", "003");
    }

    public void put(String moniterID, String msgID, Object[] msgArgs, String detailMsg) {
        boolean isMsgOutPut = true;
        boolean isFileOutPut = true;
        Date nowDate = new Date();
        StringBuffer keyBase = new StringBuffer();
        keyBase.append(this.m_pluginID);
        keyBase.append(".");
        keyBase.append(moniterID);
        keyBase.append(".");
        keyBase.append(msgID);
        StringBuffer keyPriority = new StringBuffer();
        keyPriority.append(keyBase);
        keyPriority.append(".");
        keyPriority.append("priority");
        String priority = PropertyUtil.getString(keyPriority.toString());
        StringBuffer keyMsg = new StringBuffer();
        keyMsg.append(keyBase);
        keyMsg.append(".");
        keyMsg.append("message");
        String msg = null;
        msg = msgArgs != null && msgArgs.length != 0 ? PropertyUtil.getString(keyMsg.toString(), msgArgs) : PropertyUtil.getString(keyMsg.toString());
        OutPutInfo outPutInfo = (OutPutInfo)m_outPutMap.get(priority);
        if (outPutInfo != null) {
            isMsgOutPut = outPutInfo.isMsgOutPut();
            isFileOutPut = outPutInfo.isFileOutPut();
        }
        if (isMsgOutPut && !this.putMsg(nowDate, moniterID, msgID, this.getPriority(priority), msg, detailMsg)) {
            isFileOutPut = true;
        }
        if (isFileOutPut) {
            String priorityStr = (String)m_priorityMap.get(priority);
            if (priorityStr == null) {
                priorityStr = (String)m_priorityMap.get(PRIORITY_UNKNOWN);
            }
            this.putFile(nowDate, moniterID, msgID, priorityStr, msg, detailMsg);
        }
    }

    public void put(String moniterID, String msgID) {
        this.put(moniterID, msgID, null, null);
    }

    public void put(String moniterID, String msgID, Object[] msgArgs) {
        this.put(moniterID, msgID, msgArgs, null);
    }

    public void put(String moniterID, String msgID, String detailMsg) {
        this.put(moniterID, msgID, null, detailMsg);
    }

    public void putFile(Date genDate, String monitorId, String msgId, String priority, String msg, String detailMsg) {
        Object[] args = new Object[]{genDate, this.m_pluginID, this.m_aplName, monitorId, msgId, priority, msg, detailMsg};
        String logmsg = this.m_logfmt.format(args);
        FILE_LOGGER.info((Object)logmsg);
    }

    private boolean putMsg(Date genDate, String monitorId, String msgId, int priority, String msg, String detailMsg) {
        OutputNotifyGroupInfo output = new OutputNotifyGroupInfo();
        output.setPluginId(this.m_pluginID);
        output.setMonitorId(monitorId);
        output.setFacilityId(INTERNAL_SCOPE);
        output.setScopeText(INTERNAL_SCOPE_TEXT);
        output.setApplication(this.m_aplName);
        output.setMessageId(msgId);
        output.setMessage(msg);
        output.setMessageOrg(detailMsg == null ? "" : detailMsg);
        output.setPriority(priority);
        output.setGenerationDate(genDate);
        return m_sendQueue.put((Serializable)output);
    }

    private int getPriority(String priority) {
        int ret = 1;
        if (priority.equals(PRIORITY_CRITICAL)) {
            ret = 0;
        } else if (priority.equals(PRIORITY_WARNING)) {
            ret = 2;
        } else if (priority.equals(PRIORITY_INFO)) {
            ret = 3;
        }
        return ret;
    }

    private class OutPutInfo {
        private static final String OUTPUT_BOTH = "both";
        private static final String OUTPUT_FILE = "file";
        private static final String OUTPUT_MSG = "msg";
        boolean isFileOutPut = true;
        boolean isMsgOutPut = true;

        public OutPutInfo(String output) {
            if (output.equals(OUTPUT_FILE)) {
                this.isFileOutPut = true;
                this.isMsgOutPut = false;
            } else if (output.equals(OUTPUT_MSG)) {
                this.isFileOutPut = false;
                this.isMsgOutPut = true;
            }
        }

        public boolean isFileOutPut() {
            return this.isFileOutPut;
        }

        public boolean isMsgOutPut() {
            return this.isMsgOutPut;
        }
    }
}

