/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.console.twiddle.command;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.PrintWriter;
import javax.management.ObjectName;
import org.jboss.console.twiddle.command.CommandException;
import org.jboss.console.twiddle.command.MBeanServerCommand;
import org.jboss.util.Strings;

public class QueryCommand
extends MBeanServerCommand {
    private String query;
    private boolean displayCount;

    public QueryCommand() {
        super("query", "Query the server for a list of matching MBeans");
    }

    public void displayHelp() {
        PrintWriter out = this.context.getWriter();
        out.println(this.desc);
        out.println();
        out.println("usage: " + this.name + " [options] <query>");
        out.println("options:");
        out.println("    -c, --count    Display the matching MBean count");
        out.println("    --             Stop processing options");
        out.println("Examples:");
        out.println(" query all mbeans: " + this.name + " '*:*'");
        out.println(" query all mbeans in the jboss.j2ee domain: " + this.name + " 'jboss.j2ee:*'");
        out.flush();
    }

    private void processArguments(String[] args) throws CommandException {
        int code;
        this.log.debug((Object)("processing arguments: " + Strings.join((Object[])args, (String)",")));
        if (args.length == 0) {
            throw new CommandException("Command requires arguments");
        }
        String sopts = "-:c";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("count", 0, null, 99)};
        Getopt getopt = new Getopt(null, args, sopts, lopts);
        getopt.setOpterr(false);
        int argidx = 0;
        while ((code = getopt.getopt()) != -1) {
            block0 : switch (code) {
                case 58: {
                    throw new CommandException("Option requires an argument: " + args[getopt.getOptind() - 1]);
                }
                case 63: {
                    throw new CommandException("Invalid (or ambiguous) option: " + args[getopt.getOptind() - 1]);
                }
                case 1: {
                    String arg = getopt.getOptarg();
                    switch (argidx++) {
                        case 0: {
                            this.query = arg;
                            this.log.debug((Object)("query: " + this.query));
                            break block0;
                        }
                    }
                    throw new CommandException("Unused argument: " + arg);
                }
                case 99: {
                    this.displayCount = true;
                }
            }
        }
    }

    public void execute(String[] args) throws Exception {
        this.processArguments(args);
        if (this.query == null) {
            throw new CommandException("Missing MBean query");
        }
        ObjectName[] names = this.queryMBeans(this.query);
        PrintWriter out = this.context.getWriter();
        if (this.displayCount) {
            out.println(names.length);
        } else {
            for (int i = 0; i < names.length; ++i) {
                out.println(names[i]);
            }
        }
        out.flush();
    }
}

