/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.writer.coretypes;

import java.awt.Color;
import java.io.IOException;
import org.jfree.xml.writer.AbstractXmlWriteHandler;
import org.jfree.xml.writer.AttributeList;
import org.jfree.xml.writer.XMLWriter;
import org.jfree.xml.writer.XMLWriterException;

public class ColorWriteHandler
extends AbstractXmlWriteHandler {
    public void write(String string, Object object, XMLWriter xMLWriter, String string2, String string3) throws IOException, XMLWriterException {
        Color color = (Color)object;
        AttributeList attributeList = new AttributeList();
        if (string2 != null) {
            attributeList.setAttribute(string2, string3);
        }
        attributeList.setAttribute("value", this.encodeColor(color));
        if (color.getAlpha() != 255) {
            attributeList.setAttribute("alpha", String.valueOf(color.getAlpha()));
        }
        xMLWriter.writeTag(string, attributeList, true);
    }

    private String encodeColor(Color color) {
        return "#" + this.encodeInt(color.getRed()) + this.encodeInt(color.getGreen()) + this.encodeInt(color.getBlue());
    }

    private String encodeInt(int n) {
        String string = Integer.toHexString(n);
        if (string.length() == 1) {
            return "0" + string;
        }
        return string;
    }
}

