/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.util.Iterator;
import java.util.Vector;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMProperty;
import org.sblim.wbem.cim.CIMQualifiableElement;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.util.Utils;

public abstract class CIMObject
extends CIMQualifiableElement {
    protected CIMObjectPath iObjectPath;
    protected Vector iAllProperties = new Vector(0);

    protected CIMObject() {
    }

    protected CIMObject(String pName) {
        super(pName);
    }

    public CIMProperty getProperty(String pPropertyName) {
        if (pPropertyName == null) {
            throw new IllegalArgumentException("null property name argument");
        }
        int delimiter = pPropertyName.indexOf(46);
        if (delimiter > -1) {
            return this.getProperty(pPropertyName.substring(delimiter + 1), pPropertyName.substring(0, delimiter));
        }
        Iterator iter = this.iAllProperties.iterator();
        while (iter.hasNext()) {
            CIMProperty property = (CIMProperty)iter.next();
            if (!property.getName().equalsIgnoreCase(pPropertyName)) continue;
            String overridingProperty = property.getOverridingProperty();
            if (overridingProperty != null) {
                int delimeter = overridingProperty.indexOf(46);
                if (delimeter > -1) {
                    return this.getProperty(overridingProperty.substring(delimeter + 1), overridingProperty.substring(0, delimeter));
                }
                return this.getProperty(overridingProperty);
            }
            return property;
        }
        return null;
    }

    public CIMProperty getProperty(String pName, String pOriginClass) {
        if (pName == null) {
            return null;
        }
        if (pOriginClass == null || pOriginClass.length() == 0) {
            return this.getProperty(pName);
        }
        Iterator iter = this.iAllProperties.iterator();
        while (iter.hasNext()) {
            CIMProperty property = (CIMProperty)iter.next();
            if (!property.getName().equalsIgnoreCase(pName) || !property.getOriginClass().equalsIgnoreCase(pOriginClass)) continue;
            String overridingProperty = property.getOverridingProperty();
            if (overridingProperty != null) {
                int delimeter = overridingProperty.indexOf(46);
                if (delimeter > -1) {
                    return this.getProperty(overridingProperty.substring(delimeter + 1), overridingProperty.substring(0, delimeter));
                }
                return this.getProperty(overridingProperty);
            }
            return property;
        }
        return null;
    }

    protected CIMProperty getProperty(CIMProperty pProperty) {
        Iterator iter = this.iAllProperties.iterator();
        while (iter.hasNext()) {
            CIMProperty property = (CIMProperty)iter.next();
            if (!property.getName().equalsIgnoreCase(pProperty.getName())) continue;
            return property;
        }
        return null;
    }

    public Vector getProperties() {
        Vector<CIMProperty> properties = new Vector<CIMProperty>();
        Iterator iter = this.iAllProperties.iterator();
        while (iter.hasNext()) {
            CIMProperty property = (CIMProperty)iter.next();
            if (property.getOriginClass() != null) continue;
            properties.add(property);
        }
        return properties;
    }

    public Vector getAllProperties() {
        return this.iAllProperties;
    }

    public void addProperty(CIMProperty pProperty) {
        if (pProperty == null) {
            throw new IllegalArgumentException("null property argument");
        }
        Utils.addSorted(this.iAllProperties, pProperty);
    }

    public void setProperties(Vector pProperties) {
        if (pProperties == null) {
            this.iAllProperties.setSize(0);
        } else {
            this.iAllProperties.setSize(0);
            Utils.addSorted(this.iAllProperties, pProperties);
        }
    }

    public CIMProperty setProperty(String pPropertyName, CIMValue pValue) {
        if (pPropertyName == null) {
            throw new IllegalArgumentException("null property name argument");
        }
        CIMProperty property = this.getProperty(pPropertyName);
        if (property == null) {
            property = new CIMProperty(pPropertyName, pValue);
            this.addProperty(property);
        } else {
            property.setValue(pValue);
        }
        return property;
    }

    public CIMProperty removeProperty(String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException("null property name argument");
        }
        Iterator iter = this.iAllProperties.iterator();
        while (iter.hasNext()) {
            CIMProperty prop = (CIMProperty)iter.next();
            if (!prop.getName().equalsIgnoreCase(propertyName)) continue;
            iter.remove();
            return prop;
        }
        return null;
    }

    public Vector getKeys() {
        Vector keys = new Vector();
        Iterator iter = this.iAllProperties.iterator();
        while (iter.hasNext()) {
            CIMProperty property = (CIMProperty)iter.next();
            if (!property.isKey()) continue;
            Utils.addSorted(keys, (CIMProperty)property.clone());
        }
        return keys;
    }

    abstract CIMObjectPath getObjectPath();

    public abstract void setObjectPath(CIMObjectPath var1);
}

