/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.timerservice.jboss;

import javax.ejb.TimerService;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.ejb.txtimer.EJBTimerService;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.timerservice.TimedObjectInvoker;
import org.jboss.ejb3.timerservice.TimerServiceFactory;
import org.jboss.ejb3.timerservice.jboss.TimerServiceFacade;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.MBeanServerLocator;

public class JBossTimerServiceFactory
extends TimerServiceFactory {
    private static Logger log = Logger.getLogger(JBossTimerServiceFactory.class);

    public TimerService createTimerService(Container container, TimedObjectInvoker invoker) {
        TimerServiceFacade timerService = null;
        try {
            EJBTimerService service = this.getEJBTimerService();
            TimerService delegate = service.createTimerService(container.getObjectName(), null, (org.jboss.ejb.txtimer.TimedObjectInvoker)invoker);
            timerService = new TimerServiceFacade(container, delegate);
        }
        catch (Exception e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Unable to initialize timer service", (Throwable)e);
            }
            log.trace((Object)"Unable to initialize timer service");
        }
        return timerService;
    }

    protected EJBTimerService getEJBTimerService() {
        return (EJBTimerService)MBeanProxyExt.create(EJBTimerService.class, (ObjectName)EJBTimerService.OBJECT_NAME, (MBeanServer)MBeanServerLocator.locateJBoss());
    }

    public void removeTimerService(TimerService timerService) {
        this.removeTimerService(((TimerServiceFacade)timerService).getContainerId());
    }

    protected void removeTimerService(ObjectName containerId) {
        try {
            EJBTimerService service = this.getEJBTimerService();
            service.removeTimerService(containerId, true);
        }
        catch (Exception e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Unable to initialize timer service", (Throwable)e);
            }
            log.trace((Object)"Unable to initialize timer service");
        }
    }

    public void restoreTimerService(TimerService aTimerService) {
        if (aTimerService == null) {
            log.warn((Object)"TIMER SERVICE IS NOT INSTALLED");
            return;
        }
        TimerServiceFacade timerService = (TimerServiceFacade)aTimerService;
        EJBContainer container = timerService.getContainer();
        ClassLoader loader = container.getClassloader();
        this.getEJBTimerService().restoreTimers(timerService.getContainerId(), loader);
    }
}

