/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.entity;

import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheProvider;
import org.hibernate.cache.TreeCacheProvider;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeCacheMBean;
import org.jboss.ejb3.entity.JBCCache;
import org.jboss.ejb3.entity.OptimisticJBCCache;
import org.jboss.ejb3.tx.TxUtil;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.MBeanServerLocator;

public class TreeCacheProviderHook
extends TreeCacheProvider
implements CacheProvider {
    public static final String HIBERNATE_CACHE_OBJECT_NAME_PROPERTY = "hibernate.treecache.mbean.object_name";
    public static final String DEFAULT_MBEAN_OBJECT_NAME = "jboss.cache:service=EJB3EntityTreeCache";
    protected Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    private TreeCache cache;
    private boolean optimistic;

    public Cache buildCache(String regionName, Properties properties) throws CacheException {
        String regionPrefix = properties.getProperty("hibernate.cache.region_prefix");
        if (this.optimistic) {
            return new OptimisticJBCCache(this.cache, regionName, regionPrefix);
        }
        return new JBCCache(this.cache, regionName, regionPrefix, TxUtil.getTransactionManager());
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return true;
    }

    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }

    public void start(Properties properties) {
        try {
            String cacheName = (String)properties.get(HIBERNATE_CACHE_OBJECT_NAME_PROPERTY);
            if (cacheName == null) {
                cacheName = DEFAULT_MBEAN_OBJECT_NAME;
            }
            ObjectName mbeanObjectName = new ObjectName(cacheName);
            TreeCacheMBean mbean = (TreeCacheMBean)MBeanProxyExt.create(TreeCacheMBean.class, (ObjectName)mbeanObjectName, (MBeanServer)MBeanServerLocator.locateJBoss());
            this.cache = mbean.getInstance();
            if ("OPTIMISTIC".equals(this.cache.getNodeLockingScheme())) {
                this.optimistic = true;
                this.log.debug((Object)"JBoss Cache is configured for optimistic locking; provided Cache implementations will also implement OptimisticCache");
            }
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void stop() {
    }

    public boolean isOptimistic() {
        return this.optimistic;
    }

    public TreeCache getUnderlyingCache() {
        return this.cache;
    }
}

