/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.io.Externalizable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.EJBException;
import javax.ejb.Local;
import javax.ejb.LocalHome;
import javax.ejb.Remote;
import javax.ejb.RemoteHome;
import javax.jws.WebService;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.jboss.annotation.ejb.LocalBinding;
import org.jboss.annotation.ejb.LocalHomeBinding;
import org.jboss.annotation.ejb.RemoteBinding;
import org.jboss.annotation.ejb.RemoteBindings;
import org.jboss.annotation.ejb.RemoteHomeBinding;
import org.jboss.aop.Advisor;
import org.jboss.ejb.LocalImpl;
import org.jboss.ejb.RemoteImpl;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.DeploymentScope;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.KernelAbstraction;
import org.jboss.ejb3.KernelAbstractionFactory;
import org.jboss.ejb3.SessionContainer;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyFactoryHelper {
    private static final Logger log = Logger.getLogger(ProxyFactoryHelper.class);

    public static Context getProxyFactoryContext(Context ctx) throws NamingException {
        try {
            return (Context)ctx.lookup("proxyFactory");
        }
        catch (NameNotFoundException e) {
            return ctx.createSubcontext("proxyFactory");
        }
    }

    public static String getEndpointInterface(Container container) {
        WebService ws = (WebService)((EJBContainer)container).resolveAnnotation(WebService.class);
        if (ws != null) {
            return ws.endpointInterface();
        }
        return null;
    }

    public static Class<?>[] getLocalInterfaces(Container container) {
        Local li = (Local)((EJBContainer)container).resolveAnnotation(Local.class);
        if (li != null) {
            if (li.value().length > 0) {
                return li.value();
            }
            List<Class<?>> list = ProxyFactoryHelper.getBusinessInterfaces(container.getBeanClass());
            if (list.size() == 0) {
                throw new RuntimeException("Use of empty @Local on bean class and there are no valid business interfaces: " + container.getEjbName());
            }
            if (list.size() > 1) {
                throw new RuntimeException("Use of empty @Local on bean class and there are more than one default interface: " + container.getEjbName());
            }
            Class[] rtn = new Class[]{list.get(0)};
            li = new LocalImpl(rtn);
            ((EJBContainer)container).getAnnotations().addClassAnnotation(Local.class, (Object)li);
            return rtn;
        }
        Class beanClass = container.getBeanClass();
        String endpoint = ProxyFactoryHelper.getEndpointInterface(container);
        Class<?>[] ri = ProxyFactoryHelper.getRemoteInterfaces(container);
        if (li == null && ri == null && endpoint == null && (beanClass.getInterfaces() == null || beanClass.getInterfaces().length == 0)) {
            throw new RuntimeException("bean class has no local, webservice, or remote interfaces defined and does not implement at least one business interface: " + container.getEjbName());
        }
        if (li == null) {
            List<Class<?>> intfs = ProxyFactoryHelper.getBusinessInterfaces(beanClass);
            ArrayList locals = new ArrayList();
            for (Class<?> clazz : intfs) {
                if (!clazz.isAnnotationPresent(Local.class)) continue;
                locals.add(clazz);
            }
            if (locals.size() > 0) {
                li = new LocalImpl(locals.toArray(new Class[0]));
                ((Advisor)container).getAnnotations().addClassAnnotation(Local.class, (Object)li);
            }
        }
        if (li == null) {
            List<Class<?>> interfaces = ProxyFactoryHelper.getBusinessInterfaces(beanClass);
            if (interfaces.size() != 1) {
                return null;
            }
            Class<?> intf = interfaces.get(0);
            if (ri != null) {
                for (Class<?> rintf : ri) {
                    if (!intf.getName().equals(rintf.getName())) continue;
                    return null;
                }
            }
            if (intf.getName().equals(endpoint)) {
                return null;
            }
            Class[] rtn = new Class[]{intf};
            li = new LocalImpl(rtn);
            ((EJBContainer)container).getAnnotations().addClassAnnotation(Local.class, (Object)li);
            return rtn;
        }
        if (ri != null) {
            for (Class<?> remoteInterface : ri) {
                for (Class localInterface : li.value()) {
                    if (!localInterface.equals(remoteInterface)) continue;
                    throw new RuntimeException("@Remote and @Local may not both be specified on the same interface \"" + remoteInterface.toString() + "\" per EJB3 Spec 4.6.7, Bullet 5.4");
                }
            }
        }
        return li.value();
    }

    public static List<Class<?>> getBusinessInterfaces(Class<?> beanClass) {
        return ProxyFactoryHelper.getBusinessInterfaces(beanClass, new ArrayList());
    }

    private static List<Class<?>> getBusinessInterfaces(Class<?> beanClass, List<Class<?>> interfaces) {
        for (Class<?> intf : beanClass.getInterfaces()) {
            if (intf.equals(Externalizable.class) || intf.equals(Serializable.class) || intf.getName().startsWith("javax.ejb") || intf.getName().startsWith("org.jboss.aop")) continue;
            interfaces.add(intf);
        }
        if (beanClass.getSuperclass() == null) {
            return interfaces;
        }
        return ProxyFactoryHelper.getBusinessInterfaces(beanClass.getSuperclass(), interfaces);
    }

    public static Class getLocalHomeInterface(Container container) {
        Class beanClass = container.getBeanClass();
        LocalHome li = (LocalHome)((EJBContainer)container).resolveAnnotation(LocalHome.class);
        if (li != null) {
            return li.value();
        }
        return null;
    }

    public static Class getRemoteHomeInterface(Container container) {
        Class beanClass = container.getBeanClass();
        RemoteHome li = (RemoteHome)((EJBContainer)container).resolveAnnotation(RemoteHome.class);
        if (li != null) {
            return li.value();
        }
        return null;
    }

    public static boolean publishesInterface(Container container, Class businessInterface) {
        Class localHome;
        Class remoteHome;
        if (!(container instanceof SessionContainer)) {
            return false;
        }
        Class<?>[] remotes = ProxyFactoryHelper.getRemoteInterfaces(container);
        if (remotes != null) {
            for (Class<?> intf : remotes) {
                if (!intf.getName().equals(businessInterface.getName())) continue;
                return true;
            }
        }
        if ((remoteHome = ProxyFactoryHelper.getRemoteHomeInterface(container)) != null && businessInterface.getName().equals(remoteHome.getName())) {
            return true;
        }
        Class<?>[] locals = ProxyFactoryHelper.getLocalInterfaces(container);
        if (locals != null) {
            for (Class<?> clazz : locals) {
                if (!clazz.getName().equals(businessInterface.getName())) continue;
                return true;
            }
        }
        return (localHome = ProxyFactoryHelper.getLocalHomeInterface(container)) != null && businessInterface.getName().equals(localHome.getName());
    }

    public static String getHomeJndiName(Container container) {
        Advisor advisor = (Advisor)container;
        RemoteHomeBinding binding = (RemoteHomeBinding)advisor.resolveAnnotation(RemoteHomeBinding.class);
        if (binding != null) {
            return binding.jndiBinding();
        }
        return container.getEjbName() + "/home";
    }

    public static String getLocalHomeJndiName(Container container) {
        Advisor advisor = (Advisor)container;
        LocalHomeBinding binding = (LocalHomeBinding)advisor.resolveAnnotation(LocalHomeBinding.class);
        if (binding != null) {
            return binding.jndiBinding();
        }
        return container.getEjbName() + "/localHome";
    }

    public static String getJndiName(Container container, Class businessInterface) {
        Class localHome;
        Class remoteHome;
        if (!(container instanceof SessionContainer)) {
            return null;
        }
        Advisor advisor = (Advisor)container;
        Class<?>[] remotes = ProxyFactoryHelper.getRemoteInterfaces(container);
        if (remotes != null) {
            for (Class<?> clazz : remotes) {
                if (!clazz.getName().equals(businessInterface.getName())) continue;
                RemoteBindings bindings = ((EJBContainer)container).getRemoteBindings();
                return ProxyFactoryHelper.getRemoteJndiName(container, bindings.value()[0]);
            }
        }
        if ((remoteHome = ProxyFactoryHelper.getRemoteHomeInterface(container)) != null && businessInterface.getName().equals(remoteHome.getName())) {
            return ProxyFactoryHelper.getHomeJndiName(container);
        }
        Class<?>[] locals = ProxyFactoryHelper.getLocalInterfaces(container);
        if (locals != null) {
            for (Class<?> clazz : locals) {
                if (!clazz.getName().equals(businessInterface.getName())) continue;
                return ProxyFactoryHelper.getLocalJndiName(container);
            }
        }
        if ((localHome = ProxyFactoryHelper.getLocalHomeInterface(container)) != null && businessInterface.getName().equals(localHome.getName())) {
            return ProxyFactoryHelper.getLocalHomeJndiName(container);
        }
        return null;
    }

    public static String getLocalJndiName(Container container) {
        return ProxyFactoryHelper.getLocalJndiName(container, true);
    }

    public static String getLocalJndiName(Container container, boolean conflictCheck) {
        Advisor advisor = (Advisor)container;
        LocalBinding localBinding = (LocalBinding)advisor.resolveAnnotation(LocalBinding.class);
        if (localBinding == null) {
            String name = container.getEjbName() + "/local";
            DeploymentScope deploymentScope = ((EJBContainer)container).getDeployment().getEar();
            if (deploymentScope != null) {
                return deploymentScope.getBaseName() + "/" + name;
            }
            if (conflictCheck) {
                ProxyFactoryHelper.checkForRemoteJndiConflict(container);
            }
            return name;
        }
        return localBinding.jndiBinding();
    }

    private static void checkForRemoteJndiConflict(Container container) {
        String ejbName;
        String remoteJndiName;
        if (((Advisor)container).resolveAnnotation(Remote.class) != null && ((remoteJndiName = ProxyFactoryHelper.getRemoteJndiName(container, false)).equals(ejbName = container.getEjbName()) || remoteJndiName.startsWith(ejbName + "/")) && !remoteJndiName.equals(ejbName + "/remote")) {
            throw new EJBException("Conflict between default local jndi name " + ejbName + "/local and remote jndi name " + remoteJndiName + " for ejb-name:" + ejbName + ", bean class=" + container.getBeanClass());
        }
    }

    public static Class<?>[] getRemoteInterfaces(Container container) {
        Remote ri = (Remote)((Advisor)container).resolveAnnotation(Remote.class);
        if (ri == null) {
            Class beanClass = container.getBeanClass();
            Class[] intfs = ProxyFactoryHelper.getBusinessInterfaces(beanClass).toArray(new Class[0]);
            ArrayList<Class> remotes = new ArrayList<Class>();
            for (Class clazz : intfs) {
                if (!clazz.isAnnotationPresent(Remote.class)) continue;
                remotes.add(clazz);
            }
            if (remotes.size() > 0) {
                intfs = remotes.toArray(new Class[remotes.size()]);
                ri = new RemoteImpl(intfs);
                ((Advisor)container).getAnnotations().addClassAnnotation(Remote.class, (Object)ri);
                return ri.value();
            }
            return null;
        }
        if (ri.value().length > 0) {
            return ri.value();
        }
        List<Class<?>> list = ProxyFactoryHelper.getBusinessInterfaces(container.getBeanClass());
        if (list.size() == 0) {
            throw new RuntimeException("Use of empty @Remote on bean class and there are no valid business interfaces: " + container.getEjbName());
        }
        if (list.size() > 1) {
            throw new RuntimeException("Use of empty @Remote on bean class and there are more than one default interface: " + container.getEjbName());
        }
        Class[] rtn = new Class[]{list.get(0)};
        ri = new RemoteImpl(rtn);
        ((EJBContainer)container).getAnnotations().addClassAnnotation(Remote.class, (Object)ri);
        return rtn;
    }

    public static String getRemoteJndiName(Container container) {
        return ProxyFactoryHelper.getRemoteJndiName(container, true);
    }

    public static String getRemoteJndiName(Container container, boolean check) {
        RemoteBindings bindings;
        Advisor advisor = (Advisor)container;
        RemoteBinding binding = (RemoteBinding)advisor.resolveAnnotation(RemoteBinding.class);
        if (binding == null && (bindings = (RemoteBindings)advisor.resolveAnnotation(RemoteBindings.class)) != null) {
            binding = bindings.value()[0];
        }
        return ProxyFactoryHelper.getRemoteJndiName(container, binding);
    }

    private static void checkForLocalJndiConflict(Container container) {
        String ejbName;
        String localJndiName;
        if (((Advisor)container).resolveAnnotation(Local.class) != null && ((localJndiName = ProxyFactoryHelper.getLocalJndiName(container, false)).equals(ejbName = container.getEjbName()) || localJndiName.startsWith(ejbName + "/")) && !localJndiName.equals(ejbName + "/local")) {
            throw new EJBException("Conflict between default remote jndi name " + ejbName + "/remote and local jndi name " + localJndiName + " for ejb-name:" + ejbName + ", bean class=" + container.getBeanClass());
        }
    }

    public static String getRemoteJndiName(Container container, RemoteBinding binding) {
        return ProxyFactoryHelper.getRemoteJndiName(container, binding, true);
    }

    public static String getRemoteJndiName(Container container, RemoteBinding binding, boolean conflictCheck) {
        String jndiName = null;
        if (binding == null || binding.jndiBinding() == null || binding.jndiBinding().equals("")) {
            jndiName = ProxyFactoryHelper.getDefaultRemoteJndiName(container);
            if (conflictCheck) {
                ProxyFactoryHelper.checkForLocalJndiConflict(container);
            }
        } else {
            jndiName = binding.jndiBinding();
        }
        return jndiName;
    }

    public static String getDefaultRemoteJndiName(Container container) {
        String name = container.getEjbName() + "/remote";
        DeploymentScope deploymentScope = ((EJBContainer)container).getDeployment().getEar();
        if (deploymentScope != null) {
            return deploymentScope.getBaseName() + "/" + name;
        }
        return name;
    }

    public static String getClientBindUrl(RemoteBinding binding) throws Exception {
        String clientBindUrl = binding.clientBindUrl();
        if (clientBindUrl.trim().length() == 0) {
            ObjectName connectionON = new ObjectName("jboss.remoting:type=Connector,name=DefaultEjb3Connector,handler=ejb3");
            KernelAbstraction kernelAbstraction = KernelAbstractionFactory.getInstance();
            try {
                clientBindUrl = (String)kernelAbstraction.getAttribute(connectionON, "InvokerLocator");
            }
            catch (Exception e) {
                clientBindUrl = "socket://0.0.0.0:3873";
            }
        }
        return clientBindUrl;
    }
}

