/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.vm.factory;

import com.clustercontrol.repository.ejb.entity.FacilityData;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.vm.RepositoryActionInterface;
import com.clustercontrol.vm.VmException;
import com.clustercontrol.vm.bean.VmMethodTypeConstant;
import com.clustercontrol.vm.ejb.entity.VmMethodMstLocal;
import com.clustercontrol.vm.ejb.entity.VmMethodMstPK;
import com.clustercontrol.vm.ejb.entity.VmMethodMstUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VmNodeController {
    protected static Log m_log = LogFactory.getLog(VmNodeController.class);
    private HashMap<String, ArrayList<FacilityData>> guestMap = new HashMap();

    public ArrayList<FacilityData> getCurrentAllocationList(String hostId, String vmManagementIp, String user, String password, String protocol, String virtSolution, Locale locale) throws VmException {
        m_log.debug((Object)("getCurrentAllocationList() : start hostId = " + hostId + ", " + "vmManagementIp = " + vmManagementIp + ", " + "user = " + user + ", " + "password = " + password + ", " + "protocol = " + protocol + ", " + "virtSolution = " + virtSolution));
        ArrayList<FacilityData> guestList = this.guestMap.get(hostId);
        if (guestList == null) {
            m_log.debug((Object)("getCurrentAllocationList() : new list start hostId = " + hostId));
            String className = null;
            RepositoryActionInterface action = null;
            try {
                VmMethodMstLocal local;
                m_log.debug((Object)"getCurrentAllocationList() : get instance class name start");
                if (virtSolution != null && virtSolution.length() > 0) {
                    local = VmMethodMstUtil.getLocalHome().findByPrimaryKey(new VmMethodMstPK(virtSolution, VmMethodTypeConstant.REPOSITORY));
                    if (local == null) {
                        m_log.error((Object)("getCurrentAllocationList() : " + virtSolution + "\u306e\u5b9f\u884c\u30af\u30e9\u30b9\u304c\u5185\u90e8DB\u306b\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"));
                        throw new VmException(virtSolution + "\u306e\u5b9f\u884c\u30af\u30e9\u30b9\u304c\u5185\u90e8DB\u306b\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                    }
                } else {
                    m_log.error((Object)"getCurrentAllocationList() : \u4eee\u60f3\u5316\u30bd\u30ea\u30e5\u30fc\u30b7\u30e7\u30f3\u540d\u79f0\u304c\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                    throw new VmException("\u4eee\u60f3\u5316\u30bd\u30ea\u30e5\u30fc\u30b7\u30e7\u30f3\u540d\u79f0\u304c\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                }
                m_log.debug((Object)("getCurrentAllocationList() : className = " + className));
                className = local.getClassName();
            }
            catch (Exception e) {
                m_log.error((Object)"getCurrentAllocationList() : ", (Throwable)e);
                VmException ve = new VmException("\u5b9f\u884c\u30af\u30e9\u30b9\u304c\u5185\u90e8DB\u306b\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                ve.setStackTrace(e.getStackTrace());
                throw ve;
            }
            try {
                m_log.debug((Object)"getCurrentAllocationList() : new instance class start");
                action = (RepositoryActionInterface)Class.forName(className).newInstance();
                if (action == null) {
                    m_log.debug((Object)"getCurrentAllocationList() : action class is null");
                    throw new VmException(className + "\u30af\u30e9\u30b9\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                }
                m_log.debug((Object)("getCurrentAllocationList() : action class is = " + action.getClass().getCanonicalName()));
            }
            catch (InstantiationException e) {
                m_log.error((Object)"getCurrentAllocationList() : ", (Throwable)e);
                VmException ve = new VmException(className + "\u30af\u30e9\u30b9\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                ve.setStackTrace(e.getStackTrace());
                throw ve;
            }
            catch (IllegalAccessException e) {
                m_log.error((Object)"getCurrentAllocationList() : ", (Throwable)e);
                VmException ve = new VmException(className + "\u30af\u30e9\u30b9\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                ve.setStackTrace(e.getStackTrace());
                throw ve;
            }
            catch (ClassNotFoundException e) {
                m_log.error((Object)"getCurrentAllocationList() : ", (Throwable)e);
                VmException ve = new VmException(className + "\u30af\u30e9\u30b9\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                ve.setStackTrace(e.getStackTrace());
                throw ve;
            }
            catch (Exception e) {
                m_log.error((Object)"getCurrentAllocationList() : ", (Throwable)e);
                VmException ve = new VmException(className + "\u30af\u30e9\u30b9\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                ve.setStackTrace(e.getStackTrace());
                throw ve;
            }
            try {
                m_log.debug((Object)"getCurrentAllocationList() : run instance class start");
                guestList = action.getCurrentAllocationList(hostId, vmManagementIp, user, password, protocol);
            }
            catch (VmException e) {
                m_log.error((Object)"getCurrentAllocationList() : ", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                m_log.error((Object)"getCurrentAllocationList() : ", (Throwable)e);
                VmException ve = new VmException(className + "\u306e\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
                ve.setStackTrace(e.getStackTrace());
                throw ve;
            }
            for (FacilityData facilityData : guestList) {
                facilityData.setVirtSolution(virtSolution);
            }
            this.guestMap.put(hostId, guestList);
        } else {
            m_log.debug((Object)("getCurrentAllocationList() : list exist!! hostId = " + hostId));
        }
        m_log.debug((Object)("getCurrentAllocationList() : end hostId = " + hostId + ", " + "vmManagementIp = " + vmManagementIp + ", " + "user = " + user + ", " + "password = " + password + ", " + "protocol = " + protocol + ", " + "virtSolution = " + virtSolution));
        return guestList;
    }

    public boolean isAllocated(String guestId, String hostId, Locale locale) throws CreateException, NamingException, FinderException, VmException {
        m_log.debug((Object)("isAllocated() : start guestId = " + guestId + ", hostId = " + hostId));
        boolean ret = false;
        String vmName = null;
        String vmId = null;
        FacilityData hostData = null;
        String vmManagementIp = null;
        String user = null;
        String password = null;
        String protocol = null;
        String virtSolution = null;
        try {
            m_log.debug((Object)"isAllocated() : get guestId settings");
            RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
            ArrayList<String> attribute = new ArrayList<String>();
            attribute.add("ccVMName");
            attribute.add("ccVMId");
            HashMap map = repository.getNodeDetail(guestId, attribute);
            vmName = (String)map.get("ccVMName");
            vmId = (String)map.get("ccVMId");
            if (vmName == null || vmId == null) {
                return ret;
            }
            hostData = repository.getNodeFacilityData(hostId);
            virtSolution = hostData.getVirtSolution();
            user = hostData.getVmUser();
            password = hostData.getVmUserpassword();
            protocol = hostData.getVmProtocol();
            vmManagementIp = hostData.getIpProtocolNumber() == null ? hostData.getIpNetworkNumber() : (hostData.getIpProtocolNumber() == 4 ? hostData.getIpNetworkNumber() : hostData.getIpNetworkNumberV6());
            m_log.debug((Object)("isAllocated() : virtSolution = " + virtSolution));
            m_log.debug((Object)("isAllocated() : user = " + user));
            m_log.debug((Object)("isAllocated() : password = " + password));
            m_log.debug((Object)("isAllocated() : protocol = " + protocol));
            m_log.debug((Object)("isAllocated() : vmManagementIp = " + vmManagementIp));
        }
        catch (NamingException e) {
            m_log.error((Object)"isAllocated() : ", (Throwable)e);
            throw e;
        }
        catch (CreateException e) {
            m_log.error((Object)"isAllocated() : ", (Throwable)e);
            throw e;
        }
        catch (FinderException e) {
            m_log.error((Object)"isAllocated() : ", (Throwable)e);
            throw e;
        }
        m_log.debug((Object)"isAllocated() : getCurrentAllocationList start");
        ArrayList<FacilityData> guestList = this.getCurrentAllocationList(hostId, vmManagementIp, user, password, protocol, virtSolution, locale);
        m_log.debug((Object)"isAllocated() : check start");
        for (FacilityData guest : guestList) {
            if (vmName.equals(guest.getVmName()) && vmId.equals(guest.getVmId())) {
                m_log.debug((Object)("isAllocated() : match node!! vmName = " + guest.getVmName() + ", vmId = " + guest.getVmId()));
                ret = true;
                continue;
            }
            m_log.debug((Object)("isAllocated() : unmatch node!! vmName = " + guest.getVmName() + ", vmId = " + guest.getVmId()));
        }
        m_log.debug((Object)("isAllocated() : return = " + ret));
        return ret;
    }
}

