/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.vm.ejb.session;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.ViewListInfo;
import com.clustercontrol.repository.bean.VmNodeInfo;
import com.clustercontrol.vm.VmException;
import com.clustercontrol.vm.ejb.entity.VmOperationDetailData;
import com.clustercontrol.vm.factory.OperationRun;
import com.clustercontrol.vm.factory.SearchVmNode;
import com.clustercontrol.vm.factory.SelectVm;
import com.clustercontrol.vm.factory.UpdateVmNodeAllocation;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.jms.JMSException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VmControllerBean
implements SessionBean {
    protected static Log m_log = LogFactory.getLog(VmControllerBean.class);
    private SessionContext m_context;

    public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
        this.m_context = ctx;
    }

    public ViewListInfo getHistoryList(int histories) throws FinderException, NamingException {
        m_log.debug((Object)("getHistoryList() : start history = " + histories));
        ViewListInfo list = null;
        SelectVm select = new SelectVm();
        list = select.getHistoryList(histories);
        m_log.debug((Object)("getHistoryList() : end list.getTotal() = " + list.getTotal()));
        return list;
    }

    public void run(String commandId, String facilityId, Locale locale) throws CreateException, FinderException, NamingException, JMSException {
        String sessionId;
        m_log.debug((Object)("run() : start commandId = " + commandId + ", facilityId = " + facilityId + ", locale = " + locale.getDisplayName()));
        try {
            sessionId = this.createSession(commandId, facilityId, locale);
        }
        catch (CreateException e) {
            m_log.warn((Object)("run() CreateException : " + e.getMessage()), (Throwable)e);
            throw e;
        }
        catch (FinderException e) {
            m_log.warn((Object)("run() FinderException : " + e.getMessage()), (Throwable)e);
            throw e;
        }
        catch (NamingException e) {
            m_log.warn((Object)("run() NamingException : " + e.getMessage()), (Throwable)e);
            throw e;
        }
        m_log.debug((Object)("run : sessionId =" + sessionId));
        try {
            this.run(sessionId);
        }
        catch (JMSException e) {
            m_log.warn((Object)("run() JMSException : " + e.getMessage()), (Throwable)e);
            throw e;
        }
        m_log.debug((Object)("run() : end commandId = " + commandId + ", facilityId = " + facilityId + ", locale = " + locale.getDisplayName()));
    }

    private String createSession(String commandId, String facilityId, Locale locale) throws CreateException, FinderException, NamingException {
        OperationRun operation = new OperationRun();
        return operation.createSession(commandId, facilityId, locale);
    }

    private void run(String sessionId) throws FinderException, NamingException, JMSException {
        OperationRun operation = new OperationRun();
        operation.run(sessionId);
    }

    public void endNode(VmOperationDetailData data) throws FinderException, NamingException {
        OperationRun operation = new OperationRun();
        operation.endNode(data);
    }

    public ArrayList<VmNodeInfo> getVmNodeInfoList(Property property, Locale locale) throws FinderException, NamingException, CreateException, VmException {
        m_log.debug((Object)"getVmNodeInfoList() : start");
        SearchVmNode node = new SearchVmNode();
        return node.searchNode(property, locale);
    }

    public void updateVmNodeAllocation(Locale locale) throws FinderException, NamingException, CreateException, VmException {
        m_log.debug((Object)"updateVmNodeAllocation() : start");
        UpdateVmNodeAllocation allocation = new UpdateVmNodeAllocation();
        allocation.update(locale);
        m_log.debug((Object)"updateVmNodeAllocation() : end");
    }

    public void assignVmNode(HashMap<String, ArrayList<String>> newMap, HashMap<String, ArrayList<String>> releaseMap, Locale locale) throws VmException {
        m_log.debug((Object)"assignVmNode() : start");
        UpdateVmNodeAllocation allocation = new UpdateVmNodeAllocation();
        allocation.updateScope(newMap, releaseMap, locale);
        m_log.debug((Object)"assignVmNode() : end");
    }
}

