/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.resource.adapter.jdbc.BaseWrapperManagedConnection;
import org.jboss.resource.adapter.jdbc.WrappedCallableStatement;
import org.jboss.resource.adapter.jdbc.WrappedPreparedStatement;
import org.jboss.resource.adapter.jdbc.WrappedStatement;
import org.jboss.resource.adapter.jdbc.WrapperDataSource;
import org.jboss.util.NestedSQLException;

public class WrappedConnection
implements Connection {
    private static final Logger log = Logger.getLogger(WrappedConnection.class);
    private BaseWrapperManagedConnection mc;
    private WrapperDataSource dataSource;
    private HashMap statements;
    private boolean closed = false;
    private int trackStatements;

    public WrappedConnection(BaseWrapperManagedConnection mc) {
        this.mc = mc;
        if (mc != null) {
            this.trackStatements = mc.getTrackStatements();
        }
    }

    void setManagedConnection(BaseWrapperManagedConnection mc) {
        this.mc = mc;
        if (mc != null) {
            this.trackStatements = mc.getTrackStatements();
        }
    }

    public WrapperDataSource getDataSource() {
        return this.dataSource;
    }

    protected void setDataSource(WrapperDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkStatus();
        this.mc.setJdbcReadOnly(readOnly);
    }

    public boolean isReadOnly() throws SQLException {
        this.checkStatus();
        return this.mc.isJdbcReadOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        this.closed = true;
        if (this.mc != null) {
            if (this.trackStatements != 0) {
                WrappedConnection wrappedConnection = this;
                synchronized (wrappedConnection) {
                    if (this.statements != null) {
                        for (Map.Entry entry : this.statements.entrySet()) {
                            WrappedStatement ws = (WrappedStatement)entry.getKey();
                            if (this.trackStatements == 1) {
                                Throwable stackTrace = (Throwable)entry.getValue();
                                log.warn((Object)"Closing a statement you left open, please do your own housekeeping", stackTrace);
                            }
                            try {
                                ws.internalClose();
                            }
                            catch (Throwable t) {
                                log.warn((Object)"Exception trying to close statement:", t);
                            }
                        }
                    }
                }
            }
            this.mc.closeHandle(this);
        }
        this.mc = null;
        this.dataSource = null;
    }

    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    public Statement createStatement() throws SQLException {
        this.checkTransaction();
        try {
            return new WrappedStatement(this, this.mc.getConnection().createStatement());
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkTransaction();
        try {
            return new WrappedStatement(this, this.mc.getConnection().createStatement(resultSetType, resultSetConcurrency));
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkTransaction();
        try {
            return new WrappedStatement(this, this.mc.getConnection().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkTransaction();
        try {
            return new WrappedPreparedStatement(this, this.mc.prepareStatement(sql, 1003, 1007));
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkTransaction();
        try {
            return new WrappedPreparedStatement(this, this.mc.prepareStatement(sql, resultSetType, resultSetConcurrency));
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkTransaction();
        try {
            return new WrappedPreparedStatement(this, this.mc.getConnection().prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkTransaction();
        try {
            return new WrappedPreparedStatement(this, this.mc.getConnection().prepareStatement(sql, autoGeneratedKeys));
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkTransaction();
        try {
            return new WrappedPreparedStatement(this, this.mc.getConnection().prepareStatement(sql, columnIndexes));
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkTransaction();
        try {
            return new WrappedPreparedStatement(this, this.mc.getConnection().prepareStatement(sql, columnNames));
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkTransaction();
        try {
            return new WrappedCallableStatement(this, this.mc.prepareCall(sql, 1003, 1007));
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkTransaction();
        try {
            return new WrappedCallableStatement(this, this.mc.prepareCall(sql, resultSetType, resultSetConcurrency));
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkTransaction();
        try {
            return new WrappedCallableStatement(this, this.mc.getConnection().prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public String nativeSQL(String sql) throws SQLException {
        this.checkTransaction();
        try {
            return this.mc.getConnection().nativeSQL(sql);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void setAutoCommit(boolean autocommit) throws SQLException {
        this.checkStatus();
        this.mc.setJdbcAutoCommit(autocommit);
    }

    public boolean getAutoCommit() throws SQLException {
        this.checkStatus();
        return this.mc.isJdbcAutoCommit();
    }

    public void commit() throws SQLException {
        this.checkTransaction();
        this.mc.jdbcCommit();
    }

    public void rollback() throws SQLException {
        this.checkTransaction();
        this.mc.jdbcRollback();
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkTransaction();
        this.mc.jdbcRollback(savepoint);
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkTransaction();
        try {
            return this.mc.getConnection().getMetaData();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void setCatalog(String catalog) throws SQLException {
        this.checkTransaction();
        try {
            this.mc.getConnection().setCatalog(catalog);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public String getCatalog() throws SQLException {
        this.checkTransaction();
        try {
            return this.mc.getConnection().getCatalog();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void setTransactionIsolation(int isolationLevel) throws SQLException {
        this.checkStatus();
        this.mc.setJdbcTransactionIsolation(isolationLevel);
    }

    public int getTransactionIsolation() throws SQLException {
        this.checkStatus();
        return this.mc.getJdbcTransactionIsolation();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkTransaction();
        try {
            return this.mc.getConnection().getWarnings();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void clearWarnings() throws SQLException {
        this.checkTransaction();
        try {
            this.mc.getConnection().clearWarnings();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public Map getTypeMap() throws SQLException {
        this.checkTransaction();
        try {
            return this.mc.getConnection().getTypeMap();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void setTypeMap(Map typeMap) throws SQLException {
        this.checkTransaction();
        try {
            this.mc.getConnection().setTypeMap(typeMap);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void setHoldability(int holdability) throws SQLException {
        this.checkTransaction();
        try {
            this.mc.getConnection().setHoldability(holdability);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public int getHoldability() throws SQLException {
        this.checkTransaction();
        try {
            return this.mc.getConnection().getHoldability();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        this.checkTransaction();
        try {
            return this.mc.getConnection().setSavepoint();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkTransaction();
        try {
            return this.mc.getConnection().setSavepoint(name);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkTransaction();
        try {
            this.mc.getConnection().releaseSavepoint(savepoint);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public Connection getUnderlyingConnection() throws SQLException {
        this.checkTransaction();
        return this.mc.getConnection();
    }

    void checkTransaction() throws SQLException {
        this.checkStatus();
        this.mc.checkTransaction();
    }

    protected void checkStatus() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection handle has been closed and is unusable");
        }
        if (this.mc == null) {
            throw new SQLException("Connection handle is not currently associated with a ManagedConnection");
        }
    }

    protected SQLException checkException(Throwable t) throws SQLException {
        if (this.mc != null) {
            this.mc.connectionError(t);
        }
        if (t instanceof SQLException) {
            throw (SQLException)t;
        }
        throw new NestedSQLException("Error", t);
    }

    int getTrackStatements() {
        return this.trackStatements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerStatement(WrappedStatement ws) {
        if (this.trackStatements == 0) {
            return;
        }
        WrappedConnection wrappedConnection = this;
        synchronized (wrappedConnection) {
            if (this.statements == null) {
                this.statements = new HashMap();
            }
            if (this.trackStatements == 1) {
                this.statements.put(ws, new Throwable("STACKTRACE"));
            } else {
                this.statements.put(ws, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterStatement(WrappedStatement ws) {
        if (this.trackStatements == 0) {
            return;
        }
        WrappedConnection wrappedConnection = this;
        synchronized (wrappedConnection) {
            if (this.statements != null) {
                this.statements.remove(ws);
            }
        }
    }

    void checkConfiguredQueryTimeout(WrappedStatement ws) throws SQLException {
        if (this.mc == null || this.dataSource == null) {
            return;
        }
        int timeout = 0;
        if (this.mc.isTransactionQueryTimeout()) {
            timeout = this.dataSource.getTimeLeftBeforeTransactionTimeout();
        }
        if (timeout <= 0) {
            timeout = this.mc.getQueryTimeout();
        }
        if (timeout > 0) {
            ws.setQueryTimeout(timeout);
        }
    }

    Logger getLogger() {
        return log;
    }
}

