/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.poller.impl;

import com.clustercontrol.sharedtable.DataTable;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMNameSpace;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMTransportException;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.cim.UnsignedInt16;
import org.sblim.wbem.cim.UnsignedInt32;
import org.sblim.wbem.cim.UnsignedInt64;
import org.sblim.wbem.cim.UnsignedInt8;
import org.sblim.wbem.client.CIMClient;
import org.sblim.wbem.client.PasswordCredential;
import org.sblim.wbem.client.UserPrincipal;
import org.sblim.wbem.util.SessionProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WbemPollerImpl {
    protected static Log m_log = LogFactory.getLog(WbemPollerImpl.class);
    private String m_ipAddress;
    private String[] m_cimText;
    private DataTable m_dataTable;
    private String m_cimAgentAddress = null;
    private String m_nameSpace = "root/cimv2";
    private HashMap<String, CIMValue> m_retMap = new HashMap();

    private void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void polling(InetAddress ipAddress, int port, String protocol, String user, String password, String nameSpace, int retries, int timeout, List<String> cimList, DataTable table) {
        this.init();
        this.m_dataTable = table;
        this.m_ipAddress = ipAddress.getHostAddress();
        this.m_cimAgentAddress = protocol + "://" + this.m_ipAddress + ":" + port;
        if (nameSpace != null) {
            this.m_nameSpace = nameSpace;
        }
        if (m_log.isDebugEnabled()) {
            m_log.debug((Object)("polling() start : " + this.m_ipAddress.toString()));
            m_log.debug((Object)("Port            : " + port));
            m_log.debug((Object)("Protocol        : " + protocol));
            m_log.debug((Object)("User            : " + user));
            m_log.debug((Object)("Password        : " + password));
            m_log.debug((Object)("Retries         : " + retries));
            m_log.debug((Object)("Timeout         : " + timeout));
        }
        long enumerationStart = System.currentTimeMillis();
        CIMClient cimClient = null;
        try {
            UserPrincipal userPr = new UserPrincipal(user);
            PasswordCredential pwCred = new PasswordCredential(password);
            CIMNameSpace ns = new CIMNameSpace(this.m_cimAgentAddress, this.m_nameSpace);
            cimClient = new CIMClient(ns, (Principal)userPr, (Object)pwCred);
            SessionProperties properties = cimClient.getSessionProperties();
            if (properties == null) {
                properties = new SessionProperties();
                cimClient.setSessionProperties(properties);
            }
            properties.setHttpTimeOut(timeout);
            this.m_cimText = new String[cimList.size()];
            HashMap<String, ArrayList> requestMap = new HashMap<String, ArrayList>();
            Iterator<String> itr = cimList.iterator();
            String[] targetValue = new String[2];
            String cimClass = "";
            String cimProperty2 = "";
            ArrayList propertyList = null;
            int i = 0;
            while (itr.hasNext()) {
                this.m_cimText[i] = itr.next();
                targetValue = this.m_cimText[i].split("\\.");
                cimClass = targetValue[0];
                cimProperty2 = targetValue[1];
                propertyList = (ArrayList)requestMap.get(cimClass);
                if (propertyList != null && propertyList.size() != 0) {
                    propertyList.add(cimProperty2);
                } else {
                    propertyList = new ArrayList();
                    propertyList.add(cimProperty2);
                    requestMap.put(cimClass, propertyList);
                }
                ++i;
            }
            CIMObjectPath cop = null;
            CIMInstance ci = null;
            CIMValue value = null;
            Enumeration enm = null;
            Iterator itr2 = null;
            block19: for (int j = 0; j < retries; ++j) {
                boolean errorFlg = false;
                try {
                    try {
                        Set keySet = requestMap.keySet();
                        itr = keySet.iterator();
                        block20: while (true) {
                            if (!itr.hasNext()) {
                                if (errorFlg) continue block19;
                            }
                            cimClass = itr.next();
                            propertyList = (ArrayList)requestMap.get(cimClass);
                            m_log.debug((Object)("CIMClass : " + cimClass));
                            cop = new CIMObjectPath(cimClass);
                            enm = cimClient.enumInstances(cop, true);
                            i = 0;
                            while (true) {
                                if (!enm.hasMoreElements()) continue block20;
                                ci = (CIMInstance)enm.nextElement();
                                for (String cimProperty2 : propertyList) {
                                    if (ci.getProperty(cimProperty2) == null) continue;
                                    value = ci.getProperty(cimProperty2).getValue();
                                    this.m_retMap.put(cimClass + "." + cimProperty2 + "." + i, value);
                                }
                                ++i;
                            }
                            break;
                        }
                    }
                    catch (CIMTransportException e) {
                        errorFlg = true;
                        m_log.warn((Object)("polling() warning :" + this.m_ipAddress.toString() + " " + e.getID()));
                        if (errorFlg) continue;
                    }
                    catch (Exception e) {
                        errorFlg = true;
                        m_log.warn((Object)("polling() warning :" + this.m_ipAddress.toString() + " unforeseen error"));
                        if (errorFlg) continue;
                    }
                    break;
                }
                catch (Throwable throwable) {
                    if (errorFlg) {
                        throw throwable;
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            m_log.warn((Object)("polling() warning :" + this.m_ipAddress.toString() + " unforeseen error"));
        }
        finally {
            if (cimClient != null) {
                try {
                    cimClient.close();
                }
                catch (Exception e) {
                    m_log.warn((Object)("polling():" + this.m_ipAddress.toString() + " Session close failed"));
                }
            }
        }
        long enumerationStop = System.currentTimeMillis();
        if (m_log.isDebugEnabled()) {
            m_log.debug((Object)("polling() end : time : " + (enumerationStop - enumerationStart)));
        }
        try {
            if (this.m_retMap == null || this.m_retMap.size() == 0) {
                m_log.debug((Object)("wbemReceived() : " + this.m_ipAddress.toString() + " result is empty"));
                return;
            }
            long time = System.currentTimeMillis();
            Set<String> keySet = this.m_retMap.keySet();
            for (String cimString : keySet) {
                CIMValue value = this.m_retMap.get(cimString);
                if (value.getType().getType() == 0) {
                    long ret = ((UnsignedInt8)value.getValue()).longValue();
                    this.m_dataTable.putValue(this.getEntryKey(cimString), time, ret);
                    m_log.debug((Object)("polling() dataTable put : entryKey : " + this.getEntryKey(cimString) + ", time : " + time + ", value : " + ret));
                    continue;
                }
                if (value.getType().getType() == 2) {
                    long ret = ((UnsignedInt16)value.getValue()).longValue();
                    this.m_dataTable.putValue(this.getEntryKey(cimString), time, ret);
                    m_log.debug((Object)("polling() dataTable put : entryKey : " + this.getEntryKey(cimString) + ", time : " + time + ", value : " + ret));
                    continue;
                }
                if (value.getType().getType() == 4) {
                    long ret = ((UnsignedInt32)value.getValue()).longValue();
                    this.m_dataTable.putValue(this.getEntryKey(cimString), time, ret);
                    m_log.debug((Object)("polling() dataTable put : entryKey : " + this.getEntryKey(cimString) + ", time : " + time + ", value : " + ret));
                    continue;
                }
                if (value.getType().getType() == 6) {
                    BigInteger bigInt = ((UnsignedInt64)value.getValue()).bigIntValue();
                    long ret = bigInt.longValue();
                    this.m_dataTable.putValue(this.getEntryKey(cimString), time, ret);
                    m_log.debug((Object)("polling() dataTable put : entryKey : " + this.getEntryKey(cimString) + ", time : " + time + ", value : " + ret));
                    continue;
                }
                if (value.getType().getType() == 8) {
                    String ret = (String)value.getValue();
                    this.m_dataTable.putValue(this.getEntryKey(cimString), time, ret);
                    m_log.debug((Object)("polling() dataTable put : entryKey : " + this.getEntryKey(cimString) + ", time : " + time + ", value : " + ret));
                    continue;
                }
                if (value.getType().getType() == 24) {
                    Vector ret = (Vector)value.getValue();
                    this.m_dataTable.putValue(this.getEntryKey(cimString), time, ret);
                    m_log.debug((Object)("polling() dataTable put : entryKey : " + this.getEntryKey(cimString) + ", time : " + time + ", value : " + ret));
                    continue;
                }
                m_log.debug((Object)"polling() data type is nothing");
            }
            return;
        }
        catch (Exception e) {
            m_log.error((Object)"InternalError ", (Throwable)e);
            this.m_dataTable.clear();
        }
    }

    private String getEntryKey(String cimString) {
        return "WBEM." + cimString;
    }

    public static void main(String[] args) {
        WbemPollerImpl poller = new WbemPollerImpl();
        InetAddress ipAddress = null;
        try {
            ipAddress = InetAddress.getByName(args[0]);
        }
        catch (UnknownHostException e) {
            m_log.error((Object)e, (Throwable)e);
            return;
        }
        int port = Integer.parseInt(args[1]);
        String protocol = args[2];
        String user = args[3];
        String password = args[4];
        String nameSpace = args[5];
        int retries = Integer.parseInt(args[6]);
        int timeout = Integer.parseInt(args[7]);
        ArrayList<String> cims = new ArrayList<String>();
        for (int i = 9; i < args.length; ++i) {
            cims.add(args[i]);
        }
        DataTable dataTable = new DataTable();
        poller.polling(ipAddress, port, protocol, user, password, nameSpace, retries, timeout, cims, dataTable);
    }
}

