/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.poller;

import com.clustercontrol.bean.SnmpVersionConstant;
import com.clustercontrol.poller.FacilityNotFoundException;
import com.clustercontrol.poller.NotInitializedException;
import com.clustercontrol.poller.PollingController;
import com.clustercontrol.poller.cfg.PollerConfig;
import com.clustercontrol.poller.cfg.SnmpPollerConfig;
import com.clustercontrol.poller.cfg.VmPollerConfig;
import com.clustercontrol.poller.cfg.WbemPollerConfig;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.sharedtable.DataTableNotFoundException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.naming.NameNotFoundException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PollerManager {
    private static Log m_log = LogFactory.getLog(PollerManager.class);
    private String m_quartzJndiName = "QuartzRAM";
    private String m_managerName;
    private ConcurrentHashMap<PollerInfo, PollingController> m_pollerTable;

    public PollerManager(String managerName) {
        this.m_managerName = managerName;
        this.m_pollerTable = new ConcurrentHashMap();
    }

    public PollingController createPoller(String group, String facilityId, boolean indexCheckFlg, String tableGroup, String tableName) throws NotInitializedException, DataTableNotFoundException, FacilityNotFoundException {
        if (m_log.isDebugEnabled()) {
            m_log.debug((Object)("create poller    PollerGroup : " + group + ", " + "FacilityId : " + facilityId + ", " + "IndexCheckFlg : " + indexCheckFlg + ", " + "TableGroup : " + tableGroup + ", " + "TableName : " + tableName));
        }
        PollerConfig pollerConfig = this.createPollerConfig(facilityId);
        PollingController poller = new PollingController(group, facilityId, pollerConfig, indexCheckFlg, tableGroup, tableName);
        poller.setQuartzJndiName(this.m_quartzJndiName);
        this.m_pollerTable.put(new PollerInfo(group, facilityId), poller);
        return poller;
    }

    public void removePoller(String group, String facilityId) {
        PollerInfo info = new PollerInfo(group, facilityId);
        PollingController poller = this.m_pollerTable.get(info);
        if (poller != null) {
            poller.stopPollingAll();
        }
        this.m_pollerTable.remove(new PollerInfo(group, facilityId));
    }

    private PollerConfig createPollerConfig(String facilityId) throws FacilityNotFoundException {
        m_log.debug((Object)("createPollerConfig() start " + facilityId));
        try {
            Integer timeout;
            RepositoryControllerLocal bean = RepositoryControllerUtil.getLocalHome().create();
            ArrayList<String> attributes = new ArrayList<String>();
            attributes.add("ipProtocolNumber");
            attributes.add("ipNetworkNumber");
            attributes.add("ccIpNetworkNumberV6");
            attributes.add("ccModifyTimestamp");
            attributes.add("ccSnmpCommunity");
            attributes.add("ccSnmpPort");
            attributes.add("ccSnmpVersion");
            attributes.add("ccSnmpTimeout");
            attributes.add("ccSnmpRetries");
            attributes.add("ccWbemUser");
            attributes.add("ccWbemUserPassword");
            attributes.add("ccWbemPort");
            attributes.add("ccWbemProtocol");
            attributes.add("ccWbemTimeout");
            attributes.add("ccWbemRetries");
            attributes.add("ccVMName");
            attributes.add("ccVMUser");
            attributes.add("ccVMUserPassword");
            attributes.add("ccVMProtocol");
            attributes.add("ccVirtualizationNodeType");
            attributes.add("ccVMManagementNode");
            HashMap nodeInfo = bean.getNodeDetail(facilityId, attributes);
            bean.remove();
            Integer ipProtNum = (Integer)nodeInfo.get("ipProtocolNumber");
            String ipAddress = null;
            ipAddress = ipProtNum != null && ipProtNum == 6 ? (String)nodeInfo.get("ccIpNetworkNumberV6") : (String)nodeInfo.get("ipNetworkNumber");
            PollerConfig pollerConfig = new PollerConfig(InetAddress.getByName(ipAddress));
            SnmpPollerConfig snmpConfig = pollerConfig.getSnmpConfig();
            String community = (String)nodeInfo.get("ccSnmpCommunity");
            m_log.debug((Object)("community : " + community));
            if (community != null) {
                snmpConfig.setComunity(community);
            }
            Integer port = (Integer)nodeInfo.get("ccSnmpPort");
            m_log.debug((Object)("port      : " + port));
            if (port != null) {
                snmpConfig.setPort(port);
            }
            String versionStr = (String)nodeInfo.get("ccSnmpVersion");
            m_log.debug((Object)("version   : " + versionStr));
            if (versionStr != null && versionStr != "") {
                Integer version = SnmpVersionConstant.stringToType((String)versionStr);
                if (versionStr != null) {
                    if (version == -1) {
                        version = 1;
                    }
                    snmpConfig.setVersion(version);
                }
            }
            if ((timeout = (Integer)nodeInfo.get("ccSnmpTimeout")) != null) {
                m_log.debug((Object)("timeout   : " + timeout));
                snmpConfig.setTimeout(timeout);
            }
            Integer retries = (Integer)nodeInfo.get("ccSnmpRetries");
            m_log.debug((Object)("retries   : " + retries));
            if (retries != null) {
                snmpConfig.setRetries(retries);
            }
            WbemPollerConfig wbemConfig = pollerConfig.getWbemConfig();
            String wbemUser = (String)nodeInfo.get("ccWbemUser");
            m_log.debug((Object)("wbemuser : " + wbemUser));
            if (wbemUser != null && !wbemUser.equals("")) {
                wbemConfig.setUserName(wbemUser);
            }
            String wbemPassword = (String)nodeInfo.get("ccWbemUserPassword");
            m_log.debug((Object)("wbempassword : " + wbemPassword));
            if (wbemPassword != null && !wbemPassword.equals("")) {
                wbemConfig.setPassword(wbemPassword);
            }
            Integer wbemPort = (Integer)nodeInfo.get("ccWbemPort");
            m_log.debug((Object)("wbemport : " + wbemPort));
            if (wbemPort != null) {
                wbemConfig.setPort(wbemPort);
            }
            String wbemProtocol = (String)nodeInfo.get("ccWbemProtocol");
            m_log.debug((Object)("wbemprotocol : " + wbemProtocol));
            if (wbemProtocol != null && !wbemProtocol.equals("")) {
                wbemConfig.setProtocol(wbemProtocol);
            }
            Integer wbemTimeout = (Integer)nodeInfo.get("ccWbemTimeout");
            m_log.debug((Object)("wbemtimeout : " + wbemTimeout));
            if (wbemTimeout != null) {
                wbemConfig.setTimeout(wbemTimeout);
            }
            Integer wbemRetries = (Integer)nodeInfo.get("ccWbemRetries");
            m_log.debug((Object)("wbemretries : " + wbemRetries));
            if (wbemRetries != null) {
                wbemConfig.setRetries(wbemRetries);
            }
            VmPollerConfig vmConfig = pollerConfig.getVmConfig();
            String vmName = (String)nodeInfo.get("ccVMName");
            m_log.debug((Object)("vmname : " + vmName));
            if (vmName != null) {
                vmConfig.setVmName(vmName);
            }
            String vmNodeType = (String)nodeInfo.get("ccVirtualizationNodeType");
            m_log.debug((Object)("vmNodeType : " + vmNodeType));
            if (vmNodeType != null) {
                vmConfig.setVmNodeType(vmNodeType);
            }
            String vmManagementNode = null;
            if (vmNodeType != null) {
                if (vmNodeType.equals("host")) {
                    vmManagementNode = facilityId;
                } else if (vmNodeType.equals("guest")) {
                    vmManagementNode = (String)nodeInfo.get("ccVMManagementNode");
                }
            }
            if (vmManagementNode != null) {
                HashMap vmManagementNodeInfo = bean.getNodeDetail(vmManagementNode, attributes);
                bean.remove();
                String vmManagementNodeIp = null;
                Integer ipProtNumHost = (Integer)vmManagementNodeInfo.get("ipProtocolNumber");
                vmManagementNodeIp = ipProtNumHost != null && ipProtNumHost == 6 ? (String)vmManagementNodeInfo.get("ccIpNetworkNumberV6") : (String)vmManagementNodeInfo.get("ipNetworkNumber");
                if (vmManagementNodeIp != null) {
                    vmConfig.setVmManagementNodeIp(vmManagementNodeIp);
                }
                String vmUser = (String)vmManagementNodeInfo.get("ccVMUser");
                m_log.debug((Object)("vmUser : " + vmUser));
                if (vmUser != null) {
                    vmConfig.setVmUser(vmUser);
                }
                String vmUserPassword = (String)vmManagementNodeInfo.get("ccVMUserPassword");
                m_log.debug((Object)("vmUserPassword : " + vmUserPassword));
                if (vmUserPassword != null) {
                    vmConfig.setVmUserPassword(vmUserPassword);
                }
                String vmProtocol = (String)vmManagementNodeInfo.get("ccVMProtocol");
                m_log.debug((Object)("vmProtocol : " + vmProtocol));
                if (vmProtocol != null) {
                    vmConfig.setVmProtocol(vmProtocol);
                }
            }
            m_log.debug((Object)("createPollerConfig() end " + facilityId));
            return pollerConfig;
        }
        catch (FinderException e) {
            throw new FacilityNotFoundException(facilityId);
        }
        catch (EJBException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
            if (e.getCausedByException() instanceof NameNotFoundException) {
                throw new FacilityNotFoundException(facilityId);
            }
            throw e;
        }
        catch (Exception e) {
            String message = "Couldn't get Poller Config : " + facilityId;
            throw new EJBException(message);
        }
    }

    public void refreshSnmpConfig() {
        for (PollerInfo key : this.m_pollerTable.keySet()) {
            PollerConfig config;
            String facilityId = key.getPollerName();
            try {
                config = this.createPollerConfig(facilityId);
            }
            catch (FacilityNotFoundException e) {
                m_log.error((Object)e.getMessage(), (Throwable)e);
                continue;
            }
            this.m_pollerTable.get(key).getPollingConfig().setPollerConfig(config);
        }
    }

    public PollingController getPoller(String pollerGroup, String pollerName) {
        return this.m_pollerTable.get(new PollerInfo(pollerGroup, pollerName));
    }

    public String getManagerName() {
        return this.m_managerName;
    }

    public String getQuartzJndiName() {
        return this.m_quartzJndiName;
    }

    public void setQuartzJndiName(String jndiName) {
        this.m_quartzJndiName = jndiName;
    }

    public String getPollerDebugInfo() {
        String debugStr = "";
        for (PollerInfo info : this.m_pollerTable.keySet()) {
            int minInterval = this.m_pollerTable.get(info).getPollingConfig().getMinPollingInterval();
            debugStr = debugStr + info.getPollerGroup() + ", " + info.getPollerName() + ", " + minInterval + "\n";
            debugStr = debugStr + this.m_pollerTable.get(info).getPollingConfig().getDebugInfo();
        }
        return debugStr;
    }

    private class PollerInfo {
        private String m_pollerGroup;
        private String m_pollerName;

        public PollerInfo(String pollerGroup, String pollerName) {
            this.m_pollerGroup = pollerGroup;
            this.m_pollerName = pollerName;
        }

        public String getPollerGroup() {
            return this.m_pollerGroup;
        }

        public String getPollerName() {
            return this.m_pollerName;
        }

        public boolean equals(Object other) {
            if (other instanceof PollerInfo) {
                PollerInfo info = (PollerInfo)other;
                if (this.m_pollerGroup == null && this.m_pollerName == null) {
                    if (info.m_pollerGroup == null && info.m_pollerName == null) {
                        return true;
                    }
                } else if (this.m_pollerGroup == null && this.m_pollerName != null) {
                    if (info.m_pollerGroup == null && this.m_pollerName.equals(info.m_pollerName)) {
                        return true;
                    }
                } else if (this.m_pollerGroup != null && this.m_pollerName == null) {
                    if (this.m_pollerGroup.equals(info.m_pollerGroup) && info.m_pollerName == null) {
                        return true;
                    }
                } else if (this.m_pollerGroup.equals(info.m_pollerGroup)) {
                    return this.m_pollerName.equals(info.m_pollerName);
                }
                return false;
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + (this.m_pollerGroup != null ? this.m_pollerGroup.hashCode() : 0);
            result = 37 * result + (this.m_pollerName != null ? this.m_pollerName.hashCode() : 0);
            return result;
        }
    }
}

