/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.factory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.notify.ejb.entity.NotifyRelationInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyRelationInfoUtil;
import com.clustercontrol.util.apllog.AplLogger;
import java.util.Collection;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeleteNotifyRelation {
    protected static Log m_log = LogFactory.getLog(DeleteNotifyRelation.class);

    public boolean delete(String notifyGroupId) throws FinderException, RemoveException, NamingException {
        AccessLock.lock((String)"NOTIFY");
        try {
            Collection notifies = NotifyRelationInfoUtil.getLocalHome().findByNotifyGroupId(notifyGroupId);
            for (NotifyRelationInfoLocal detail : notifies) {
                detail.remove();
            }
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            m_log.debug((Object)("delete():" + e.getMessage()));
            throw e;
        }
        catch (RemoveException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            m_log.debug((Object)("delete():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            m_log.debug((Object)("delete():" + e.getMessage()));
            throw e;
        }
        return true;
    }

    public boolean deleteBaseOnNotifyId(String notifyId) {
        AccessLock.lock((String)"NOTIFY");
        try {
            Collection ct = NotifyRelationInfoUtil.getLocalHome().findByNotifyId(notifyId);
            if (ct.size() != 0) {
                // empty if block
            }
            for (NotifyRelationInfoLocal relation : ct) {
                relation.remove();
            }
        }
        catch (RemoveException e) {
            m_log.debug((Object)("deleteBaseOnNotifyId():" + e.getMessage()), (Throwable)e);
        }
        catch (FinderException e) {
            m_log.debug((Object)("deleteBaseOnNotifyId():" + e.getMessage()), (Throwable)e);
        }
        catch (NamingException e) {
            m_log.debug((Object)("deleteBaseOnNotifyId():" + e.getMessage()), (Throwable)e);
        }
        return true;
    }
}

