/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.SequencedHashMap;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.tuple.Tuplizer;

public abstract class EntityModeToTuplizerMapping
implements Serializable {
    private final Map tuplizers = Collections.synchronizedMap(new SequencedHashMap());

    protected void addTuplizer(EntityMode entityMode, Tuplizer tuplizer) {
        this.tuplizers.put(entityMode, tuplizer);
    }

    public EntityMode guessEntityMode(Object object) {
        Iterator itr = this.tuplizers.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            Tuplizer tuplizer = (Tuplizer)entry.getValue();
            if (!tuplizer.isInstance(object)) continue;
            return (EntityMode)entry.getKey();
        }
        return null;
    }

    public Tuplizer getTuplizerOrNull(EntityMode entityMode) {
        return (Tuplizer)this.tuplizers.get(entityMode);
    }

    public Tuplizer getTuplizer(EntityMode entityMode) {
        Tuplizer tuplizer = this.getTuplizerOrNull(entityMode);
        if (tuplizer == null) {
            throw new HibernateException("No tuplizer found for entity-mode [" + entityMode + "]");
        }
        return tuplizer;
    }
}

