/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.jmx;

import com.clustercontrol.performance.bean.QuartzConstant;
import com.clustercontrol.performance.jmx.PerformanceRestartManager;
import com.clustercontrol.performance.jmx.PerformanceServiceMBean;
import com.clustercontrol.performance.jmx.ReceiveRepositoryTopic;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import org.jboss.naming.NonSerializableFactory;
import org.jboss.system.ServiceMBeanSupport;

public class PerformanceService
extends ServiceMBeanSupport
implements PerformanceServiceMBean {
    private String jndiName = "PerformanceService";
    private PerformanceRestartManager manager;
    private ReceiveRepositoryTopic m_receiveRepositoryTopic;

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) throws NamingException {
        this.log.info((Object)("setJndiName() SnmpService : " + jndiName));
        String oldName = this.jndiName;
        this.jndiName = jndiName;
        if (super.getState() == 3) {
            NamingException ne;
            try {
                this.unbind(oldName);
            }
            catch (NamingException e) {
                ne = new NamingException("Failed to unbind");
                ne.setRootCause(e);
                this.log.error((Object)ne);
            }
            try {
                this.rebind();
            }
            catch (NamingException e) {
                ne = new NamingException("Failed to rebind");
                ne.setRootCause(e);
                this.log.error((Object)ne);
            }
        }
    }

    public String getName() {
        return "PerformanceService(" + this.jndiName + ")";
    }

    public void restartCollector() {
        this.manager.restartAll();
    }

    public void createService() {
        this.log.info((Object)("Create PerformanceService(" + this.jndiName + ")"));
        this.manager = new PerformanceRestartManager();
        this.log.info((Object)("Created PerformanceService(" + this.jndiName + ")"));
    }

    public void startService() throws NamingException {
        this.log.info((Object)("Start PerformanceService(" + this.jndiName + ")"));
        this.manager.restartAll();
        this.m_receiveRepositoryTopic = new ReceiveRepositoryTopic(this.manager);
        this.rebind();
        this.log.info((Object)("Started PerformanceService(" + this.jndiName + ")"));
    }

    public void stopService() throws NamingException {
        this.log.info((Object)("Stop PerformanceService(" + this.jndiName + ")"));
        this.unbind(this.jndiName);
        this.m_receiveRepositoryTopic.terminate();
        this.log.info((Object)("Stoped PerformanceService(" + this.jndiName + ")"));
    }

    public void destroyService() throws Exception {
        this.log.info((Object)("Destroy PerformanceService(" + this.jndiName + ")"));
        this.manager = null;
        this.log.info((Object)("Destroyed PerformanceService(" + this.jndiName + ")"));
    }

    private static Context createContext(Context rootCtx, Name name) throws NamingException {
        Context subctx = rootCtx;
        for (int n = 0; n < name.size(); ++n) {
            String atom = name.get(n);
            try {
                Object obj = subctx.lookup(atom);
                subctx = (Context)obj;
                continue;
            }
            catch (NamingException e) {
                subctx = subctx.createSubcontext(atom);
            }
        }
        return subctx;
    }

    private void rebind() throws NamingException {
        Name fullName;
        InitialContext rootCtx = new InitialContext();
        Name parentName = fullName = rootCtx.getNameParser("").parse(this.jndiName);
        parentName = fullName.size() > 1 ? fullName.getPrefix(fullName.size() - 1) : new CompositeName();
        Context parentCtx = PerformanceService.createContext(rootCtx, parentName);
        Name atomName = fullName.getSuffix(fullName.size() - 1);
        String atomStirng = atomName.get(0);
        NonSerializableFactory.rebind((Context)parentCtx, (String)atomStirng, (Object)this.manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbind(String jndiName) throws NamingException {
        InitialContext rootCtx = null;
        try {
            rootCtx = new InitialContext();
            Name fullName = rootCtx.getNameParser("").parse(jndiName);
            Name atomName = fullName.getSuffix(fullName.size() - 1);
            String atom = atomName.get(0);
            rootCtx.unbind(jndiName);
            NonSerializableFactory.unbind((String)atom);
        }
        finally {
            if (rootCtx != null) {
                rootCtx.close();
            }
        }
    }

    public String getQuartzName() {
        return QuartzConstant.getQuartzName();
    }

    public void setQuartzName(String quartzName) {
        QuartzConstant.setQuartzName((String)quartzName);
    }

    public int getDelayTimeUnder1min() {
        return QuartzConstant.getDelayTimeUnder1min();
    }

    public void setDelayTimeUnder1min(int delayTimeUnder1min) {
        QuartzConstant.setDelayTimeUnder1min((int)delayTimeUnder1min);
    }

    public int getDelayTimeOver1min() {
        return QuartzConstant.getDelayTimeOver1min();
    }

    public void setDelayTimeOver1min(int delayTimeOver1min) {
        QuartzConstant.setDelayTimeOver1min((int)delayTimeOver1min);
    }
}

