/*
                                                                                                
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
*/

package com.clustercontrol.sharedtable.job;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

import com.clustercontrol.sharedtable.SharedTable;


/**
 * 参照されていないテーブルを調べるクラス（Quartzに登録します）
 * 
 * @version 3.0.0
 * @since 2.0.0
 */
public class CheckJob implements Job{
	protected static Log m_log = LogFactory.getLog( CheckJob.class );

	/**
	 * Qurtzからコールバックされるメソッド
	 * 参照されていないテーブルを調べ、ポーリングの設定を変更します。
	 * またリポジトリを参照しテーブルが保持しているIPアドレス情報が変更されていなか確認します。
	 */
	public void execute(JobExecutionContext context) throws JobExecutionException {	
		// デバッグログ出力
		m_log.debug("Check Job Execute : start.");
		
		// 引数を取得します
		JobDataMap dataMap = context.getJobDetail().getJobDataMap();
		String jndiName    = dataMap.getString("jndiName");
		
		// 共有テーブルを取得する
		try {
			InitialContext ctx = new InitialContext();
			
			Object obj = ctx.lookup(jndiName);
			SharedTable sharedTable = 
				(SharedTable)PortableRemoteObject.narrow(obj, SharedTable.class);
			
			// 不要なテーブルを削除
			sharedTable.checkUnnecessaryTable();
		} catch (NamingException e) {
			m_log.error(e.getMessage(), e);
		}
		
		// デバッグログ出力
		m_log.debug("Check Job Execute : end.");
	}
}
