/*
                                                                                                
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
*/

package com.clustercontrol.performance.monitor.factory;

import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.SchedulerException;

import com.clustercontrol.notify.ejb.session.NotifyControllerLocal;
import com.clustercontrol.notify.ejb.session.NotifyControllerUtil;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoUtil;
import com.clustercontrol.monitor.run.factory.AddMonitorNumericValueType;
import com.clustercontrol.performance.monitor.bean.MonitorPerfCheckInfo;
import com.clustercontrol.performance.bean.CollectorItemInfo;
import com.clustercontrol.performance.ejb.bmp.CollectorUtil;
import com.clustercontrol.performance.monitor.ejb.entity.MonitorPerfInfoUtil;
import com.clustercontrol.performance.monitor.ejb.session.MonitorPerfRunManagementHome;
import com.clustercontrol.performance.util.Repository;
import com.clustercontrol.util.apllog.AplLogger;


/**
 * リソース監視情報登録クラス
 *
 * @version 3.0.0
 * @since 2.0.0
 */
public class AddMonitorPerformance extends AddMonitorNumericValueType{
	
	protected static Log m_log = LogFactory.getLog( AddMonitorPerformance.class );
	
	/**
	 *  リソース監視情報を登録します。
	 * @see com.clustercontrol.monitor.run.factory.AddMonitor#addCheckInfo()
	 */
	@Override
	public boolean addCheckInfo() throws CreateException, NamingException{
		// 収集IDを生成して設定
		String collectorId = (CollectorUtil.generateGUID(this));
		
		// 性能監視情報を設定
		MonitorPerfCheckInfo mpInfo = (MonitorPerfCheckInfo)m_monitorInfo.getCheckInfo();
		
		MonitorPerfInfoUtil.getLocalHome().create(
				m_monitorInfo.getMonitorTypeId(),
				m_monitorInfo.getMonitorId(),
				collectorId,
				mpInfo.getItemCode(),
				mpInfo.getDeviceIndex(),
				mpInfo.getDeviceName(),
				mpInfo.getDisplayName());
		
		// 収集項目情報を保持するリスト
		ArrayList itemList = new ArrayList();
		
		// 収集項目情報を生成
		CollectorItemInfo itemInfo = new CollectorItemInfo(
				mpInfo.getCollectorId(),
				mpInfo.getItemCode(),
				mpInfo.getDisplayName()
				);
		
		itemList.add(itemInfo);
		
		// 性能管理の収集に登録
		ModifySchedule scheduler = new ModifySchedule();
		boolean result = scheduler.addSchedule(
				m_monitorInfo.getMonitorId(),
				collectorId,
				m_monitorInfo.getFacilityId(),
				m_monitorInfo.getRunInterval(),
				itemList,
				m_monitorInfo.getValid());
		
		return result;
	}

	/**
	 * 監視設定情報を登録します。
	 * 
	 * @return 登録に成功した場合、true
	 * @throws CreateException
	 * @throws FinderException
	 * @throws SchedulerException
	 * @throws ParseException
	 * @throws NamingException
	 */
	@Override
	public boolean addMonitorInfo(String user) throws CreateException, FinderException, SchedulerException, ParseException, NamingException {
		
		try 
		{
			Timestamp now = new Timestamp(new Date().getTime());
			
			// 監視情報を挿入
			m_monitor = MonitorInfoUtil.getLocalHome().create(
					m_monitorInfo.getMonitorTypeId(),
					m_monitorInfo.getMonitorId(),
					m_monitorInfo.getMonitorType(),
					m_monitorInfo.getDescription(),
					m_monitorInfo.getFacilityId(),
					m_monitorInfo.getRunInterval(),
					m_monitorInfo.getTimeout(),
					m_monitorInfo.getCalendarId(),
					m_monitorInfo.getMonitorBlock(),
					m_monitorInfo.getDeterminationId(),
					m_monitorInfo.getFailurePriority(),
					m_monitorInfo.getApplication(),
					m_monitorInfo.getFailureMessageId(),
					m_monitorInfo.getFailureMessage(),
					m_monitorInfo.getNotifyGroupId(),
					now,
					now,
					user,
					user
			);
			
			
			//通知情報を投入
			if(m_monitorInfo.getNotifyId() != null){
				
				NotifyControllerLocal nc = NotifyControllerUtil.getLocalHome().create();	
				nc.addNotifyRelation(m_monitorInfo.getNotifyId());
			}
			
			// 判定情報を設定
			if(addJudgementInfo()){
				// 監視チェック情報を設定
				if(addCheckInfo()){
					return true;
				}
			}
			return false;
		} catch (CreateException e) {
			outputLog(e, "addMonitorInfo()");
            e.printStackTrace();
			throw e;
		} catch (NamingException e) {
			outputLog(e, "addMonitorInfo()");
			e.printStackTrace();
			throw e;
		}
	}
	
	/**
	 * JNDI名を取得します。
	 * @see com.clustercontrol.monitor.run.factory.AddMonitor#getJndiName()
	 */
	@Override
	public String getJndiName() {
		return MonitorPerfRunManagementHome.JNDI_NAME;
	}
	
	/**
     * アプリケーションログにログを出力
     * 
     * @param e 例外
     */
	private void outputLog(Exception e, String method){
		AplLogger apllog = new AplLogger("PERF", "perf");
		String[] args = {m_monitorInfo.getMonitorTypeId(), m_monitorInfo.getMonitorId() };
        apllog.put("SYS", "007", args);
        m_log.debug(method + ":" + e.getMessage());
	}
}
