/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */
package com.clustercontrol.notify.monitor.ejb.entity;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;

import javax.ejb.EntityBean;
import javax.ejb.FinderException;

import com.clustercontrol.notify.monitor.dao.EventLogDAOImpl;

/**
 * イベント情報のBMP Entity Bean<BR>
 * 
 * @ejb.bean name="EventLog"
 *           jndi-name="EventLog"
 *           type="BMP"
 *          
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 *           
 * @ejb.dao class="com.clustercontrol.notify.monitor.dao.EventLogDAO"
 * impl-class="com.clustercontrol.notify.monitor.dao.EventLogDAOImpl"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     
 * @see com.clustercontrol.notify.monitor.dao.EventLogDAO
 * @see com.clustercontrol.notify.monitor.dao.EventLogDAOImpl
 */
public abstract class EventLogBean implements EntityBean {
	
	/** 監視項目ID。 */
	public String monitorId;
	
	/** プラグインID。 */
	public String pluginId;
	
	/** ファシリティID。 */
	public String facilityId;
	
	/** 受信日時。 */
	public Timestamp outputDate;
	
	/** スコープ。 */
	public String scopeText;
	
	/** アプリケーション。 */
	public String application;
	
	/** メッセージID。 */
	public String messageId;
	
	/** メッセージ。 */
	public String message;
	
	/** オリジナルメッセージ。 */
	public String messageOrg;
	
	/**
	 * 重要度。
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public Integer priority;
	
	/**
	 * 確認フラグ（未／済）。
	 * @see com.clustercontrol.bean.ConfirmConstant
	 */
	public Integer confirmFlg;
	
	/** 確認済み日時。 */
	public Timestamp confirmDate;
	
	/** 確認ユーザ */
	public String confirmUser;
	
	/** 重複カウンタ。 */
	public Integer duplicationCount;
	
	/** 出力日時。 */
	public Timestamp generationDate;
	
	/** 
	 * 抑制フラグ。
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public Integer inhibitedFlg;
	
	/**
	 * イベント情報を生成します。
	 * 
	 * @ejb.create-method
	 * 
	 * @param monitorId 監視項目ID
	 * @param pluginId プラグインID
	 * @param facilityId ファシリティID
	 * @param scopeText スコープ
	 * @param application アプリケーション
	 * @param messageId メッセージID
	 * @param message メッセージ
	 * @param messageOrg オリジナルメッセージ
	 * @param priority 重要度
	 * @param confirmFlg 確認フラグ
	 * @param confirmDate 確認済み日時
	 * @param confirmUser 確認ユーザ
	 * @param duplicationCount 重複カウンタ
	 * @param generationDate 出力日時
	 * @param outputDate 受信日時
	 * @param inhibitedFlg 抑制フラグ
	 * @return プライマリキー
	 * @throws javax.ejb.CreateException
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 * @see com.clustercontrol.bean.ConfirmConstant
	 * @see com.clustercontrol.bean.YesNoConstant
	 * @see com.clustercontrol.notify.monitor.dao.EventLogDAOImpl#create(EventLogBean)
	 */
	public com.clustercontrol.notify.monitor.ejb.entity.EventLogPK ejbCreate(
			String monitorId,
			String pluginId,
			String facilityId,
			String scopeText,
			String application,
			String messageId,
			String message,
			String messageOrg,
			Integer priority,
			Integer confirmFlg,
			Timestamp confirmDate,
			String confirmUser,
			Integer duplicationCount,
			Timestamp generationDate,
			Timestamp outputDate,
			Integer inhibitedFlg) throws javax.ejb.CreateException {
		
		this.monitorId = monitorId;
		this.pluginId = pluginId;
		this.facilityId = facilityId;
		this.scopeText = scopeText;
		this.application = application;
		this.messageId = messageId;
		this.message = message;
		this.messageOrg = messageOrg;
		this.priority = priority;
		this.confirmFlg = confirmFlg;
		this.confirmDate = confirmDate;
		this.confirmUser = confirmUser;
		this.duplicationCount = duplicationCount;
		this.generationDate = generationDate;
		this.outputDate = outputDate;
		this.inhibitedFlg = inhibitedFlg;
		
		return null;
	}
	
	/**
	 * 全てのイベント情報を検索します。
	 * 
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.notify.monitor.dao.EventLogDAOImpl#findAll()
	 */
	public Collection ejbFindAll() throws FinderException {
		return null;
	}
	
	/**
	 * プライマリキーに一致するイベント情報を検索します。
	 * 
	 * @param pk プライマリキー
	 * @return プライマリキー
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.notify.monitor.dao.EventLogDAOImpl#findByPrimaryKey(EventLogPK)
	 */
	public EventLogPK ejbFindByPrimaryKey(EventLogPK pk) throws FinderException {
		return null;
	}
	
	/**
	 * 指定した引数に一致し、重複カウントが最小 かつ 出力日時が最新のイベント情報を検索します。
	 * 
	 * @param monitorId 監視項目ID
	 * @param pluginId プラグインID
	 * @param facilityId ファシリティID
	 * @param generationDate 出力日時
	 * @param inhibitedFlg 抑制フラグ
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 * @see com.clustercontrol.notify.monitor.dao.EventLogDAOImpl#findByGenerationDateOrder(String, String, String, Timestamp, Integer)
	 */
	public Collection ejbFindByGenerationDateOrder(
			String monitorId,
			String pluginId,
			String facilityId,
			Timestamp generationDate,
			Integer inhibitedFlg) throws javax.ejb.FinderException {
		return null;
	}
	
	/**
	 * 指定した引数に一致するイベント情報を検索します。
	 * 
	 * @param monitorId 監視項目ID
	 * @param pluginId プラグインID
	 * @param facilityId ファシリティID
	 * @param generationDate 出力日時
	 * @param messageOrg オリジナルメッセージ
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.notify.monitor.dao.EventLogDAOImpl#findByMessageOrg(String, String, String, Timestamp, String)
	 */
	public Collection ejbFindByMessageOrg(
			String monitorId,
			String pluginId,
			String facilityId,
			Timestamp generationDate,
			String messageOrg) throws FinderException {
		return null;
	}
	
	/**
	 * 指定した引数に一致するイベント情報を検索します。
	 * 
	 * @param facilityId ファシリティIDの配列
	 * @param priority 重要度
	 * @param outputFromDate 受信日時（開始）
	 * @param outputToDate 受信日時（終了）
	 * @param generationFromDate 出力日時（開始）
	 * @param generationToDate 出力日時（終了）
	 * @param application アプリケーション
	 * @param message メッセージ
	 * @param confirmFlg 確認フラグ（未／済）
	 * @param orderByFlg 受信日時の順序（true：昇順、false：降順）
	 * @param limit 問い合わせ限度数
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 * @see com.clustercontrol.bean.ConfirmConstant
	 * @see com.clustercontrol.notify.monitor.dao.EventLogDAOImpl#findEvent(String[], Integer, Timestamp, Timestamp, Timestamp, Timestamp, String, String, Integer, boolean, Integer)
	 */
	public Collection ejbFindEvent(
			String facilityId[],
			Integer priority,
			Timestamp outputFromDate,
			Timestamp outputToDate,
			Timestamp generationFromDate,
			Timestamp generationToDate,
			String application,
			String message,
			Integer confirmFlg,
			String confirmUser,
			boolean orderByFlg, 
			Integer limit) throws FinderException {
		return null;
	}
	
	/**
	 * 指定した引数に一致し、重要度が最高 かつ 受信日時が最新のイベント情報を検索します。
	 * 
	 * @param facilityId ファシリティIDの配列
	 * @param priority 重要度
	 * @param outputFromDate 受信日時（開始）
	 * @param outputToDate 受信日時（終了）
	 * @param generationFromDate 出力日時（開始）
	 * @param generationToDate 出力日時（終了）
	 * @param application アプリケーション
	 * @param message メッセージ
	 * @param confirmFlg 確認フラグ（未／済）
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 * @see com.clustercontrol.bean.ConfirmConstant
	 * @see com.clustercontrol.notify.monitor.dao.EventLogDAOImpl#findHighPriorityEvent(String[], Integer, Timestamp, Timestamp, Timestamp, Timestamp, String, String, Integer)
	 */
	public Collection ejbFindHighPriorityEvent(
			String facilityId[],
			Integer priority,
			Timestamp outputFromDate,
			Timestamp outputToDate,
			Timestamp generationFromDate,
			Timestamp generationToDate,
			String application,
			String message,
			Integer confirmFlg,
			String confirmUser) throws FinderException {
		return null;
	}
	
	/**
	 * 監視項目IDを返します
	 * 
	 * @return 監視項目ID
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 */
	public String getMonitorId() {
		return monitorId;
	}
	
	/**
	 * 監視項目IDを設定します。
	 * 
	 * @param monitorId 監視項目ID
	 * @ejb.interface-method
	 */
	public void setMonitorId(String monitorId) {
		this.monitorId = monitorId;
	}
	
	/**
	 * プラグインIDを返します。
	 * 
	 * @return プラグインID
	 * @ejb.persistent-field 
	 * @ejb.pk-field
	 * @ejb.interface-method
	 */
	public String getPluginId() {
		return pluginId;
	}
	
	/**
	 * プラグインIDを設定します。
	 * 
	 * @param pluginId プラグインID
	 * @ejb.interface-method
	 */
	public void setPluginId(String pluginId) {
		this.pluginId = pluginId;
	}
	
	/**
	 * ファシリティIDを返します
	 * 
	 * @return ファシリティID
	 * @ejb.persistent-field 
	 * @ejb.pk-field
	 * @ejb.interface-method
	 */
	public String getFacilityId() {
		return facilityId;
	}
	
	/**
	 * 受信日時を返します。
	 * 
	 * @return 受信日時
	 * @ejb.persistent-field 
	 * @ejb.pk-field
	 * @ejb.interface-method
	 */
	public Timestamp getOutputDate() {
		return outputDate;
	}
	
	/**
	 * 受信日時を設定します。
	 * 
	 * @param outputDate 受信日時
	 * @ejb.interface-method
	 */
	public void setOutputDate(Timestamp outputDate) {
		this.outputDate = outputDate;
	}
	
	/**
	 * ファシリティIDを設定します。
	 * 
	 * @param facilityId ファシリティID
	 * @ejb.interface-method
	 */
	public void setFacilityId(String facilityId) {
		this.facilityId = facilityId;
	}
	
	/**
	 * アプリケーションを返します。
	 * 
	 * @return アプリケーション
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public String getApplication() {
		return application;
	}
	
	/**
	 * アプリケーションを設定します。
	 * 
	 * @param application アプリケーション
	 * @ejb.interface-method
	 */
	public void setApplication(String application) {
		this.application = application;
	}
	
	/**
	 * 確認済み日時を返します。
	 * 
	 * @return 確認済み日時
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public Timestamp getConfirmDate() {
		return confirmDate;
	}
	
	/**
	 * 確認済み日時を設定します。
	 * 
	 * @param confirmDate 確認済み日時
	 * @ejb.interface-method
	 */
	public void setConfirmDate(Timestamp confirmDate) {
		this.confirmDate = confirmDate;
	}
	
	/**
	 * 確認フラグ（未／済）を返します。
	 * 
	 * @return 確認フラグ（未／済）
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @see com.clustercontrol.bean.ConfirmConstant 
	 */
	public Integer getConfirmFlg() {
		return confirmFlg;
	}
	
	/**
	 * 確認フラグ（未／済）を設定します。
	 * 
	 * @param confirmFlg 確認フラグ（未／済）
	 * @ejb.interface-method
	 * 
	 * @see com.clustercontrol.bean.ConfirmConstant
	 */
	public void setConfirmFlg(Integer confirmFlg) {
		this.confirmFlg = confirmFlg;
	}
	
	/**
	 * 確認処理を実施したユーザを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return
	 */
	public String getConfirmUser() {
		return confirmUser;
	}
	
	/**
	 * 確認を実施したユーザを設定します。
	 * 
	 * @param confirmUser 確認ユーザ
	 * @ejb.interface-method
	 * 
	 */	
	public void setConfirmUser(String confirmUser) {
		this.confirmUser = confirmUser;
	}
	
	/**
	 * 重複カウンタを返します。
	 * 
	 * @return 重複カウンタ
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public Integer getDuplicationCount() {
		return duplicationCount;
	}
	
	/**
	 * 重複カウンタを設定します。
	 * 
	 * @param duplicationCount 重複カウンタ
	 * @ejb.interface-method
	 */
	public void setDuplicationCount(Integer duplicationCount) {
		this.duplicationCount = duplicationCount;
	}
	
	/**
	 * 出力日時を返します。
	 * 
	 * @return 出力日時
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public Timestamp getGenerationDate() {
		return generationDate;
	}
	
	/**
	 * 出力日時を設定します。
	 * 
	 * @param generationDate 出力日時
	 * @ejb.interface-method
	 */
	public void setGenerationDate(Timestamp generationDate) {
		this.generationDate = generationDate;
	}
	
	/**
	 * 抑制フラグを返します。
	 * 
	 * @return 抑制フラグ
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public Integer getInhibitedFlg() {
		return inhibitedFlg;
	}
	
	/**
	 * 抑制フラグを設定します。
	 * 
	 * @param inhibitedFlg 抑制フラグ
	 * @ejb.interface-method
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setInhibitedFlg(Integer inhibitedFlg) {
		this.inhibitedFlg = inhibitedFlg;
	}
	
	/**
	 * メッセージを返します。
	 * 
	 * @return メッセージ
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public String getMessage() {
		return message;
	}
	
	/**
	 * メッセージを設定します。
	 * 
	 * @param message メッセージ
	 * @ejb.interface-method
	 */
	public void setMessage(String message) {
		this.message = message;
	}
	
	/**
	 * メッセージIDを返します。
	 * 
	 * @return メッセージID
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public String getMessageId() {
		return messageId;
	}
	
	/**
	 * メッセージIDを設定します。
	 * 
	 * @param messageId メッセージID
	 * @ejb.interface-method
	 */
	public void setMessageId(String messageId) {
		this.messageId = messageId;
	}
	
	/**
	 * オリジナルメッセージを返します。
	 * 
	 * @return オリジナルメッセージ
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public String getMessageOrg() {
		return messageOrg;
	}
	
	/**
	 * オリジナルメッセージを設定します。
	 * 
	 * @param messageOrg オリジナルメッセージ
	 * @ejb.interface-method
	 */
	public void setMessageOrg(String messageOrg) {
		this.messageOrg = messageOrg;
	}
	
	/**
	 * 重要度を返します。
	 * 
	 * @return 重要度 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public Integer getPriority() {
		return priority;
	}
	
	/**
	 * 重要度を設定します。
	 * 
	 * @param priority 重要度
	 * @ejb.interface-method
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public void setPriority(Integer priority) {
		this.priority = priority;
	}
	
	/**
	 * スコープを返します。
	 * 
	 * @return スコープ
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public String getScopeText() {
		return scopeText;
	}
	
	/**
	 * スコープを設定します。
	 * 
	 * @param scopeText スコープ
	 * @ejb.interface-method
	 */
	public void setScopeText(String scopeText) {
		this.scopeText = scopeText;
	}
	
	/**
	 * イベントの確認フラグ（未／済）を更新するホームメソッドです。
	 * 確認フラグを更新し、確認済みの場合は確認済み日時を更新します。
	 * 
	 * @ejb.home-method  view-type = "both"
	 * 
	 * @param facilityIds ファシリティIDの配列
	 * @param priority 重要度
	 * @param outputFromDate 受信日時（開始）
	 * @param outputToDate 受信日時（終了）
	 * @param generationFromDate 出力日時（開始）
	 * @param generationToDate 出力日時（終了）
	 * @param application アプリケーション
	 * @param message メッセージ
	 * @param selectConfirmFlg 設定する確認フラグと逆の状態の確認フラグ（未／済）
	 * @param setConfirmFlg 確認フラグ（未／済）
	 * @param confirmUser 確認を実施したユーザ
	 * @throws SQLException
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 * @see com.clustercontrol.bean.ConfirmConstant
	 * @see com.clustercontrol.notify.monitor.dao.EventLogDAOImpl#confirmEvent(String[], Integer, Timestamp, Timestamp, Timestamp, Timestamp, String, String, Integer, Integer, String)
	 */
	public void ejbHomeBatchConfirm(String[] facilityIds, Integer priority,
			Timestamp outputFromDate, Timestamp outputToDate,
			Timestamp generationFromDate, Timestamp generationToDate,
			String application, String message, Integer selectConfirmFlg,
			Integer setConfirmFlg, String confirmUser)
	throws SQLException {
		EventLogDAOImpl dao = new EventLogDAOImpl();
		
		dao.confirmEvent(
				facilityIds,
				priority,
				outputFromDate,
				outputToDate,
				generationFromDate,
				generationToDate,
				application,
				message,
				selectConfirmFlg,
				setConfirmFlg,
				confirmUser
		);
	}
	
	/**
	 * 引数で指定した条件と一致するイベントの件数を取得するホームメソッドです。
	 * 
	 * @ejb.home-method  view-type = "both"
	 * 
	 * @param facilityId ファシリティIDの配列
	 * @param priority 重要度
	 * @param outputFromDate 受信日時（開始）
	 * @param outputToDate 受信日時（終了）
	 * @param generationFromDate 出力日時（開始）
	 * @param generationToDate 出力日時（終了日時）
	 * @param application アプリケーション
	 * @param message メッセージ
	 * @param confirmFlg 確認フラグ（未／済）
	 * @return イベント件数
	 * @throws SQLException
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 * @see com.clustercontrol.bean.ConfirmConstant
	 * @see com.clustercontrol.notify.monitor.dao.EventLogDAOImpl#countEvent(String[], Integer, Timestamp, Timestamp, Timestamp, Timestamp, String, String, Integer)
	 */
	public int ejbHomeCountEvent(
			String facilityId[],
			Integer priority,
			Timestamp outputFromDate,
			Timestamp outputToDate,
			Timestamp generationFromDate,
			Timestamp generationToDate,
			String application,
			String message,
			Integer confirmFlg,
			String confirmUser)
	throws SQLException {
		EventLogDAOImpl dao = new EventLogDAOImpl();
		
		return dao.countEvent(
				facilityId,
				priority,
				outputFromDate,
				outputToDate,
				generationFromDate,
				generationToDate,
				application,
				message,
				confirmFlg,
				confirmUser			
		);
	}
}
