/*
 
Copyright (C) 2008 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.mail.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Locale;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.notify.mail.ejb.session.MailTemplateController;
import com.clustercontrol.notify.mail.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * メールテンプレート情報一覧のテーブル定義情報を取得するクライアント側アクションクラス<BR>
 * 
 * @version 2.4.0
 * @since 2.4.0
 */
public class GetMailTemplateListTableDefine {

    /**
     * メールテンプレート情報一覧のテーブル定義情報を返します。<BR>
     * マネージャにSessionBean経由でアクセスします。
     * 
     * @return テーブル定義情報（{@link com.clustercontrol.bean.TableColumnInfo}のリスト）
     * 
     * @see com.clustercontrol.notify.mail.util.EjbConnectionManager
	 * @see com.clustercontrol.notify.mail.ejb.session.MailTemplateController
	 * @see com.clustercontrol.notify.mail.ejb.session.MailTemplateControllerBean#getMailTemplateListTableDefine(java.util.Locale)
     */
    public static ArrayList get() {
    	MailTemplateController mailTemplate = EjbConnectionManager.getConnectionManager()
                .getMailTemplateController();

        ArrayList tableDefine = null;
        try {
            tableDefine = mailTemplate.getMailTemplateListTableDefine(Locale.getDefault());
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        }
        return tableDefine;
    }
}