/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.calendar.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;

import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.bean.Property;
import com.clustercontrol.calendar.ejb.session.CalendarController;
import com.clustercontrol.calendar.factory.CalendarProperty;
import com.clustercontrol.calendar.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;

/**
 * カレンダを登録するクライアント側アクションクラス<BR>
 * 
 * @version 2.2.0
 * @since 2.0.0
 */
public class AddCalendarProperty {
	
	/**
	 * 指定したカレンダを追加します。<BR>
	 * 
	 * @param property 属性情報
	 * @return 登録に成功した場合、true
	 */
	public boolean add(Property property) {
    	Property copy = PropertyUtil.copy(property);
        PropertyUtil.deletePropertyDefine(copy);
        
		CalendarController calendar = 
			EjbConnectionManager.getConnectionManager().getCalendarController();
		
		boolean result = false;
		try {
			calendar.addCalendar(copy);
			result = true;
		} catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
		} catch (NamingException e) {
		} catch (CreateException e) {
			if(e instanceof DuplicateKeyException){
				// カレンダIDが重複している場合、エラーダイアログを表示する
				
				//カレンダID取得
		        ArrayList values = PropertyUtil.getPropertyValue(copy, CalendarProperty.ID);
				String args[] = { (String)values.get(0) };
				
	            MessageDialog.openInformation(
	            		null, 
	            		Messages.getString("message"),
	                    Messages.getString("message.calendar.27", args));
	            return result;
			}
		}
		
		if(result){
        	MessageDialog.openInformation(
        			null, 
        			Messages.getString("successful"), 
        			Messages.getString("message.calendar.1"));
		}
		else{
        	MessageDialog.openError(
        			null, 
        			Messages.getString("failed"), 
        			Messages.getString("message.calendar.2"));
		}
    	
    	return result;
	}
}