/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
*/

/**
 * 通知のタイプを定数として格納するクラスです。
 * 
 * @version 3.0.0
 * @since 3.0.0
 */
package com.clustercontrol.bean;

import java.util.ArrayList;

import com.clustercontrol.util.Messages;

public class NotifyTypeConstant {
	
	/*通知タイプとコード*/
	public static final int TYPE_STATUS = 0;
	public static final int TYPE_EVENT = 1;
	public static final int TYPE_MAIL = 2;
	public static final int TYPE_JOB = 3;
	public static final int TYPE_LOG_ESCALATE=4;
	
	/*通知タイプ文字列*/
	public static final String STRING_STATUS = Messages.getString("notifies.status");
	public static final String STRING_EVENT = Messages.getString("notifies.event");
	public static final String STRING_MAIL = Messages.getString("notifies.mail");
	public static final String STRING_JOB = Messages.getString("notifies.job");
	public static final String STRING_LOG_ESCALATE = Messages.getString("notifies.log.escalate");
	
	/*通知タイプダイアログクラス*/
    public static final String DIALOG_STATUS = "com.clustercontrol.notify.dialog.NotifyStatusCreateDialog";
    public static final String DIALOG_EVENT = "com.clustercontrol.notify.dialog.NotifyEventCreateDialog";
    public static final String DIALOG_MAIL = "com.clustercontrol.notify.dialog.NotifyMailCreateDialog";
    public static final String DIALOG_JOB = "com.clustercontrol.notify.dialog.NotifyJobCreateDialog";
    public static final String DIALOG_LOG_ESCALATE = "com.clustercontrol.notify.dialog.NotifyLogEscalateCreateDialog";
    
    
	/**
	 * 種別から文字列に変換します。
	 * 
	 * @param type 種別
	 * @return 文字列
	 */
	public static String typeToString(int type) {
		
		if (type == TYPE_STATUS) {
			return STRING_STATUS;
		} else if (type == TYPE_EVENT) {
			return STRING_EVENT;
		} else if (type == TYPE_MAIL) {
			return STRING_MAIL;
		} else if (type == TYPE_JOB) {
			return STRING_JOB;
		} else if (type == TYPE_LOG_ESCALATE) {
			return STRING_LOG_ESCALATE;
		} 
		return "";
	}
    
	/**
	 * 種別から文字列に変換します。
	 * 
	 * @param type 種別
	 * @return 文字列
	 */
	public static int stringToType(String typeString) {
		
		if (typeString.equals(STRING_STATUS)){
			return TYPE_STATUS;
		} else if (typeString.equals(STRING_EVENT)){
			return TYPE_EVENT;
		} else if (typeString.equals(STRING_MAIL)) {
			return TYPE_MAIL;
		} else if (typeString.equals(STRING_JOB)) {
			return TYPE_JOB;
		} else if (typeString.equals(STRING_LOG_ESCALATE)) {
			return TYPE_LOG_ESCALATE;
		} 
		return 0;
	}
    
	
	
	
	/**
     * 文字列からクラスに変換します。<BR>
     * 
     * @param 文字列
     * @return ダイアログ
     */
    public static String stringToDialog(String string) {
        if (string.equals(STRING_STATUS)) {
            return DIALOG_STATUS;
        } else if (string.equals(STRING_EVENT)) {
            return DIALOG_EVENT;
        } else if (string.equals(STRING_MAIL)) {
            return DIALOG_MAIL;
        } else if (string.equals(STRING_JOB)) {
            return DIALOG_JOB;
        } else if (string.equals(STRING_LOG_ESCALATE)) {
        	return DIALOG_LOG_ESCALATE;
        }
        return "";
    }
    
    /**
     * 種別からクラスに変換します。<BR>
     * 
     * @param 文字列
     * @return ダイアログ
     */
    public static String typeToDialog(int type) {
        if (type == TYPE_STATUS) {
            return DIALOG_STATUS;
        } else if (type == TYPE_EVENT) {
            return DIALOG_EVENT;
        } else if (type == TYPE_MAIL) {
            return DIALOG_MAIL;
        } else if (type == TYPE_JOB) {
            return DIALOG_JOB;
        } else if (type == TYPE_LOG_ESCALATE) {
        	return DIALOG_LOG_ESCALATE;
        }
        return "";
    }
    
    /**
     * 各通知の定義情報をArrayListに格納し返します。<BR>
     * 
     * @return ArrayList
     */
    public static ArrayList<String> getNotifyType() {
    	 ArrayList<String> list = new ArrayList<String>();
    	 list.add(STRING_STATUS);
    	 list.add(STRING_EVENT);
    	 list.add(STRING_MAIL);
    	 list.add(STRING_JOB);
    	 list.add(STRING_LOG_ESCALATE);
    	 
    	 return list;
    }
}
