/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.accesscontrol.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.accesscontrol.dialog.UserFilterDialog;
import com.clustercontrol.accesscontrol.view.UserListView;
import com.clustercontrol.bean.Property;
import com.clustercontrol.util.PropertyUtil;

/**
 * アクセス[ユーザ]ビューの「フィルタ処理」のアクションクラス<BR>
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class UserFilterAction implements IViewActionDelegate {
	/** アクションID */
	public static final String ID = "com.clustercontrol.accesscontrol.view.action.UserFilterAction";
	/** ビュー */
    private IViewPart viewPart;

    /**
     * ビューを保持します。ワークベンチにロードされた際に呼ばれます。
     * 
     * @param view ビューのインスタンス
     * 
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart viewPart) {
        this.viewPart = viewPart;
    }

    /**
     * アクセス[ユーザ]ビューの「フィルタ処理」のアクション<BR>
     * 
     * アクセス[ユーザ]ビューの「フィルタ処理」が押された場合に、<BR>
     * アクセス[ユーザのフィルタ処理]ダイアログを表示し、
     * フィルタ条件に一致するアクセス[ユーザ]ビューを表示します。
     * <p>
	 * <ol>
	 * <li>アクセス[ユーザのフィルタ処理]ダイアログを表示します。</li>
	 * <li>アクセス[ユーザ]ビューにフィルタ条件を設定します。</li>
	 * <li>アクセス[ユーザ]ビューを更新します。</li>
	 * </ol>
     * 
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     * @see com.clustercontrol.accesscontrol.dialog.UserFilterDialog
     * @see com.clustercontrol.accesscontrol.view.UserListView
     */
    public void run(IAction action) {
        // ユーザ一覧より、選択されているユーザのUIDを取得

        UserListView view = (UserListView) this.viewPart
                .getAdapter(UserListView.class);

        if (action.isChecked()) {
            // ダイアログを生成
            UserFilterDialog dialog = new UserFilterDialog(this.viewPart
                    .getSite().getShell());

            // ダイアログにて変更が選択された場合、入力内容をもって登録を行う。
            if (dialog.open() == IDialogConstants.OK_ID) {
                Property condition = dialog.getInputData();

                PropertyUtil.deletePropertyDefine(condition);
                view.update(condition);
            } else {
                action.setChecked(false);
            }
        } else {
            view.update(null);
        }
    }

    /* (non-Javadoc)
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {
    }
}