/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.convert;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.base.JRBasePrintFrame;
import net.sf.jasperreports.engine.convert.ConvertVisitor;
import net.sf.jasperreports.engine.convert.ElementConverter;
import net.sf.jasperreports.engine.convert.FrameConverter;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.design.JRDesignFrame;

public class CrosstabConverter
extends FrameConverter {
    private static final CrosstabConverter INSTANCE = new CrosstabConverter();

    private CrosstabConverter() {
    }

    public static ElementConverter getInstance() {
        return INSTANCE;
    }

    public JRPrintElement convert(ReportConverter reportConverter, JRElement element) {
        JRBasePrintFrame printFrame = new JRBasePrintFrame(reportConverter.getDefaultStyleProvider());
        JRCrosstab crosstab = (JRCrosstab)element;
        this.copyElement(reportConverter, crosstab, printFrame);
        List children = this.getCrosstabChildren(reportConverter, crosstab);
        if (children != null && children.size() > 0) {
            ConvertVisitor convertVisitor = new ConvertVisitor(reportConverter, printFrame);
            for (int i = 0; i < children.size(); ++i) {
                ((JRChild)children.get(i)).visit(convertVisitor);
            }
        }
        return printFrame;
    }

    private List getCrosstabChildren(ReportConverter reportConverter, JRCrosstab crosstab) {
        ArrayList<JRFrame> crosstabElements = new ArrayList<JRFrame>();
        JRCrosstabRowGroup[] rowGroups = crosstab.getRowGroups();
        int rowHeadersXOffset = 0;
        for (int i = 0; i < rowGroups.length; ++i) {
            rowHeadersXOffset += rowGroups[i].getWidth();
        }
        JRCrosstabColumnGroup[] columnGroups = crosstab.getColumnGroups();
        int colHeadersYOffset = 0;
        for (int i = 0; i < columnGroups.length; ++i) {
            colHeadersYOffset += columnGroups[i].getHeight();
        }
        JRCellContents headerCell = crosstab.getHeaderCell();
        if (headerCell != null && headerCell.getWidth() != 0 && headerCell.getHeight() != 0) {
            crosstabElements.add(this.getCrosstabCellFrame(reportConverter, headerCell, 0, 0, false, false, false));
        }
        this.addCrosstabColumnHeaders(reportConverter, crosstab, rowHeadersXOffset, crosstabElements);
        this.addCrosstabRows(reportConverter, crosstab, rowHeadersXOffset, colHeadersYOffset, crosstabElements);
        if (crosstab.getRunDirection() == 1) {
            this.mirrorElements(crosstabElements, crosstab.getX(), crosstab.getWidth());
        }
        return crosstabElements;
    }

    private void mirrorElements(List elements, int x, int width) {
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            JRElement element = (JRElement)it.next();
            int mirrorX = 2 * x + width - element.getX() - element.getWidth();
            element.setX(mirrorX);
        }
    }

    private JRFrame getCrosstabCellFrame(ReportConverter reportConverter, JRCellContents cell, int x, int y, boolean left, boolean right, boolean top) {
        List children;
        JRDesignFrame frame = new JRDesignFrame(cell.getDefaultStyleProvider());
        frame.setX(x);
        frame.setY(y);
        frame.setWidth(cell.getWidth());
        frame.setHeight(cell.getHeight());
        frame.setMode(cell.getMode());
        frame.setBackcolor(cell.getBackcolor());
        frame.setStyle(reportConverter.resolveStyle(cell));
        JRBox box = cell.getBox();
        if (box != null) {
            boolean copyTop;
            frame.setBox(box);
            boolean copyLeft = left && box.getLeftBorder() == 0 && box.getRightBorder() != 0;
            boolean copyRight = right && box.getRightBorder() == 0 && box.getLeftBorder() != 0;
            boolean bl = copyTop = top && box.getTopBorder() == 0 && box.getBottomBorder() != 0;
            if (copyLeft) {
                frame.setLeftBorder(box.getRightBorder());
                frame.setLeftBorderColor(box.getRightBorderColor());
            }
            if (copyRight) {
                frame.setRightBorder(box.getLeftBorder());
                frame.setRightBorderColor(box.getLeftBorderColor());
            }
            if (copyTop) {
                frame.setTopBorder(box.getBottomBorder());
                frame.setTopBorderColor(box.getBottomBorderColor());
            }
        }
        if ((children = cell.getChildren()) != null) {
            Iterator it = children.iterator();
            while (it.hasNext()) {
                JRChild child = (JRChild)it.next();
                if (child instanceof JRElement) {
                    frame.addElement((JRElement)child);
                    continue;
                }
                if (!(child instanceof JRElementGroup)) continue;
                frame.addElementGroup((JRElementGroup)child);
            }
        }
        return frame;
    }

    private void addCrosstabColumnHeaders(ReportConverter reportConverter, JRCrosstab crosstab, int rowHeadersXOffset, List crosstabElements) {
        JRCrosstabColumnGroup[] groups = crosstab.getColumnGroups();
        int x = 0;
        int y = 0;
        for (int i = 0; i < groups.length; ++i) {
            JRCellContents totalHeader;
            JRCellContents header;
            boolean firstOnRow;
            JRCellContents totalHeader2;
            JRCrosstabColumnGroup group = groups[i];
            if (group.getTotalPosition() == 1 && (totalHeader2 = group.getTotalHeader()).getWidth() != 0 && totalHeader2.getHeight() != 0) {
                firstOnRow = x == 0 && crosstab.getHeaderCell() == null;
                crosstabElements.add(this.getCrosstabCellFrame(reportConverter, totalHeader2, rowHeadersXOffset + x, y, firstOnRow && crosstab.getRunDirection() == 0, firstOnRow && crosstab.getRunDirection() == 1, false));
                x += totalHeader2.getWidth();
            }
            if ((header = group.getHeader()).getWidth() != 0 && header.getHeight() != 0) {
                firstOnRow = x == 0 && crosstab.getHeaderCell() == null;
                crosstabElements.add(this.getCrosstabCellFrame(reportConverter, header, rowHeadersXOffset + x, y, firstOnRow && crosstab.getRunDirection() == 0, firstOnRow && crosstab.getRunDirection() == 1, false));
            }
            if (group.getTotalPosition() == 2 && (totalHeader = group.getTotalHeader()).getWidth() != 0 && totalHeader.getHeight() != 0) {
                crosstabElements.add(this.getCrosstabCellFrame(reportConverter, totalHeader, rowHeadersXOffset + x + header.getWidth(), y, false, false, false));
            }
            y += group.getHeight();
        }
    }

    private void addCrosstabRows(ReportConverter reportConverter, JRCrosstab crosstab, int rowHeadersXOffset, int colHeadersYOffset, List crosstabElements) {
        JRCrosstabRowGroup[] groups = crosstab.getRowGroups();
        int x = 0;
        int y = 0;
        for (int i = 0; i < groups.length; ++i) {
            JRCellContents totalHeader;
            JRCellContents header;
            JRCellContents totalHeader2;
            JRCrosstabRowGroup group = groups[i];
            if (group.getTotalPosition() == 1 && (totalHeader2 = group.getTotalHeader()).getWidth() != 0 && totalHeader2.getHeight() != 0) {
                crosstabElements.add(this.getCrosstabCellFrame(reportConverter, totalHeader2, x, colHeadersYOffset + y, false, false, y == 0 && crosstab.getHeaderCell() == null));
                this.addCrosstabDataCellsRow(reportConverter, crosstab, rowHeadersXOffset, colHeadersYOffset + y, i, crosstabElements);
                y += totalHeader2.getHeight();
            }
            if ((header = group.getHeader()).getWidth() != 0 && header.getHeight() != 0) {
                crosstabElements.add(this.getCrosstabCellFrame(reportConverter, header, x, colHeadersYOffset + y, false, false, y == 0 && crosstab.getHeaderCell() == null));
            }
            if (i == groups.length - 1) {
                this.addCrosstabDataCellsRow(reportConverter, crosstab, rowHeadersXOffset, colHeadersYOffset + y, groups.length, crosstabElements);
            }
            if (group.getTotalPosition() == 2 && (totalHeader = group.getTotalHeader()).getWidth() != 0 && totalHeader.getHeight() != 0) {
                crosstabElements.add(this.getCrosstabCellFrame(reportConverter, totalHeader, x, colHeadersYOffset + y + header.getHeight(), false, false, false));
                this.addCrosstabDataCellsRow(reportConverter, crosstab, rowHeadersXOffset, colHeadersYOffset + y + header.getHeight(), i, crosstabElements);
            }
            x += group.getWidth();
        }
    }

    private void addCrosstabDataCellsRow(ReportConverter reportConverter, JRCrosstab crosstab, int rowOffsetX, int rowOffsetY, int rowIndex, List crosstabElements) {
        JRCrosstabColumnGroup[] colGroups = crosstab.getColumnGroups();
        JRCrosstabCell[][] cells = crosstab.getCells();
        int crosstabX = rowOffsetX;
        int crosstabY = rowOffsetY;
        int x = 0;
        for (int i = 0; i < colGroups.length; ++i) {
            JRCellContents cell;
            JRCrosstabColumnGroup group = colGroups[i];
            if (group.getTotalPosition() == 1 && (cell = cells[rowIndex][i].getContents()).getWidth() != 0 && cell.getHeight() != 0) {
                crosstabElements.add(this.getCrosstabCellFrame(reportConverter, cell, crosstabX + x, crosstabY, false, false, false));
                x += cells[rowIndex][i].getContents().getWidth();
            }
            if (i == colGroups.length - 1 && (cell = cells[rowIndex][colGroups.length].getContents()).getWidth() != 0 && cell.getHeight() != 0) {
                crosstabElements.add(this.getCrosstabCellFrame(reportConverter, cell, crosstabX + x, crosstabY, false, false, false));
            }
            if (group.getTotalPosition() != 2 || (cell = cells[rowIndex][i].getContents()).getWidth() == 0 || cell.getHeight() == 0) continue;
            crosstabElements.add(this.getCrosstabCellFrame(reportConverter, cell, crosstabX + x + group.getHeader().getWidth(), crosstabY, false, false, false));
        }
    }
}

