/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.client;

import java.util.Arrays;

public class PasswordCredential {
    private char[] iPassword;
    private String iHostname;

    public PasswordCredential() {
    }

    public PasswordCredential(String pPassword) {
        this.iPassword = pPassword.toCharArray();
    }

    public PasswordCredential(char[] pPassword) {
        this.iPassword = null;
        if (pPassword != null) {
            this.iPassword = new char[pPassword.length];
            System.arraycopy(pPassword, 0, this.iPassword, 0, pPassword.length);
        }
    }

    public void clearUserPassword() {
        if (this.iPassword != null) {
            for (int i = 0; i < this.iPassword.length; ++i) {
                this.iPassword[i] = '\u0000';
            }
        }
        this.iPassword = null;
    }

    public String getHostName() {
        return this.iHostname;
    }

    public char[] getUserPassword() {
        if (this.iPassword != null) {
            char[] passwordCopy = new char[this.iPassword.length];
            System.arraycopy(this.iPassword, 0, passwordCopy, 0, this.iPassword.length);
            return passwordCopy;
        }
        return null;
    }

    public void setHostName(String pHostname) {
        this.iHostname = pHostname;
    }

    public void setUserPassword(char[] pPassword) {
        this.clearUserPassword();
        if (pPassword != null) {
            this.iPassword = new char[pPassword.length];
            System.arraycopy(pPassword, 0, this.iPassword, 0, pPassword.length);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof PasswordCredential) {
            PasswordCredential that = (PasswordCredential)o;
            if (!(this.iHostname == null && that.iHostname == null || this.iHostname != null && this.iHostname.equals(that.iHostname))) {
                return false;
            }
            return Arrays.equals(this.iPassword, that.iPassword);
        }
        return false;
    }

    public int hashCode() {
        return (this.iHostname != null ? this.iHostname.hashCode() : 0) + (this.iPassword != null ? this.iPassword.hashCode() : 0);
    }
}

